unit BmpCursr;

{ Bitmaps to Mouse Cursors, Copr. 1994 Matthias K"oppe

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

interface

uses WinRes;

function BitmapsToCursor(XHotspot, YHotspot: Integer;
  AndBitmap, XorBitmap: PBitmap): PMyCursor;
function CreateCursor(Xhotspot, Yhotspot, Width, Height: Integer;
  AndBitPlane, XorBitPlane: pointer): PMyCursor;
function ExtractCursorFromBitmap(XHotspot, YHotspot, AndAtX, AndAtY,
  XorAtX, XorAtY, SizeX, SizeY: Integer; Bitmap: PBitmap): PMyCursor;
procedure FreeCursor(Cursor: PMyCursor);
function GetCursorSize(Cursor: PMyCursor): Word;

implementation

function GetCursorSize(Cursor: PMyCursor): Word;
Begin
  GetCursorSize := 8 + Cursor^.mcHeight * Cursor^.mcWidth
End;

procedure FreeCursor(Cursor: PMyCursor);
Begin
  FreeMem(Cursor, GetCursorSize(Cursor))
End;

function DoBitmapToCursor(source, dest: pointer;
  x, y, b, w, h, xormask: Word): pointer; near; external;

{$L bmpcursr.obj (bmpcursr.asm) }

{ Windows-kompatibel }

function CreateCursor(Xhotspot, Yhotspot, Width, Height: Integer;
  AndBitPlane, XorBitPlane: pointer): PMyCursor;
var
  c: PMyCursor;
  w, b: Word;
  p: pointer;
Begin
  w := ((Width + 15) div 16) * 2;
  b := ((Width + 31) div 32) * 4;
  GetMem(c, 8 + 2 * w * Height);
  CreateCursor := c;
  If c <> nil then
  with c^ do Begin
    mcHeight := Height;
    mcWidth := w;
    mcHotSpotX := XHotSpot;
    mcHotSpotY := YHotSpot;
    p := DoBitmapToCursor(AndBitPlane, @mcAnd, Width, Height, b, w, Height, $FFFF);
    DoBitmapToCursor(XorBitPlane, p, Width, Height, b, w, Height, 0)
  End
End;

function Max(a, b: Integer): Integer;
Begin
  If a < b then Max := b else Max := a
End;

function ExtractCursorFromBitmap(XHotspot, YHotspot, AndAtX, AndAtY,
  XorAtX, XorAtY, SizeX, SizeY: Integer; Bitmap: PBitmap): PMyCursor;
var
  at, w: Word;
  c: PMyCursor;
  p: pointer;
Begin
  If (Bitmap = nil) or (Bitmap^.bmBitsPixel <> 1)
  then Begin ExtractCursorFromBitmap := nil; Exit End;
  w := ((SizeX + 15) div 16) * 2;
  GetMem(c, 8 + 2 * w * Bitmap^.bmHeight);
  ExtractCursorFromBitmap := c;
  If c <> nil then
  with c^ do Begin
    mcHeight := SizeY;
    mcWidth := w;
    mcHotSpotX := XHotSpot;
    mcHotSpotY := YHotSpot;
    with Bitmap^ do Begin
      at := bmWidthBytes * (bmHeight - (SizeY + AndAtY)) + (AndAtX shr 3);
      p := DoBitmapToCursor(PChar(bmBits) + at, @mcAnd, bmWidth, bmHeight,
	bmWidthBytes, w, SizeY, $FFFF);
      at := bmWidthBytes * (bmHeight - (SizeY + XorAtY)) + (XorAtX shr 3);
      DoBitmapToCursor(PChar(bmBits) + at, p, bmWidth, bmHeight,
	bmWidthBytes, w, SizeY, 0)
    End
  End
End;

{ untersttzt auch verschieden groe Bitmaps }

function BitmapsToCursor(XHotspot, YHotspot: Integer;
  AndBitmap, XorBitmap: PBitmap): PMyCursor;
var
  xs, ys: Integer;
  w: Word;
  c: PMyCursor;
  p: pointer;
Begin
  If (AndBitmap = nil) or (XorBitmap = nil) or
     (AndBitmap^.bmBitsPixel <> 1) or (XorBitmap^.bmBitsPixel <> 1)
  then Begin BitmapsToCursor := nil; Exit End;
  xs := Max(AndBitmap^.bmWidth, XorBitmap^.bmWidth);
  ys := Max(AndBitmap^.bmHeight, XorBitmap^.bmHeight);
  w := ((xs + 15) div 16) * 2;
  GetMem(c, 8 + 2 * w * ys);
  BitmapsToCursor := c;
  If c <> nil then
  with c^ do Begin
    mcHeight := ys;
    mcWidth := w;
    mcHotSpotX := XHotSpot;
    mcHotSpotY := YHotSpot;
    with AndBitmap^ do
    p := DoBitmapToCursor(bmBits, @mcAnd, bmWidth, bmHeight, bmWidthBytes, w, ys, $FFFF);
    with XorBitmap^ do
    DoBitmapToCursor(bmBits, p, bmWidth, bmHeight, bmWidthBytes, w, ys, 0)
  End
End;

end.
