; Coloumn Cache, 16 colors, Copr. 1994 Matthias Kppe

		INCLUDE	ccachdef.asm
		INCLUDE	grserv.asm

CODE		SEGMENT BYTE PUBLIC

		PUBLIC	Flush_16o, Flush_16t, Setup_16

Cache		EQU	es:[bx].TCacheHeader

	Def_Mapping
	Def_SegToLinear

	;
	; Setup Cache proc
	;                           optimization possible

Setup_16	PROC NEAR
		push	ax
		mov	ax, BytesPerLine
		mul	dx
		pop	cx
		cmp	cx, ClipRect.A.x
		jl	SHORT @@1
		push	cx
		jmp	SHORT @@2
@@1:            push	ClipRect.A.x
@@2:		sar	cx, 3
		mov	Cache.chStartCol, cx
		add	ax, cx
		adc	dx, 0
		push	dx ax
		mov	ax, ActiveSeg
		call    SegToLinear
		pop	cx
		add	ax, cx
		pop	cx
		adc	dx, cx
		call	MapLinear
		mov	WORD PTR Cache.chDest[0], ax
		mov	WORD PTR Cache.chDest[2], dx
		pop	cx
		push	cx
		and	cl, 7
		mov	al, 0FFh
		shr	al, cl
		mov	Cache.chLeftMask, al
		mov	cx, ClipRect.B.x
		and	cl, 7
		mov	ax, 0FF00h
		shr	ax, cl
		mov	Cache.chRightMask, al
		pop	cx
		sar	cx, 3
		mov	Cache.chLeftCol, cx
		mov	ax, ClipRect.B.x
		sar	ax, 3
		mov	Cache.chRightCol, ax
		retn
Setup_16	ENDP

	; Get the byte mask
	;
	; In:	ax	coloumn number
	;
	; Out:	ah	mask

GetMask		PROC NEAR
		mov	dh, Cache.chMask
		cmp	ax, Cache.chLeftCol
		jl	SHORT @@0
		jg	SHORT @@1
		and	dh, Cache.chLeftMask
@@1:		cmp	ax, Cache.chRightCol
		jg	SHORT @@0
		jl	SHORT @@2
		and	dh, Cache.chRightMask
@@2:		mov	ah, dh
		retn
@@0:            add	sp, 2
		add	si, 1			; MapNext req 
		retn				; back to caller
GetMask		ENDP

	;
	; DoFlushCur routines
	;

	; Opaque version

Flush_16o	PROC NEAR
		call	GetMask
		mov	dx, 03ceh		; GC
		mov	al, 08h			; Bit mask
		out	dx, ax
		mov	ax, 0003h		; Data rotate clear
		out	dx, ax
		mov	ax, 0305h		; Write mode 3 -- VGA only
		out	dx, ax
		mov	ax, 0f01h		; Enable set/reset
		out	dx, ax
		mov	al, 00h			; Set/Reset
		mov	ah, BYTE PTR Cache.chBkColor
		out	dx, ax
		mov	cx, Cache.chColHeight
		mov	dx, Cache.chBPL
@@o1:		mov	al, es:[di]
		inc	di
		not	al
		jz	SHORT @@o2
		xchg	al, [si]
@@o2:		add	si, dx
		loop	@@o1
		mov	cx, Cache.chColHeight
		mov	dx, 03ceh
		mov	ah, BYTE PTR Cache.chColor
		mov	al, 00h			; Set/Reset
		out	dx, ax
		mov	dx, Cache.chBPL
@@o3:		sub	si, dx
		dec	di
		mov	al, es:[di]
		or	al, al
		jz	SHORT @@o4
		xchg	al, [si]
@@o4:		loop	@@o3
		inc	si			; screen address of next col
						;  MapNext
		retn
Flush_16o	ENDP

	; Transparent version

Flush_16t	PROC NEAR
		call	GetMask
		mov	dx, 03ceh		; GC
		mov	al, 08h			; Bit mask
		out	dx, ax
		mov	ax, 0003h		; Data rotate clear
		out	dx, ax
		mov	ax, 0305h		; Write mode 3 -- VGA only
		out	dx, ax
		mov	ax, 0f01h		; Enable set/reset
		out	dx, ax
		mov	al, 00h			; Set/Reset
		mov	ah, BYTE PTR Cache.chColor
		out	dx, ax

		mov	cx, Cache.chColHeight
		mov	dx, Cache.chBPL
		push	di si

@@t1:		mov	al, es:[di]
		inc	di
		or	al, al
		jz	SHORT @@t2
		xchg	al, [si]		; read latches - write latches
@@t2:		add	si, dx
		loop	@@t1

		pop	si di
		inc	si			; screen address of next col
		retn
Flush_16t	ENDP

CODE		ENDS

		END
