; FIXEDOP.ASM defines operations on fixed numbers stored in 32-bit regs.
; Copr. 1994 Matthias Kppe

	; roundf rounds a fixed number.

roundf		MACRO	Value
		LOCAL	@NoRound
		sar	Value, 16
		jnc	SHORT @NoRound
		inc	Value
@NoRound:	ENDM

	; mulf returns eax,fixed * Factor,fixed in eax,fixed

mulf		MACRO Factor
		LOCAL	@noround
		imul	Factor
		shrd	eax, edx, 16
		jnc	SHORT @noround
		inc	eax
@noround:	ENDM

	; divf returns eax,fixed / Divisor,fixed in eax, fixed

divf		MACRO Divisor
		mov	edx, eax
		sar	edx, 16
		sal	eax, 16
		idiv	Divisor
		ENDM

	; iabs returns the absolute value of a signed register

iabs		MACRO Value
		LOCAL	@@1
		or	Value, Value
		jns	SHORT @@1
		neg	Value
@@1:
		ENDM

		; mul2Dot14 multiplies eax,fixed with Value,2.14,
		; returning the result in eax.

mul2Dot14       MACRO	Value
		movsx	edx, Value
		sal	edx, 2
		mulf	edx
		ENDM

