Unit MetaGr;

{ Unit MetaGr, Copyright 1994,96 by Daniel Mahrenholz

 $Id: metagr.pas 1.3 1999/02/09 10:47:23 mkoeppe Exp $
 
 Modules:
 
  MetaGr.asm
  MetaFile.asm
  MetaDNor.asm
  MetaDMul.asm
  MetaSet.asm
  Meta256N.asm
  MetaInt.asm
  MetaDum.asm
  MetaGr.con
  MetaGr.str

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

{$A+,B-,D+,F-,G+,O-,R-,S-,X+}

interface

uses Memory, Objects, Vesa;

type
	PMetaBuffer = ^TMetaBuffer;
	TMetaBuffer = Record
			Size: Word;
			Count: Word;
			Top: Word;
			Free: Word;
			Data: Array [0..20] of Word;
		      End;

	TErrorProc = Procedure;

	PColors = ^TColors;
	TColors = Array[0..255,1..3] of Byte;

	PPalettes = ^TPalettes;
	TPalettes = Array[0..16] of Byte;

	FillPatternType = Array[1..8] of Byte;

var
	ErrorProc: TErrorProc;
	MetaError	: Word;

const

{ MetaFile Fehlercodes }

	me_NoError	= 0;
	me_Init		= 1;
	me_Buffer	= 2;
	me_Full		= 3;
	me_Stack	= 4;
	me_Memory	= 5;

{ MetaFile Speicherbedarf }

        mu_Bar           = 10;
        mu_Circle        =  8;
        mu_FillCircle    =  8;
        mu_HoriLine      =  8;
        mu_Line          = 10;
        mu_LineRel       = 10;
        mu_LineTo        = 10;
        mu_PutPixel      =  8;
        mu_Rectangle     = 32;
        mu_SelectGDriver =  2;
        mu_SetColor      =  6;
        mu_SetColormode  =  2;
        mu_SetColors     = 10;
        mu_SetFillColor  =  6;
        mu_SetFillStyle  =  8;
        mu_SetLineStyle  =  6;
        mu_SetWriteMode  =  2;
        mu_VertLine      =  8;



{ MetaGraph Pointer-Qualitten }

	qMetaLine	= 100;
	qChMetaParams	= 100;
	qMetaExtSave	= 100;

{ ColorMode-Konstanten }

	cm16		= 1;
	cm256		= 2;
	cm0		= 4;

{ WriteMode-Konstanten }

	NormalPut 	= 0;
	CopyPut   	= 0;
	XORPut    	= 1;
	ORPut     	= 2;
	ANDPut    	= 3;

{ Farbkonstanten }

	Black        	=  0;
	Blue         	=  1;
	Green        	=  2;
	Cyan         	=  3;
	Red          	=  4;
	Magenta      	=  5;
	Brown        	=  6;
	LightGray    	=  7;
	DarkGray     	=  8;
	LightBlue    	=  9;
	LightGreen   	= 10;
	LightCyan    	= 11;
	LightRed     	= 12;
	LightMagenta 	= 13;
	Yellow       	= 14;
	White        	= 15;
	Border	     	= 16;

{ Linienarten }

	SolidLn   	= 0;
	DottedLn  	= 1;
	CenterLn  	= 2;
	DashedLn  	= 3;
	UserBitLn 	= 4;

{ FillStyle-Konstanten }

	EmptyFill     	= 0;
	SolidFill     	= 1;
	LineFill      	= 2;
	LtSlashFill   	= 3;
	SlashFill     	= 4;
	BkSlashFill   	= 5;
	LtBkSlashFill 	= 6;
	HatchFill     	= 7;
	XHatchFill    	= 8;
	InterleaveFill	= 9;
	WideDotFill   	= 10;
	CloseDotFill  	= 11;
	UserFill      	= 12;

{ Linienbreiten

  Die Konstanten fr die Linienbreiten dienen nur der Kompatibilitt zur
  Unit Graph. Beim Aufruf von SetLineStyle kann eine beliebige Liniendicke
  direkt angegeben werden.
}
	NormWidth 	= 1;
	ThickWidth	= 3;

{ Bar zeichnet ein geflltes Rechteck mit der aktuellen Fllfarbe und
  dem aktuellen Fllmuster. }
	Procedure Bar (x1,y1,x2,y2: Integer);

{ Circle zeichnet einen Kreis mit der aktuellen Zeichenfarbe. }
	Procedure Circle (xm,ym,r: Integer);

{ ClearDevice lscht den gesamten VGA-Speicher. Bei gleichzeitiger
  Verwendung des VGA-Restspeichers (z.B. durch VGAMem) sollte ClearDevice
  nur zu Initialisierungszwecken am Programmanfang verwendet werden. Zum
  Lschen des Bildschirms sollte ClearPage verwendet werden. }
	Procedure ClearDevice;

{ ClearPage lscht die momentan aktive Bildschirmseite. }
	Procedure ClearPage;

{ FillCircle zeichnet einen gefllten Kreis mit Rand. }
	Procedure FillCircle (xm,ym,r: Integer);

{ GetPixel liefert die Farbe eines Punktes innerhalb des aktuellen
  Bildschirmbereiches. Liegt der angegebene Punkt auerhalb, so wird 0 als
  Ergebnis zurckgegeben. }
	Function  GetPixel (x1,y1: Integer): Byte;

{ HoriLine zeichnet eine horizontale Linie. }
	Procedure HoriLine (x1,y1,x2: Integer);

{ Line zeichnet eine beliebige Linie. }
	Procedure Line (x1,y1,x2,y2: Integer);

{ LineRel zeichnet eine Linie relativ zum Zeichenursprung. }
	Procedure LineRel (x1,y1: Integer);

{ LineTo zeichnet eine Linie vom Zeichenursprung zum angegebenen Punkt. }
	Procedure LineTo (x1,y1: Integer);

{ MoveRel verschiebt den Zeichenursprung zum angegebenen Punkt. }
	Procedure MoveRel (x1,y1: Integer);

{ MoveTo verschiebt den Zeichenursprung relative um die angegebenen Werte. }
	Procedure MoveTo (x1,y1: Integer);

{ PutPixel zeichnet einen Punkt in der Farbe Color. }
	Procedure PutPixel (x1,y1: Integer; Color:Word);

{ Reactangle zeichnet ein Rechteck in der aktuellen Zeichenfarbe. }
	Procedure Rectangle (x1,y1,x2,y2: Integer);

{ VertLine zeichnet eine vertikale Linie. }
	Procedure VertLine (x1,y1,y2: Integer);


{ SetColor setzt die Zeichenfarbe. }
	Procedure SetColor (Color: Byte);

{ SetFillColor setzt die Fllfarbe. }
	Procedure SetFillColor (Color: Byte);

{ SetColors setzt Zeichen und Fllfarbe in einem Zug }
	Procedure SetColors (Color: Byte; FillColor: Byte);

{ SetFillStyle setzt das Fllmuster und die Fllfarbe. }
	Procedure SetFillStyle (FillStyle, Color: Byte);

{ SetFillPattern setzt die Bitmasken fr ein benutzerdefiniertes Fllmuster }
	Procedure SetFillPattern(aFillPattern: FillPatternType);

{ SetLineStyle setzt die Linienart und -dicke. Als Liniendicke kann ein
  beliebiger Wert angegeben werden. }
	Procedure SetLineStyle (LineStyle, Pattern, Thickness:Word);

{ SetWriteMode setzt einen der 4 VGA-WriteModi. }
	Procedure SetWriteMode (Mode: Word);


{ SetBorder setzt die Randfarbe des Bildschirms. }
	Procedure SetBorder (Color: Byte);

{ SetPalette belegt einen Paletteneintrag mit der angegebenen Farbe. }
	Procedure SetPalette (Palette, Color: Byte);

{ SetPaletteEntry setzt einen Paletteneintrag in der internen Farbpalette. }
	Procedure SetPaletteEntry (Palette, Color:Byte);

{ SetPalettes setzt einen Block von Palettendefinitionen und die Randfarbe.
  Wird als Adresse der Farbpalette nil bergeben, so werden die Werte der
  internen Farbpalette verwendet. }
	Procedure SetPalettes (Palettes: PPalettes);

{ SetRGBColor bestimmt die Rot-, Grn- und Blaukomponenten fr die
  angegebene Farbe. }
	Procedure SetRGBColor (Color, R, G, B:Byte);

{ SetRGBColorEntry setzt die Farbkomponenten einer Farbe der internen
  Farbtabelle. }
	Procedure SetRGBColorEntry (Color, R, G, B:Byte);

{ SetRGBColors setzt einen Block von Farbdefinitionen. Wird als Adresse der
  Farbdefinitionen nil bergeben, so werden die Definitionen der internen
  Farbpalette verwendet. }
	Procedure SetRGBColors (Colors: PColors; Start, Count:Byte);

{ GetBorder liefert die momentane Randfarbe als Ergebnis zurck. }
	Function  GetBorder: Byte;

{ GetPalette liefert die Farbe zu einem Paletteneintrag. }
	Function  GetPalette (Palette: Byte): Byte;

{ GetPaletteEntry liefert die Farbe eines Paletteneintrages der internen
  Farbpalette.}
	Function  GetPaletteEntry (Palette: Byte): Byte;

{ GetPalettes gibt in einem Block die aktuellen Palettendefinitionen
  sowie die Randfarbe zurck. Wird als Adresse der Palette nil bergeben,
  so werden die Palettendefinitionen in die interne Farbpalette bertragen. }
	Procedure GetPalettes (Palettes: PPalettes);

{ GetRGBColor liefert die Farbkomponenten der angegebenen Farbe. }
	Procedure GetRGBColor (Color:Byte; var R, G, B:Byte);

{ GetRGBColorEntry liefert die Komponenten einer Farbe der internen
  Farbpalette. }
	Procedure GetRGBColorEntry (Color: Byte; var R, G, B:Byte);

{ GetRGBColors gibt einen Block von Farbdefinitionen zurck. Wird als
  Adresse der Farbdefinitionen nil bergeben, so werden die Werte in die
  interne Palette bertragen. }
	Procedure GetRGBColors (Colors: PColors; Start, Count:Byte);


{ ClearBuffer lscht die Aufrufe im angegebenen MetaFile. }
	Procedure ClearBuffer (Buffer:Pointer);

{ DoneMetaGr gibt den fr die MetaFile-Funktionen belegten Speicherplatz
  frei. }
	Procedure DoneMetaGr;

{ DrawBuffer fhrt die in dem angegebenen MetaFile gespeicherten Funktions-
  aufrufe aus. }
	Procedure DrawBuffer (Buffer:Pointer);

{ GetBuffer reserviert Speicherplatz fr ein neues MetaFile und fhrt die
  notwendigen Initialisierungen durch. }
	Function  GetBuffer (Size:Word):Pointer;

{ FreeBuffer gibt den fr ein MetaFile reservierten Speicherplatz frei. }
	Procedure FreeBuffer (Buffer:Pointer);

{ FullBuffer berprft, ob noch Data Bytes Speicherplatz im angegebenen
  MetaFile frei sind. In diesem Fall wird true als Funktionsergebnis
  zurckgegeben, sonst false. }
	Function  FullBuffer (Buffer:Pointer; Data:Word):Boolean;

{ InitMetaGr fhrt die zur Nutzung der MetaFile-Funktionen notwendigen
  Initialisierungen durch. Zustzlich wird ein komplettes 64K-Segment
  auf dem Heap fr interne Funktionen reserviert. }
	Procedure InitMetaGr;

{ LastMetaError liefert den Fehlercode der letzten MetaFile-Operation. }
	Function  LastMetaError: Word;

{ MaxBufferSize liefert die maximale Gre eines Metafiles zurck }
        Function  MaxBufferSize: Word;

{ MetaFunctions liefert true, wenn die MetaFile-Funktionen verfgbar sind. }
	Function  MetaFunctions: Boolean;

{ SaveExt speichert einen beliebigen far-kodierten Funktionsaufruf in das
  aktuelle MetaFile. Die Aufrufkonventionen werden in der Dokumentation
  erlutert. Ein direkter Aufruf sollte nicht erfolgen. }
	Procedure SaveExt;

{ SetBuffer leitet die Aufzeichnungen in das angegebene MetaFile um. }
	Procedure SetBuffer (Buffer:Pointer);

{ SetMetaClipRect setzt den sichtbaren Bildschirmbereich durch die
  Koordinaten. }
	Procedure SetMetaClipRect(x1, y1, x2, y2: Integer);

{ SetMetaClipRectR setzt den sichtbaren Bildschirmbereich durch die
  Datenstruktur. }
	Procedure SetMetaClipRectR(R: TRect);

{ SetMetaOrigin setzt den Koordinatenursprung durch die Koordinaten. }
	Procedure SetMetaOrigin(x1,y1: Integer);

{ SetMetaoriginP setzt den Koodinatenursprung durch die Datenstuktur. }
	Procedure SetMetaOriginP(P: TPoint);

{ SetMetaState setzt die MetaGraph-Flags. }
	Procedure SetMetaState (State:Word);

{ Setzt einzelne MetaState-Flags }
        Procedure SetSingleMS (State: Word);

{ Lscht die angegbenen MetaState-Flags }
        Procedure ClearSingleMS (State: Word);

{ ChMetaParams dient als Schnittstelle zur Unit Gr. }
	Function  ChMetaParams(Cmd: Word; var Buf): Word;

{ LastError gibt den letzten Fehlercode zurck. }
	Function  LastError: Word;

{ Errorcode gibt den Inhalt des AX-Registers zurck. Zu verwenden in hoch-
  sprachlichen Fehlerbehandlungsroutinen }
        Function ErrorCode: Word; INLINE ($90);

{ Der universelle Unterprogrammzuweiser }
	Procedure SelectGDriver(ColorMode: Word; WriteMode: Word);

{ Umschaltung Farbtiefe }
	Procedure SetColorMode(Mode: Word);

{ Einstellung Streckungsfaktor }
	Procedure SetSF(aSF: LongInt);

{ WaitHRetrace wartet auf den nchsten vollen horizontalen Retrace }
	Procedure WaitHRetrace;

{ WaitDispEnable wartet, bis der Kathodenstrahl aktiv ist }
	Procedure WaitDispEnable;

{ WaitDispDisable wartet, bis der Kathodenstrahl deaktiviert ist }
	Procedure WaitDispDisable;

{ Liefert den Status des Kathodenstrahls zurck (1=enable) }
        Function  DispState: Word;

{ WaitVRetrace wartet auf den nchsten vollen vertikalen Retrace }
	Procedure WaitVRetrace;

{ VRetrace liefert true zurck, wenn gerade ein vertikaler Retrace luft }
        Function VRetrace: Boolean;

{ WaitHLine wartet bis zur angegebenen Bildschirmzeile }
        Procedure WaitHLine (HLine: Word);

{ AssignVideoSeg sorgt fr die Neuzuweisung des statischen VideoSegments
  ein Aufruf sollte nach jeder Vernderung der erweiterten Segmentregister
  FS und GS erfolgen }
	Procedure AssignVideoSeg;

	Procedure LockLine;
	Procedure UnLockLine;

        Function MGVersion: LongInt;

Var
	CSAlias: Word;

{$ifdef DPMI}
	Function GetCSAlias(CS: Word): Word;

Implementation

Uses Crt, Gr;


function GetCSAlias(CS: Word): Word; external 'KERNEL' index 171;

procedure PreparePatternTransfer;
Var
	UnitCS: Word;
Begin
  asm
	mov	ax, cs
	mov	UnitCS, ax
  end;
  csAlias:=GetCSAlias(UnitCS);
End;

{$else}
Implementation

Uses Crt, Gr;

{$endif}

Var

	{ Default Color Palettes }
	MPalettes:^TPalettes;

	{ Default RGB Colors }
	MColors:^TColors;

	{ Darstellungsmodusdaten }
	ColorMode: Word;
	WriteMode: Word;

	{ globale Metafile Daten }
	BackPtr		: Word; { Rcksprungadresse bei Metafile-Wiedergabe }
	EndPtr		: Word; { Wiedergabeabbruch-Sprungadresse }
	ExtPtr		: Word; { Adresse externe Speicherung }
	ValidBuffer	: Word; { Gltigkeit Aufzeichnungspuffer }
	ValidStack	: Word; { Gltigkeit Wiedergabestack }
	DrawPtr		: Pointer; { Aufzeichnungsziel }
	MetaStack	: Pointer; { Wiedergabestack }

	{ Zeichenmusterdaten }
	FillPattern:Array[1..128] of Word;	 { Flchenfllmuster }
	LnPattern:Array[1..8] of Word;           { Linienmuster }
	FillBase,FillNext,FillCur,FillFlag:Word; { Steuerdaten Musterauswahl }

	{ globale Zeichen-/Fllfarben }
	HColor16, DColor16, FColor16: Word;	{ aufbereitete Farben fr cm16 }
	HColor256, DColor256, FColor256: LongInt;	{ aufbereitete Farben fr cm256 }

	SF : LongInt;	{ Skalierungsfaktor zum Verzerrungsausgleich }

	{ Einsprungadressen der aktuellen Zeichenroutinen }
	P_VL, P_HL, P_Bar, P_Point, P_POintF, P_GetP, P_Line: Word;
	P_LineD, F_Point: Word;

	{ Koordinaten des aktuellen Zeichenpunktes }
	last_x, last_y: Integer;

	{ sonstige Daten }
	daLnStyle,dax1,day1,dax2,day2:Word;
	daError,daDivConst,daThickness,daFillStyle,daWriteMode:Word;
	fx,fy: LongInt;
	fc,xa,xe,xd,ya,ye,yd,Color,MGCMode,Style: Word;

	NextNotify: TNotifyProc;

	LineLock: Boolean;

{$L MetaFile }
{$L MetaSet  }
{$L MetaGr   }
{$L Meta256  }
{$L Meta16   }
{$L MetaDum  }
{$L MetaInt  }

procedure DefaultErrorProc; 	far; 	external;
function  LastError; 			external;
procedure PutPixel; 			external;
function  GetPixel; 			external;
procedure HoriLine; 			external;
procedure VertLine; 			external;
procedure Line; 			external;
procedure MoveTo; 			external;
procedure MoveRel; 			external;
procedure LineTo; 			external;
procedure LineRel; 			external;
procedure Rectangle; 			external;
procedure Bar; 				external;
procedure Circle; 			external;
procedure FillCircle; 			external;
procedure SetColor; 			external;
procedure SetFillColor; 		external;
procedure SetColors; 			external;
procedure SetFillStyle; 		external;
procedure SetFillPattern; 		external;
procedure SetLineStyle; 		external;
procedure SetMetaState; 		external;
function  MetaFunctions; 		external;
procedure ClearDevice; 			external;
procedure ClearPage; 			external;
procedure SetRGBColor; 			external;
procedure SetRGBColors; 		external;
procedure SetRGBColorEntry; 		external;
procedure GetRGBColorEntry; 		external;
procedure GetRGBColors; 		external;
procedure SetPalette; 			external;
function  GetPalette; 			external;
procedure GetRGBColor; 			external;
procedure SetPaletteEntry; 		external;
function  GetPaletteEntry; 		external;
procedure SetPalettes; 			external;
procedure GetPalettes; 			external;
procedure SetBorder; 			external;
function  GetBorder; 			external;
procedure SetMetaOrigin; 		external;
procedure SetMetaOriginP; 		external;
procedure SetMetaClipRect; 		external;
procedure SetMetaClipRectR; 		external;
function  LastMetaError; 		external;
procedure SelectGDriver; 		external;
function  GetBuffer; 			external;
procedure SetBuffer; 			external;
procedure FreeBuffer; 			external;
procedure ClearBuffer; 			external;
function  FullBuffer; 			external;
procedure SaveExt; 			external;
procedure DrawBuffer; 			external;
procedure InitMetaGr; 			external;
procedure DoneMetaGr; 			external;
procedure InternalInit; 	near; 	external;
procedure InitPattern; 		near; 	external;
procedure SetSF; 			external;
procedure WaitHRetrace; 		external;
procedure WaitDispEnable;		external;
procedure WaitDispDisable;		external;
function  DispState;                    external;
procedure WaitVRetrace; 		external;
procedure AssignVideoSeg; 		external;
procedure SetSingleMS;                  external;
procedure ClearSingleMS;                external;
procedure WaitHLine;                    external;
function  VRetrace;                     external;
function  MaxBufferSize;                external;

function MGVersion; Begin MGVersion:=$02000062; End;

function ChMetaParams;
Begin
  case Lo(Cmd) of
    gcpColor:
    begin
      ChMetaParams := SizeOf(Word);
      case Hi(Cmd) of
	Hi(gcpSetParams):
	  SetColor(Byte(Buf));
	Hi(gcpGetParams):
	  Word(Buf) := DColor16 div 256;
      end
    end;
    gcpLineStyle:
    begin
      ChMetaParams := 4;
      case Hi(Cmd) of
	Hi(gcpSetParams):
	  if (not LineLock) then Move(Buf, daLnStyle, 4);
	Hi(gcpGetParams):
	  Move(daLnStyle, Buf, 4);
      end
    end;
    gcpSolidThLn:
    begin
      ChMetaParams := 2;
      case Hi(Cmd) of
	Hi(gcpSetParams):
	  if (not LineLock) then SetLineStyle(0, 0, Word(Buf));
      end
    end;
  else ChMetaParams := 0;
  end
End;

procedure CallFreeMem(P: Pointer; Size: Word);
Begin
  FreeMem(P, Size);
End;

procedure SetWriteMode;
Begin
  WriteMode:=Mode;
  SelectGDriver(ColorMode, WriteMode);
End;

procedure SetColorMode;
Begin
  case Mode of
    cm16  : Begin
      ColorMode:=cm16;
      SelectGDriver(cm16, WriteMode);
    End;
    cm256 : Begin
      ColorMode:=cm256;
      SelectGDriver(cm256, NormalPut);
    End;
    cm0   : Begin
      ColorMode:=cm0;
      SelectGDriver(cm0, NormalPut);
    End;
  End;
End;

function NotifyMetaGraph(Notice: Word; Info: LongInt): LongInt; far;
Begin
  case Notice of
    gnpInitGraphics:
      begin
	AssignVideoSeg;
	Case GetMaxColor of
	  15 : SetColorMode(cm16);
	  255: SetColorMode(cm256);
	  ELSE SetColorMode(cm0);
	End;
      end;
    gnpCloseGraphics:
      SetColorMode(cm0);
  end;
  NotifyMetaGraph := DefaultNotify(Notice, Info, NotifyMetaGraph, NextNotify, 20);
End;

Procedure LockLine; Begin LineLock:=True; End;
Procedure UnLockLine; Begin LineLock:=false; End;

BEGIN
  InternalInit;
{$ifdef DPMI}
  PreparePatternTransfer;
{$endif}
  InitPattern;
  AssignVideoSeg;
  SetFillStyle(solidfill, white);
  SetLineStyle(solidLn, 0, NormWidth);
  MoveTo(0,0);
  New(MColors);
  New(MPalettes);
  GetPalettes(nil);
  GetRGBColors(nil,0,255);
  SelectGDriver(cm0, NormalPut);
  If qMetaExtSave > qExtSave then Begin
    qExtSave:= qMetaExtSave;
     ExtSave:= @SaveExt
  End;
  If qMetaLine > qLineProc then Begin
    qLineProc := qMetaLine;
     LineProc := Line
  End;
  If qChMetaParams > qChParamsProc then Begin
    qChParamsProc := qChMetaParams;
     ChParamsProc :=  ChMetaParams
  End;
  InstallNotifyProc(GrNotifyProc, NotifyMetaGraph);
  SetSF($10000);
  SetColor(15);
  SetMetaState(ms_Draw);
  UnLockLine;
END.