; MyMouse, Direct processing, Copr. 1993,94 Matthias Kppe

		INCLUDE	mymodef.asm

		PUBLIC	InitSerialPort, DoneSerialPort, \
			Handler, Handler386, HandleMicro, HandleSys

DATA		SEGMENT WORD PUBLIC

MouseData	DB	7 DUP (?)
MDP		DW	?
SavedBits	DB	?
SavedControl	DB	?
SavedBaudrate	DW	?

DATA		ENDS

CODE		SEGMENT BYTE PUBLIC

ReadData	PROC NEAR

		; In:	CX byte count
		; 	AH byte mask
		;	BL zero test mask
		;	BH nonzero test mask
		;
		; Out:	Zero if buffer full

		MOV	SI, MDP
		MOV	DX, MPort
		ADD	DX, 5
		IN	AL, DX
		AND	AL, 1			; statt TEST
		CMP	AL, 1
		JNZ	@@5
		SUB	DX, 5
		IN	AL, DX
		AND	AL, AH
		TEST	AL, BL			; Kennung fr erstes Byte
		JZ	@@4
		TEST	AL, BH
		JNZ	@@4
		XOR	SI, SI
@@4:    	MOV	BYTE PTR MouseData[SI], AL
		INC	SI
		AND	SI, 7
		MOV	MDP, SI
		CMP	SI, CX
@@5:		retn
ReadData        ENDP

UseData		PROC NEAR

		; In:   AL DeltaX (signed)
		;	CL DeltaY (signed)
		;	DL Buttons

		PUSH	MouseWhere.x
		PUSH	MouseWhere.y
		PUSH	DX
		MOV	DI, DoubleSpeedTreshold
		MOV	DX, DI
		NEG	DX
		CBW
		CMP	AX, DI
		JGE	@@1
		CMP	AX, DX
		JNL	@@2
@@1:		SAL	AX, 1
@@2:		ADD	MouseWhere.x, AX
		MOV	AL, CL
		CBW
		CMP	AX, DI
		JGE	@@3
		CMP	AX, DX
		JNL	@@4
@@3:		SAL	AX, 1
@@4:		ADD	MouseWhere.y, AX
		CALL	MakeMouseContained
		POP	BX
		MOV	CX, MouseWhere.x
		SHL	CX, 3
		MOV	DX, MouseWhere.y
		POP	MouseWhere.y
		POP	MouseWhere.x
		SHL	DX, 3
		MOV	AX, 1
		CMP	BL, LastButtons
		JZ	@@6
		MOV	AX, 0FFFFh
@@6:		CMP	InMouse, 0
		JNZ	@@5
		CALL	MouseInt
		JMP	UpdateMouse
@@5:    	JMP	StoreEvent
UseData		ENDP

HandleMicro	PROC NEAR
		MOV	CX, 3
		MOV	AH, 7Fh
		MOV	BX, 8040h
		CALL    ReadData
		JNZ	@@2

		MOV     DL, BYTE PTR MouseData
		MOV     BX, WORD PTR MouseData+1
		MOV     AL, DL
		AND     AL, 11B
		SHL     AL, 6
		OR      AL, BL			; DeltaX

		MOV     CL, DL
		AND     CL, 1100B
		SHL     CL, 4
		OR      CL, BH			; DeltaY

		AND	DL, 110000B
		SHR	DL, 5
		JNC	@@1
		OR	DL, 10B
@@1:		JMP	UseData
@@2:		retn
HandleMicro	ENDP

HandleSys	PROC NEAR
		MOV	CX, 3			; andere Bytes ignorieren
		MOV	AH, 0FFh
		MOV	BX, 4080h
		CALL	ReadData
		JNZ	@@1
		MOV	AL, BYTE PTR MouseData[1]
		MOV	CL, BYTE PTR MouseData[2]
		NEG	CL
		MOV	DH, BYTE PTR MouseData[0]
		NOT	DH
		MOV	DL, DH
		AND	DL, 3
		SHL	DL, 1
		TEST	DH, 4
		JE	@@2
		OR	DL, 1
@@2:		JMP	UseData
@@1:		retn
HandleSys	ENDP

InitSerialPort	PROC NEAR
		ARG	BitCode: BYTE, Base: WORD = ArgSize
		push	bp
		mov	bp, sp
		mov	MDP, 0			; reset data pointer
		MOV	DX, Base
		ADD	DX, 3
		IN	AL, DX			; Datenformatregister
		MOV	SavedBits, AL		;  Einstellungen speichern
		MOV	AL, BitCode
		OUT	DX, AL
		MOV	DX, Base
		IN	AX, DX                  ; Datenregister
		MOV	SavedBaudrate, AX	;  vorhandene Baudrate speichern
		MOV	AX, 0060h       	;  Baudratendivisor 0060h fr
		OUT	DX, AX			;  1200 Baud
		ADD	DX, 3
		IN	AL, DX			; Datenformatregister
		AND	AL, 01111111B		;  Bauddivisorwhlbit aus
		OUT	DX, AL			;  setzen
		MOV	DX, Base
		INC	DX			; Unterbrechungseinschaltregister
		MOV	AL, 1			;  wenn Daten bereit
		OUT	DX, AL			;  setzen
		ADD	DX, 3			; Serielles Steuerregister
		IN	AL, DX                  ;  lesen
		MOV	SavedControl, AL	;  speichern
		MOV	AL, 00001011B		;  Unterbrechungen ein, Sendeteil
		OUT	DX, AL			;  ein, Endgert betriebsbereit
		pop	bp
		retn	ArgSize
InitSerialPort	ENDP

DoneSerialPort	PROC NEAR
		ARG	Base: WORD = ArgSize
		push	bp
		mov	bp, sp
		MOV	DX, Base
		ADD	DX, 3			; Datenformatregister
		MOV	AL, SavedBits		;  gespeichertes Format
		OR	AL, 80H			;  Bauddivisorwhlbit ein
		OUT	DX, AL			;  setzen
		MOV	DX, Base		; Datenregister
		MOV	AX, SavedBaudrate	;  gespeicherter Divisor
		OUT	DX, AX			;  setzen
		ADD	DX, 3			; Datenformatregister
		IN	AL, DX                  ;  lesen
		AND	Al, 7Fh			;  Bauddivisorwhlbit aus
		OUT	DX, AL			;  setzen
		INC	DX			; Serielles Steuerregister
		MOV	AL, SavedControl	;  gespeichertes Steuerwort
		OUT	DX, AL			;  setzen
		pop	bp
		retn	ArgSize
DoneSerialPort	ENDP

Handler		PROC FAR
		pusha
		push	ds es
		mov	ax, SEG DATA
		MOV	DS, AX
		CALL	HandleProc
		PUSHF
		CALL	SavedIRQ
		pop	es ds
		popa
		iret
Handler		ENDP

	.386

Handler386	PROC FAR
		pushad
		push	ds es
		mov	ax, SEG DATA
		MOV	DS, AX
		CALL	HandleProc
		PUSHF
		CALL	SavedIRQ
		pop	es ds
		popad
		iret
Handler386	ENDP

CODE		ENDS

		END
