{
   $Id: filectrl.inc,v 1.1 1999/01/08 14:37:03 florian Exp $
   System independent low-level file interface for Win32

   Copyright (c) 1999 by Florian Klaempfl

   This library is free software; you can redistribute it and/or
   modify it under the terms of the GNU Library General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.


   This library is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   Library General Public License for more details.

   You should have received a copy of the GNU Library General Public
   License along with this library; if not, write to the Free
   Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

uses
  Windows;

function OpenFileStr(FName: PChar; Flags: Longint): TFileHandle;
Var
  regs : trealregs;
begin
  copytodos(FName^,256);
  if LFNSupport then
   regs.realeax:=$716c
  else
   regs.realeax:=$6c00;
  regs.realedx:=$1;
  regs.realds:=tb_segment;
  regs.realesi:=tb_offset;
  regs.realebx:=$2000;
  regs.realecx:=$20;
  realintr($21,regs);
  if (regs.realflags and carryflag) <> 0 then
   begin
     ErrorCode:=lo(regs.realeax);
     exit(0);
   end
  else
   OpenFileStr:=regs.realeax and $ffff;
end;


function CreateFileStr(FName: PChar): TFileHandle;
Var
  regs : trealregs;
begin
  copytodos(FName^,256);
  if LFNSupport then
   regs.realeax:=$716c
  else
   regs.realeax:=$6c00;
  regs.realedx:=$12;
  regs.realds:=tb_segment;
  regs.realesi:=tb_offset;
  regs.realebx:=$2001;
  regs.realecx:=$20;
  realintr($21,regs);
  if (regs.realflags and carryflag) <> 0 then
   begin
     ErrorCode:=lo(regs.realeax);
     exit(0);
   end
  else
   CreateFileStr:=regs.realeax and $ffff;
end;


procedure DeleteFileStr(FName: PChar);

begin
   ErrorCode:=0;
   if DeleteFile(FName)=0 then
     ErrorCode:=GetLastError;
end;


procedure CloseFile(Handle: TFileHandle);

begin
   ErrorCode:=0;
   if CloseHandle(Handle)=0 then
     ErrorCode:=GetLastError;
end;


function SeekFile(Handle: TFileHandle; Pos: TFileInt; SeekType: Word): TFileInt;

begin
   ErrorCode:=0;
   if SetFilePointer(Handle, Pos, nil, SeekType)=$ffffffff then
     ErrorCode:=GetLastError;
end;


function ReadFile(Handle: TFileHandle; var Buff; Count: CPUWord): CPUWord;
var
  Result : CPUWord;
begin
  ErrorCode:=0;
  if Windows.ReadFile(Handle, @Buff, Count, Result, nil)=0 then
    ErrorCode:=GetLastError;
  ReadFile:=result;
end;


function WriteFile(Handle: TFileHandle; var Buff; Count: CPUWord): CPUWord;
var
   Written : CPUWord;
begin
  ErrorCode:=0;
  if Windows.WriteFile(Handle, @Buff, Count, Size, nil)=0 then
    ErrorCode:=GetLastError;
  WriteFile:=Written;
end;


procedure FlushFile(Handle: TFileHandle);
begin
  ErrorCode:=0;
  if FlushFileBuffers(Handle)=0 then
    ErrorCode:=GetLastError;
end;


procedure TruncateFile(Handle: TFileHandle);
begin
  ErrorCode:=0;
  SeekFile(Handle, 0, skEnd);
  if not(SetEndOfFile(Handle)) then
    ErrorCode:=GetLastError;
end;


function EndOfFile(Handle: TFileHandle): Boolean;
begin
  ErrorCode:=0;
  EndOfFile := FilePos(Handle) >= FileSize(Handle);
end;


function FilePos(Handle: TFileHandle): TFileInt;
var
  l : TFileInt;
begin
  ErrorCode:=0;
  l:=SetFilePointer(Handle, 0, nil, FILE_CURRENT);
  if l=-1 then
    begin
       l:=0;
       ErrorCode:=GetLastError;
    end;
  FilePos:=l;
end;


function FileSize(Handle: TFileHandle): TFileInt;
var
  aktfilepos : TFileInt;
begin
  aktfilepos:=FilePos(Handle);
  FileSize:=SeekFile(Handle, 0, skEnd);
  SeekFile(Handle, aktfilepos, skBeg);
end;

{
  $Log: filectrl.inc,v $
  Revision 1.1  1999/01/08 14:37:03  florian
    + initial version, not working yet

}
