{*******************************************************}
{ Free Vision Runtime Library                           }
{ Memory Unit                                           }
{ Version: 0.1.0                                        }
{ Release Date: July 23, 1998                           }
{                                                       }
{ Portions Copyright (c) 1992 Borland International     }
{                                                       }
{*******************************************************}
{                                                       }
{ This unit is a port of Borland International's        }
{ App.pas unit.  It is for distribution with the        }
{ Free Pascal (FPK) Compiler as part of the 32-bit      }
{ Free Vision library.  The unit is still fully         }
{ functional under BP7 by using the tp compiler         }
{ directive when rebuilding the library.                }
{                                                       }
{*******************************************************}
unit Memory;

{$i platform.inc}

{$ifdef PPC_FPC}
  {$H-}
{$else}
  {$F+,O+,E+,N+}
{$endif}
{$X+,R-,I-,Q-,V-}
{$ifndef OS_LINUX}
  {$S-}
{$endif}


interface

const
  MaxHeapSize: longint = 655360 div 16;    { 640K }
  LowMemSize: longint = 4096 div 16;       {   4K }
  MaxBufMem: longint = 65536 div 16;       {  64K }

procedure InitMemory;
procedure DoneMemory;
procedure InitDosMem;
procedure DoneDosMem;
function LowMemory: Boolean;
function MemAlloc(Size: longint): Pointer;
function MemAllocSeg(Size: longint): Pointer;
procedure NewCache(var P: Pointer; Size: longint);
procedure DisposeCache(P: Pointer);
procedure NewBuffer(var P: Pointer; Size: longint);
procedure DisposeBuffer(P: Pointer);
function GetBufferSize(P: Pointer): longint;
function SetBufferSize(var P: Pointer; Size: longint): Boolean;


implementation

type
  PCache = ^TCache;
  TCache = record
    Next   : PCache;
    Size   : longint;
    Master : ^Pointer;
    Data   : record end;
  end;

  PBuffer = ^TBuffer;
  TBuffer = record
    Next   : PBuffer;
    Size   : longint;
    Master : ^Pointer;
    Data   : record end;
  end;

const
  CacheList  : PCache = nil;
  BufList    : PBuffer = nil;
  SafetyPool : Pointer = nil;
  SafetyPoolSize : longint = 0;
  DisablePool : Boolean = False;

function FreeCache: Boolean;
begin
  FreeCache := False;
  if assigned(CacheList) then
   begin
     DisposeCache(CacheList^.Next^.Master^);
     FreeCache := True;
   end;
end;


function FreeSafetyPool: Boolean;
begin
  FreeSafetyPool := False;
  if SafetyPool <> nil then
   begin
     FreeMem(SafetyPool, SafetyPoolSize);
     SafetyPool := nil;
     FreeSafetyPool := True;
   end;
end;


procedure InitMemory;
begin
  SafetyPoolSize := LowMemSize * 16;
  LowMemory;
end;


procedure DoneMemory;
begin
  while FreeCache do;
   FreeSafetyPool;
end;


procedure InitDosMem;
begin
end;


procedure DoneDosMem;
begin
end;


function LowMemory: Boolean;
begin
  LowMemory := False;
  if SafetyPool = nil then
  begin
    SafetyPool := MemAlloc(SafetyPoolSize);
    if SafetyPool = nil then
      LowMemory := True;
  end;
end;


function MemAlloc(Size: longint): Pointer;
var
  P: Pointer;
begin
  DisablePool := True;
  GetMem(P, Size);
  DisablePool := False;
  MemAlloc := P;
end;


function MemAllocSeg(Size: longint): Pointer;
begin
  MemAllocSeg:=MemAlloc(Size);
end;


procedure NewCache(var P: Pointer; Size: longint);
var
  Cache : PCache;
begin
  Inc(Size, SizeOf(TCache));
  GetMem(cache,Size);
  if Cache <> nil then
  begin
    Cache^.Next:=CacheList;
    CacheList:=Cache;
    Cache^.Master:=@P;
    Cache^.size:=Size;
    Inc(longint(Cache), SizeOf(TCache));
  end;
  P:=Cache;
end;


procedure DisposeCache(P: Pointer);
var
  Cache, C,Prev: PCache;
begin
  longint(Cache):= longint(P) - SizeOf(TCache);
  C:=CacheList;
  Prev:=nil;
  while assigned(C) and (C<>Cache) do
   begin
     Prev:=C;
     C := C^.Next;
   end;
  if assigned(C) then
  begin
     if assigned(Prev) then
      Prev^.Next:=Cache^.Next
     else
      CacheList:=Cache^.Next;
    Cache^.Master^ := nil;
    FreeMem(Cache,Cache^.Size);
  end;
end;


procedure NewBuffer(var P: Pointer; Size: longint);
var
  PBuf : PBuffer;
begin
  New(PBuf);
  GetMem(P,Size);
  PBuf^.Size:=Size;
  PBuf^.master:=P;
  PBuf^.Next:=BufList;
  BufList:=PBuf;
end;


procedure DisposeBuffer(P: Pointer);
var
  PBuf,Prev : PBuffer;
begin
  PBuf:=BufList;
  Prev:=nil;
  while assigned(Pbuf) and (PBuf^.master<>P) do
   begin
     Prev:=PBuf;
     PBuf:=PBuf^.next;
   end;
  if assigned(PBuf) then
   begin
     if assigned(Prev) then
      Prev^.Next:=PBuf^.next
     else
      BufList:=PBuf^.next;
     PBuf^.master:=nil;
     Freemem(P,PBuf^.Size);
     Dispose(PBuf);
   end;
end;


function GetBufferSize(P: Pointer): longint;
var
  PBuf : PBuffer;
begin
  PBuf:=BufList;
  while assigned(Pbuf) and (PBuf^.master<>P) do
    PBuf:=PBuf^.next;
  if assigned(PBuf) then
    GetBufferSize:=PBuf^.Size
  else
    GetBufferSize:=0;
end;


function SetBufferSize(var P: Pointer; Size: longint): Boolean;
var
  Pnew  : pointer;
  Osize : longint;
begin
  NewBuffer(PNew,Size);
  OSize:=GetBufferSize(P);
  if OSize>Size then
    move(P^,Pnew^,Size)
  else
    move(P^,Pnew^,OSize);
  DisposeBuffer(P);
  P:=PNew;
  SetBufferSize:=(PNew<>nil);
end;

end.
