unit MsgBox;

{ This is just a fake... It prevents the whole FV code from being compiled. }

interface

uses Objects;

const

{ Message box classes }

  mfWarning      = $0000;       { Display a Warning box }
  mfError        = $0001;       { Dispaly a Error box }
  mfInformation  = $0002;       { Display an Information Box }
  mfConfirmation = $0003;       { Display a Confirmation Box }

  mfInsertInApp  = $0080;       { Insert message box into application }
                                { instead of the Desktop }

{ Message box button flags }

  mfYesButton    = $0100;       { Put a Yes button into the dialog }
  mfNoButton     = $0200;       { Put a No button into the dialog }
  mfOKButton     = $0400;       { Put an OK button into the dialog }
  mfCancelButton = $0800;       { Put a Cancel button into the dialog }

  mfYesNoCancel  = mfYesButton + mfNoButton + mfCancelButton;
                                { Standard Yes, No, Cancel dialog }
  mfOKCancel     = mfOKButton + mfCancelButton;
                                { Standard OK, Cancel dialog }

type
  PStringRec = record
    { A PSTringRec is used to pass a string parameter to a MessageBox
      function. }
    AString : PString;
  end;

procedure InitMsgBox;
procedure DoneMsgBox;
  { Init initializes the message box display system's text strings.  Init is
    called by TApplication.Init after a successful call to Resource.Init or
    Resource.Load. }

function MessageBox(const Msg: String; Params: Pointer;
  AOptions: Word): Word;
{ MessageBox displays the given string in a standard sized      }
{ dialog box. Before the dialog is displayed the Msg and Params }
{ are passed to FormatStr.  The resulting string is displayed   }
{ as a TStaticText view in the dialog.                          }

function MessageBoxRect(var R: TRect; const Msg: String; Params: Pointer;
  AOptions: Word): Word;
{ MessageBoxRec allows the specification of a TRect for the     }
{ message box to occupy.                                        }

function InputBox(const Title, ALabel: String; var S: String;
  Limit: Byte): Word;
{ InputBox displays a simple dialog that allows the user to     }
{ type in a string.                                             }

function InputBoxRect(var Bounds: TRect; const Title, ALabel: String;
  var S: String;  Limit: Byte): Word;
{ InputBoxRect is like InputBox but allows the specification of }
{ a rectangle.                                                  }

implementation


function MessageBox(const Msg: String; Params: Pointer;
  AOptions: Word): Word;
begin
  MessageBox := 0;
end;

function MessageBoxRect(var R: TRect; const Msg: String; Params: Pointer;
  AOptions: Word): Word;
begin
  MessageBoxRect := 0;
end;

function InputBox(const Title, ALabel: String; var S: String;
  Limit: Byte): Word;
begin
  InputBox := 0;
end;

function InputBoxRect(var Bounds: TRect; const Title, ALabel: String;
  var S: String;  Limit: Byte): Word;
begin
  InputBoxRect := 0
end;

procedure InitMsgBox;
begin
end;

procedure DoneMsgBox;
begin
end;

end.
