
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{	Portions copyright (c) 1992 Borland Intl.       }
{       Copyright (c) 1994 Stefan Milius                }
{	Copyright (c) 1997,1999 Matthias Koeppe         }
{                                                       }
{*******************************************************}

{ $Id: gvtexts.pas 1.4 1999/02/13 15:27:02 mkoeppe Exp $ }

Unit GVTexts;

{$ifndef FPC}
{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-}
{$endif}

Interface

uses Objects;

const

{ language constants }

  lfEnglish = 0;
  lfGerman  = 1;

  Language: Byte = lfEnglish;

{ Get a language-dependent string
}
  function GetStr(Key: Word): String;
  function StrGet(Key: Word; Buffer: PChar; Size: Word): PChar;

{ Version 2.10-style functions
}
  procedure FreeTexts;
  procedure LoadTexts(GVLname: string);
  procedure StoreTexts(GVLname: string; List: PStrListMaker);
  procedure SetTextResource(AResource: PStream);

Implementation

{$ifdef Windows}
uses WinTypes, Strings, WinProcs, WinRes;
{$else}
uses Strings, WinRes;
{$endif}

const
{ Text stringlist
}
  Texts: PStringList = nil;

{ Using GVL files 
}

const
  GVL: PStream = nil;

procedure LoadTexts(GVLname: string);
begin
  FreeTexts;
  if GVLname <> ''
    then begin
      GVL := New(PBufStream, Init(GVLName, stOpenRead, 4096));
      if GVL^.Status = stOK
	then Texts := New(PStringList, Load(GVL^));
    end
end;

procedure StoreTexts(GVLname: string; List: PStrListMaker);
var
  GVL: PStream;
begin
  GVL := New(PBufStream, Init(GVLname, stCreate, 4096));
  List^.Store(GVL^);
  Dispose(GVL, Done)
end;

{ Using Windows resources 
}

{$ifdef Windows}
var
  TheInstance: THandle;

procedure SetTextResource(AResource: PStream);
begin
  TheInstance := 0;
  If (AResource <> nil) and (TypeOf(AResource^) = TypeOf(TResStream))
  then TheInstance := PResStream(AResource)^.Instance
end;
{$else}
const
  Resource: PStream = nil;
  Blocks: PStringBlock = nil;

procedure SetTextResource(AResource: PStream);
begin
  Resource := AResource;
end;
{$endif Windows}

{ GetStr 
}

function StrGet(Key: Word; Buffer: PChar; Size: Word): PChar;
var
  s: string;
begin
{$ifdef Windows}
  If Texts = nil
  then begin
    Buffer[0] := #0;
    WinProcs.LoadString(TheInstance, Key, Buffer, Size);
    If not AnsiCode then AnsiTo437(Buffer);
    StrGet := Buffer
  end
  else
{$endif Windows}
  begin
    s := GetStr(Key);
    if Length(s) >= Size
    then s[0] := Chr(Size - 1);
    StrPCopy(Buffer, s);
    StrGet := Buffer;
  end
end;

function GetStr(Key: Word): String;
var
{$ifdef Windows}
  Buf: PChar;
{$else !Windows}
  P: PString;
  B: PStringBlock;
  {$ifdef FPC}
  Buf: string;
  {$endif FPC}
{$endif !Windows}
Begin
  If Texts <> nil
  then begin
{$ifdef FPC}
    Buf := Texts^.Get(Key);
    if AnsiCode then AnsiFrom437Str(@Buf);
    GetStr := Buf
{$else}
    GetStr := Texts^.Get(Key);
    If AnsiCode
    then asm
	les	di, @Result
	push	es
	push	di
	call	AnsiFrom437Str
    end
{$endif}
  end else
  {$ifdef Windows}
  begin
    asm
       les      di, @Result
       inc      di
       mov      Buf.Word, di
       mov      Buf.2.Word, es
    end;
    Buf[0] := #0;
    WinProcs.LoadString(TheInstance, Key, Buf, 255);
    If not AnsiCode then AnsiTo437(Buf);
    (Buf-1)^ := Chr(StrLen(Buf));
  end
  {$else}
  if Resource <> nil
  then begin
    P := GetStringFromBlock(Blocks, Key);
    If P = nil
    then begin
      B := LoadStringBlock(Resource^, Key);
      If B = nil
      then B := NullStringBlock(Key);
      B^.sbNext := Blocks;
      Blocks := B;
      P := GetStringFromBlock(Blocks, Key)
    end;
    GetStr := P^
  end
  else
    GetStr := ''
  {$endif Windows}
End;

procedure FreeTexts;
{$ifndef Windows}
var
  N: PStringBlock;
{$endif Windows}
begin
  If Texts <> nil
  then begin
    Dispose(Texts, Done);
    Texts := nil
  end;
  If GVL <> nil
  then begin
    Dispose(GVL, Done);
    GVL := nil
  end;
  {$ifndef Windows}
  If Blocks <> nil
  then begin
    while Blocks <> nil do
    begin
      N := Blocks^.sbNext;
      FreeStringBlock(Blocks);
      Blocks := N
    end;
    Blocks := nil;
  end;
  Resource := nil
  {$endif Windows}
end;

{$ifdef Windows}
begin
  TheInstance := HInstance
{$endif Windows}
End.
