{
   *********************************************************************
   Version: 1998.06.09
   Copyright (C) 1997, 1998 Gertjan Schouten

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   *********************************************************************

   Modified by Matthias K"oppe <mkoeppe@cs.uni-magdeburg.de>:
   Added support for 1-bpp and 4-bpp bitmaps; fixed a bug with 8-bpp bitmaps.

}

unit bmp;

interface

uses objects, bitmaps;

type
   TBitMapFileHeader = record
      bfType:word;              // is always 19778 : 'BM'
      bfSize:longint;           // Filesize
      bfReserved:longint;
      bfOffset:longint;         // Offset of image data
   end ;

   TBitMapInfoHeader = record
      Size:longint;
      Width:longint;
      Height:longint;
      Planes:word;
      BitCount:word;
      Compression:longint;
      SizeImage:longint;
      XPelsPerMeter:Longint;
      YPelsPerMeter:Longint;
      ClrUsed:longint;
      ClrImportant:longint;
   end ;

   TBitmapIO_BMP = object(TBitmapIO)
   private
      BFH:TBitMapFileHeader;
      BFI:TBitMapInfoHeader;
      Palet:array[0..255] of longint;
   public
      constructor Create;
      function LoadHeader(stream:pstream):boolean; virtual;
      procedure LoadRLE8(stream:pstream);
      function LoadImage(stream:pstream):boolean; virtual;
      destructor Destroy; virtual;
   end ;

var
   BitmapIO_BMP: TBitmapIO_BMP;

implementation

const
   biRGB = 0;
   biRLE8 = 1;

constructor TBitmapIO_BMP.Create;
begin
inherited create;
FFileExt := '.BMP';
end ;

function TBitmapIO_BMP.LoadHeader(stream:pstream):boolean;
begin
result := false;
stream^.seek(0);
stream^.read(bfh,sizeof(TBitMapFileHeader));
stream^.read(bfi,sizeof(TBitMapInfoHeader));
if FBitmap^.getBytesPerPixel = 0 then begin
      case bfi.bitcount of
	      1, 4, 8: FBitmap^.setBytesPerPixel(1);
         else FBitmap^.setBytesPerPixel(4);
      end ;
   end ;
Fbitmap^.setWidth(bfi.Width);
Fbitmap^.setHeight(bfi.Height);
if (bfi.bitCount <= 8) then begin
   stream^.read(Palet, bfh.bfOffset - 54);
   Fbitmap^.setPalette(@Palet, 2 shl bfi.bitCount, ptBGR8, 4);
   end ;
result := true;
end ;

procedure TBitmapIO_BMP.LoadRLE8(Stream:pstream);
var i,x,y:integer;
    n:word;count:byte;
    buffer:array[0..255] of byte;
    done:boolean;
begin
y := bfi.Height - 1;
x := 0;
done := false;
while not done do begin
   stream^.read(n, 2);
   count := n shr 8;
   if n and 255 <> 0 then begin
      count := n and 255;
      Fillchar(Buffer, Count, n shr 8);
      fbitmap^.PutPixels(x, y, Count, @Buffer, 8);
      x := x + count;
      end
   else begin
         case count of
            0: begin
               y := y - 1;
               x := 0;
               end ;
            1: done := true;
            2: begin
               stream^.read(n, 2);
               inc(x, n and 255);
               dec(y, n shr 8);
               end ;
            else begin
               stream^.read(Buffer, (Count + 1) and $FFFE); { word align }
               fbitmap^.PutPixels(x, y, count, @Buffer, 8);
               x := x + count;
               count := 0;
               end ;
         end ;
      end ;
   end ;
end ;

function TBitmapIO_BMP.LoadImage(stream:pstream):boolean;
var
   y:integer;
   Buffer:pointer;
   BufSize:longint;
begin
BufSize := ((bfi.Width * bfi.BitCount div 8) + 3) and $FFFFFFFC;
Getmem(buffer, bufSize);
result := true;
if (bfi.bitcount = 24) then begin
   for y := bfi.Height-1 downto 0 do begin
      stream^.read(buffer^, bufSize);
      fbitmap^.PutPixels(0, y, bfi.Width, buffer, 24); // is now 24
      end ;
   end
else if (bfi.Bitcount = 8) and (bfi.Compression = biRGB) then begin
   for y := bfi.Height-1 downto 0 do begin
      stream^.read(buffer^, bufSize);
      fbitmap^.PutPixels(0, y, bfi.Width, buffer, 8); // This is ok now.
                                                      // Since PutPixels takes
     // the number of bits per
     // pixel instead of bytes.
      end ;
   end
else if (bfi.Bitcount = 8) and (bfi.Compression = biRLE8) then
   LoadRLE8(Stream)
// By Matthias K"oppe <mkoeppe@cs.uni-magdeburg.de>:
else if (bfi.Bitcount = 4) and (bfi.Compression = biRGB) then begin
   for y := bfi.Height-1 downto 0 do begin
      stream^.read(buffer^, bufSize);
      Fbitmap^.PutPixels(0, y, bfi.Width, buffer, 4); // is now 4
   end ;
end
// By Matthias K"oppe <mkoeppe@cs.uni-magdeburg.de>:
else if (bfi.Bitcount = 1) then begin
   for y := bfi.Height-1 downto 0 do begin
      stream^.read(buffer^, bufSize);
      Fbitmap^.PutPixels(0, y, bfi.Width, buffer, 1); // is now 1
   end ;
end
else result := false;
Freemem(buffer, bufSize);
end ;

destructor TBitmapIO_BMP.Destroy;
begin
end ;

procedure DebugInfo;
begin
// writeln('Used colors: ',bfi.ClrUsed);
// writeln('Imp colors: ',bfi.ClrImportant);
end ;

begin
BitmapIO_BMP.Create;
end .
