
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Stefan Milius                }
{                                                       }
{*******************************************************}

{ $Id: exam0005.pas 1.3 1999/02/11 16:58:18 mkoeppe Exp $ }

(* To run this program you'll have to build exam.gvl by:

   GVLC exam.gvl english.gvs exam.gvs

   Hint: If you want another than the English language just translate all
   the texts in the GVS files into this language and then rebuild exam.gvl!
   (Germans only have to translate exam.gvs)


This application shows the usage of a bitmap desktop.

*)

Uses Dos, Misc, Objects, Drivers, KeyNames, GVViews, GVBitmap, GVMenus, GVApp, GVStdDlg, GVTexts;

const
  cmOpen = 100;

type

  TDemoApp = object(TApplication)
               procedure HandleEvent(var Event: TEvent); virtual;
               procedure InitDesktop; virtual;
               procedure InitStatusLine; virtual;
               function LanguageResource: String; virtual;
             end;

(******************************** TDemoApp object ***************************)

procedure TDemoApp.HandleEvent(var Event: TEvent);

  procedure LoadDesktop;
  var D: PFileDialog;
      BackBitmap: PathStr;
  Begin
    BackBitmap := '*.bmp';
    D := New(PFileDialog, Init(BackBitmap, GetStr(704), GetStr(702),
      fdOpenButton, 42));
    If ExecuteDialog(D, @BackBitmap) <> cmCancel then
      PNewDesktop(Desktop)^.NewBitmap(BackBitmap);
  End;

Begin
  inherited HandleEvent(Event);
  If (Event.What = evCommand) and (Event.Command = cmOpen) then
    LoadDesktop;
End;

procedure TDemoApp.InitDesktop;
var R: TRect;
Begin
  Main^.GetExtent(R);
  R.Grow(0, -21);
  Desktop := New(PNewDesktop, Init(R, {GetWinDir + 'BLAETTER.BMP'} 'nilhorn.bmp'));
End;

procedure TDemoApp.InitStatusLine;
var R: TRect;
Begin
  Main^.GetExtent(R);
  R.A.Y := R.B.Y - 21;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, $FFFF,
      NewStatusKeyKN(GetStr(600), kbAltX, cmQuit,
      NewStatusKeyKN(GetStr(612), kbF3, cmOpen, nil)), nil)));
End;

function TDemoApp.LanguageResource: String;
Begin
  LanguageResource := 'exam.gvl';
End;

var App: TDemoApp;

Begin
  App.Init;
  App.Run;
  App.Done;
End.
