
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Stefan Milius                }
{                                                       }
{*******************************************************}

(* To run this program you'll have to build exam.gvl by:

   GVLC exam.gvl english.gvs exam.gvs

   Hint: If you want another than the English language just translate all
   the texts in the GVS files into this language and then rebuild exam.gvl!
   (Germans only have to translate exam.gvs)


This application shows:

   - usage of filer objects
   - usage of TLevel objects

Note that we need different graphics units for Windows.
*)

Uses
  {$ifdef Windows} WinGr,
  {$else} {$ifdef FPK} Bgi, {$else} MetaGr, MyFonts, {$endif}
  {$endif}
  Dos, Objects, Drivers, ExtGraph, KeyNames, GVViews,
  GVMenus, GVApp, GVTexts, GVEyes, GVFiler, GVClock, GVWinDlg;

const

{ Commands }

  cmNew = 100;

type

{ TInterior object }

  PInterior = ^TInterior;
  TInterior = object(TGView)
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
  end;

{ TDemoApp object }

  TDemoApp = object(TApplication)
               procedure HandleEvent(var Event: TEvent); virtual;
               procedure InitStatusLine; virtual;
               function LanguageResource: String; virtual;
             end;

(***************************** TInterior object *****************************)

constructor TInterior.Init(var Bounds: TRect);
begin
  TGView.Init(Bounds);
  GrowMode := gfGrowHiX + gfGrowHiY;
end;

procedure TInterior.Draw;
const
  Greeting: string = 'Hello, World!';
begin
  SetFillStyle (SolidFill, GetColor(21));
  Bar (0,0, Size.X-1, Size.Y-1);
  SetTextParams(ftSansSerif, 0, GetColor(19), false);
  SetTextJustify(LeftText, TopText);
  OutTextXY(20, 35, Greeting);
end;

(******************************** TDemoApp object ***************************)

procedure TDemoApp.HandleEvent(var Event: TEvent);

  procedure ShowFiler;
  var
    W: PWindow;
    R, Client, Sheet: TRect;
  begin
    R.Assign(0, 0, 300, 300);
    R.Move(Random(340), Random(140));
    W := New(PWindow, Init(R, GetStr(734), wnNoNumber));
    with W^ do
    begin
      Palette := wpGrayWindow;
      GetClientRect(Client);
      R.Assign(Client.A.X, Client.A.Y, Client.B.X, Client.A.Y + 20);
      with PFilerBar(Insert(New(PFilerBar, Init(R, fbProportionalWidth))))^ do
      begin
	Sheet.Assign(Client.A.X, Client.A.Y + 20, Client.B.X, Client.B.Y);
	with InsertSheet(New(PFilerSheet, Init(Sheet, GetStr(735))))^ do
	begin
	  R.Assign(10, 10, Size.X - 10, Size.Y - 10);
	  Insert(New(PEyes, Init(R)))
	end;
	with InsertSheet(New(PFilerSheet, Init(Sheet, GetStr(736))))^ do
	begin
          R.Assign(9, 9, Size.X - 9, Size.Y - 9);
	  PGView(Insert(New(PLevel, Init(R, -1))))^.GrowMode := gfGrowHiX + gfGrowHiY;
	  R.Assign(10, 10, Size.X - 10, Size.Y - 10);
	  Insert(New(PClock, Init(R)))
	end;
	with InsertSheet(New(PFilerSheet, Init(Sheet, GetStr(737))))^ do
	begin
          R.Assign(9, 9, Size.X - 9, Size.Y - 9);
	  PGView(Insert(New(PLevel, Init(R, 1))))^.GrowMode := gfGrowHiX + gfGrowHiY;
          R.Assign(10, 10, Size.X - 10, Size.Y - 10);
          Insert(New(PInterior, Init(R)));
	end;
      end
    end;
    InsertWindow(W)
  end;

Begin
  inherited HandleEvent(Event);
  If Event.What = evCommand then
    Case Event.Command Of
      cmNew: ShowFiler;
    End
End;

procedure TDemoApp.InitStatusLine;
var R: TRect;
Begin
  Main^.GetExtent(R);
  R.A.Y := R.B.Y - 21;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, 0,
      NewStatusKeyKN(GetStr(600), kbAltX, cmQuit,
      NewStatusKeyKN(GetStr(613), kbF3, cmNew,
      NewStatusKey('', kbAltF3, cmClose,
      NewStatusKey('', kbCtrlF5, cmResize,
      NewStatusKey('', kbF5, cmZoom, nil))))),
    StdDraggingStatusDef(
    nil))));
End;

function TDemoApp.LanguageResource: String;
Begin
  LanguageResource := 'exam.gvl';
End;

var App: TDemoApp;

Begin
  Language := lfEnglish;
  App.Init;
  App.Run;
  App.Done;
End.
