
{*******************************************************}
{                                                       }
{       Graphics Vision Demo program                    }
{                                                       }
{       Copyright (c) 1996 Stefan Milius                }
{                                                       }
{*******************************************************}

{ $Id: gvdemo.pas 1.6 1999/02/13 21:12:51 mkoeppe Exp $ }

program GvDemo;

{$ifdef Windows}
{$M 16384, 8192}
{$endif Windows}

Uses
{$ifdef FPK}
  Bgi, Drivers, Memory, GvFPK, 
{$else}
{$ifdef Windows}
  WinTypes, WinProcs, WinDos, WinGr, OMemory, Drivers, Bitmap, VgaMem, 
{$else !Windows}
  GvOvr, CRT, Memory, Drivers, GvDriver, Gr, MetaGr, MyFonts, MyMouse,
  Vesa, Bitmap, VgaMem, 
{$endif Windows}
{$endif}
  Dos, Objects, Views, HistList, Misc, ExtGraph, KeyNames, WinRes, Validate,
  GVViews, GVMenus, GvBWCC, GVWinDlg, GVTexts, GVApp, GVStdDlg, GVWList,
  GVBitmap, GVMsgBox, GVGadget, GVClock, GVEyes, GVFonts, GVFiler, GVColor,
  GVHelp, GVTable, GVCombo, GVValid, GVVirt, GVHint, GVWinNum, GVDialog, GvLight;

{$ifdef MSDOS}
{ This demo contains a lot of Schnickschnack, so it's better to run
  it in overlay mode for more memory, if compiled for real-mode target.
  Note that all of the graphic-system units must be static.
}

{$O App}	{$O Validate} 	{$O HistList} 	{$O Views}
{$O MsgBox} 	{$O Menus} 	{$O Dialogs}	{$O GvApp}
{-O GvViews}	{$O GvDialog}	{$O GvMenus}	{$O GvBWCC}
{$O GvWinDlg}	{$O GvTexts}	{$O GvStdDlg}	{$O GvWList}
{$O GvBitmap}	{$O GvMsgBox}	{$O GvGadget}	{$O GvClock}
{$O GvEyes}	{$O GvFonts}	{$O GvFiler}	{$O GvColor}
{$O GvHelp}	{$O KeyNames}	{$O GvTable}	{$O GvCombo}
{$O GvValid}	{$O GvVirt}	{$O GvHint}	{$O GvWinNum}
{$O GvLight}
{$endif MSDOS}

{$I DEMOCOM.INC}

var
  Res, Help: PStream;
  BackBitmap: PathStr;
  IsVirtual: Boolean;
  VirtualFactor: TPoint;
const
  HintDelay: Word = 10;

type

{ TTextInterior object }

  PTextInterior = ^TTextInterior;
  TTextInterior = object (TScroller)
    Strings: TStringCollection;
    constructor Init(var Bounds: TRect; AHScrollBar,
	AVScrollBar: PScrollBar; FileName: PathStr);
    destructor Done; virtual;
    procedure Draw; virtual;
    procedure ReadFile(FileName: PathStr); virtual;
  end;

{ TTextWindow object }

  PTextWindow = ^TTextWindow;
  TTextWindow = object (TWindow)
    constructor Init (var Bounds: TRect; WinTitle: String;
      ANumber: Integer);
  end;

{ TBitmapWindow object }

  PBitmapWindow = ^TBitmapWindow;
  TBitmapWindow = object(TWindow)
    constructor Init(Bounds: TRect; WinTitle: String;
      WindowNo: Word);
  end;

{ TMorphWindow object }

  PMorphWindow = ^TMorphWindow;
  TMorphWindow = object(TWindow)
    constructor Init(var Bounds: TRect);
    procedure ChangeBounds(var R: TRect); virtual;
    procedure Locate(var R: TRect); virtual;
    procedure HandleEvent(var Event: TEvent); virtual;
    procedure Zoom; virtual;
  end;

{ TGhost object }

  PGhost = ^TGhost;
  TGhost = object(TIconLabel)
             Direction: TPoint;
             constructor Init(var Bounds: TRect);
             procedure HandleEvent(var Event: TEvent); virtual;
	     procedure Draw; virtual;
           end;

{ TMystify data structures }

  PVertex = ^TVertex;
  TVertex = record
              P, Vec: TPoint;
            end;

  PPoly = ^TPoly;
  TPoly = Array [0..0] Of TVertex;

  PMyst = ^TMyst;
  TMyst = Array [0..0] Of PPoly;

  PColors = ^TColors;
  TColors = Array [0..0] Of Byte;

{ TMystify object }

  PMystify = ^TMystify;
  TMystify = object(TGView)
               Count, Vertex, Lines: Integer;
               constructor Init(var Bounds: TRect; ACount, AVertex,
                 ALines: Integer);
               destructor Done; virtual;
               procedure ChangeBounds(var Bounds: TRect); virtual;
               procedure Draw; virtual;
               procedure HandleEvent(var Event: TEvent); virtual;
               procedure SetParams(ACount, AVertex, ALines: Integer);
             private
               Myst: PMyst;
               Colors: PColors;
               procedure DrawPoly(Poly: PPoly; Color: Byte);
               procedure UpDate;
             end;

{ TNastyButton object  }

  PNastyButton = ^TNastyButton;
  TNastyButton = object(TButton)
                   procedure ChangeBounds(var Bounds: TRect); virtual;
                   procedure HandleEvent(var Event: TEvent); virtual;
                 end;

{ TGNastyButton object  }

  PGNastyButton = ^TGNastyButton;
  TGNastyButton = object(TImageButton)
                   procedure ChangeBounds(var Bounds: TRect); virtual;
                   procedure HandleEvent(var Event: TEvent); virtual;
                 end;

{ TMyListBox object }

  PMyListBox = ^TMyListBox;
  TMyListBox = object(TListBox)
                 destructor Done; virtual;
               end;

{ TGListBox object }

  PGListBox = ^TGListBox;
  TGListBox = object(TListBox)
                Nilhorn, Ghost: Pointer;
                Font: PFont;
                constructor Init(var Bounds: TRect; AScrollBar: PScrollBar);
                destructor Done; virtual;
                procedure DrawItemText(Item: Integer; R: TRect); virtual;
                procedure GetItemRect(Item: Integer; var R: TRect); virtual;
              end;

{ TMyDesktop object }

  PMyDesktop = ^TMyDesktop;
  TMyDesktop = object(TVirtualDesktop)
                 ImageWindow: PDesktopImageWindow;
                 constructor Init(var Bounds: TRect; Bitmap: string;
                   FactorX, FactorY: Integer);
                 procedure HandleEvent(var Event: TEvent); virtual;
               end;

{ TDemoApp object }

  TDemoApp = object(TApplication)
               constructor Init;
               destructor Done; virtual;
               procedure GetEvent(var Event: TEvent); virtual;
               procedure HandleEvent(var Event: TEvent); virtual;
               procedure Idle; virtual;
               procedure InitDesktop; virtual;
               procedure InitMenuBar; virtual;
               procedure InitStatusLine; virtual;
               function LanguageResource: String; virtual;
               procedure Timer(var Event: TEvent); virtual;
               procedure WriteShellMsg; virtual;
             private
               Heap: PHeapView;
               Clock: PClockView;
               LastEvent: LongInt;
             end;

{ TMyStatusLine object }

  PMyStatusLine = ^TMyStatusLine;
  TMyStatusLine = object(THintStatusLine)
                    function Hint(AHelpCtx: Word): String; virtual;
                  end;

{$ifndef FPK}
function Min (x, y: Integer): Integer; Assembler;
Asm
	MOV	AX, X
        CMP	AX, Y
        JLE	@@1
        MOV	AX, Y
@@1:
End;

function Max (x, y: Integer): Integer; Assembler;
Asm
	MOV	AX, X
        CMP 	AX, Y
        JGE	@@1
	MOV	AX, Y
@@1:
End; 
{$endif FPK}

function NewLine(ANext: PMenuItem): PMenuItem;
var Item: PMenuItem;
Begin
  Item := GVMenus.NewLine(ANext);
  Item^.HelpCtx := hcMenuLine;
  NewLine := Item;
End;

(*************************** TTextInterior object ***************************)

constructor TTextInterior.Init(var Bounds: TRect; AHScrollBar,
	AVScrollBar: PScrollBar; FileName: PathStr);
Begin
  TScroller.Init (Bounds, AHScrollBar, AVScrollBar);
  GrowMode:=gfGrowHiX + gfGrowHiY;
  ReadFile (FileName);
End;

destructor TTextInterior.Done;
Begin
  Strings.Done;
  TGView.Done;
End;

procedure TTextInterior.Draw;
var
  I, j: Integer;
  S, Ins: String;
Begin
  { Background  }
  SetFillStyle(SolidFill, GetColor(3));   { scroller normal background }
  Bar(0, 0, Size.X-1, Size.Y-1);
  { Text  }
  SetTextParams(ftMonoSpace, 0, GetColor(1), false);  { scroller normal text }
  SetTextJustify(LeftText, CenterText);
  Ins := '        ';
  For I := Delta.Y to Delta.Y + Size.Y div TextSize.Y do
    If I < Strings.Count
    then Begin
      S := PString(Strings.At(I))^;
      { Tab conversion
      }
      j := 1;
      while j <= Length(S) do
	if S[j] = #9
	then begin
	  Ins[0] := Chr(7 - (j - 1) mod 8);
	  Insert(Ins, S, j + 1);
	  S[j] := ' ';
	  Inc(j, Length(Ins) + 1)
	end
	else Inc(j);
      { Output the text line
      }
      OutTextXY(- Delta.X * TextSize.X,
	(I - Delta.Y) * TextSize.Y + TextSize.Y div 2, S)
    End;
End;

procedure TTextInterior.ReadFile(FileName: PathStr);
var F: Text;
    S: String;
Begin
  Strings.Init (30,10);
  Strings.Duplicates:=true;
  Assign (F, FileName);
  {$I-}
  Reset (F);
  While not EOF (F) and (IOResult = 0) and not LowMemory do
  Begin
    ReadLn (F, S);
    If S='' then S:=' ';
    Strings.AtInsert (Strings.Count, NewStr (S));
  End;
  Close (F);
  {$I+}
  SetLimit (100, Strings.Count);
End;

{*************************** TTextWindow object ****************************}

constructor TTextWindow.Init(var Bounds: TRect; WinTitle: String;
      ANumber: Integer);
var R: TRect;
Begin
  TWindow.Init (Bounds, WinTitle, ANumber);
  Flags := Flags and not wfBackground;
  GetClientRect (R);
  Dec (R.B.X, 17); Dec (R.B.Y, 17);
  Insert (New (PTextInterior, Init (R,
    StandardScrollBar (sbHorizontal+sbHandleKeyboard),
    StandardScrollBar (sbVertical+sbHandleKeyboard),
    WinTitle)));
End;

(**************************** TBitmapWindow object **************************)

constructor TBitmapWindow.Init(Bounds: TRect; WinTitle: String;
  WindowNo: Word);
var
  HScrollBar, VScrollBar: PScrollBar;
  Interior: PGView;
begin
  TWindow.Init(Bounds, WinTitle, WindowNo);
  Flags := Flags and not wfBackground;

  VScrollBar := StandardScrollBar(sbVertical + sbHandleKeyboard);
  HScrollBar := StandardScrollBar(sbHorizontal + sbHandleKeyboard);

  GetClientRect(Bounds);
  Dec(Bounds.B.X, 17); Dec(Bounds.B.Y, 17);

  Interior := New(PBmpScroller, Init(Bounds, HScrollBar, VScrollBar, WinTitle));
  Insert(Interior);
end;

(***************************** TMorphWindow object **************************)

constructor TMorphWindow.Init(var Bounds: TRect);
var
  R: TRect;
  BmpView: PGView;
  IL: PInputLine;
  sb: PScrollBar;
  cl: PCluster;
  w: Word;
  s: string;
  left: Integer;
begin
  MessageBox(GetStr(759), nil, mfOKButton + mfWarning);

  R.Assign(0, 0, 0, 0);
  BmpView := New(PBmpView, InitByImages(R, LoadBitmapImg(Res^, 'TVMorph'), bmfAdjustSize));
  BmpView^.GetExtent(R);
  R.Move(Bounds.A.x, Bounds.A.y);
  If R.Empty
  then begin
    left := 100;
    MessageBox(GetStr(760), nil, mfOKButton + mfError);
    R.B.y := Bounds.B.y;
  end
  else
    left := BmpView^.Size.x;
  R.B.x := Bounds.B.x;
  TWindow.Init(R, 'Window Window', 0);

  HelpCtx := hcMorphWindow;
  Palette := wpGrayWindow;

  sb := StandardScrollBar(sbHorizontal);
  with sb^ do
  begin
    GetBounds(R);
    Dec(R.B.x, 2);
    Dec(R.A.y, 2); Dec(R.B.y);
    ChangeBounds(R);
    SetState(sfDisabled, true);
  end;
  sb := StandardScrollBar(sbVertical);
  with sb^ do
  begin
    GetBounds(R);
    Dec(R.B.y, 2);
    Dec(R.A.x, 2); Dec(R.B.x);
    ChangeBounds(R);
    SetParams(20, 0, 100, 10, 1);
  end;

  R.Assign(left - 1, 66, 355, 89);
  IL := New(PInputLine, Init(R, 80));
  s := GetStr(761); IL^.SetData(s);
  Insert(IL);

  R.Assign(355, 66, 372, 89);
  Insert(New(PHistory, Init(R, IL, 77)));
  s := GetStr(762); HistoryAdd(77, s);
  s := GetStr(763); HistoryAdd(77, s);
  s := GetStr(764); HistoryAdd(77, s);

  R.Assign(left + 10, 110, Size.x - 30, 180);
  cl := New(PCheckBoxes, Init(R,
    NewSItem(GetStr(765),
    NewSItem(GetStr(766),
    NewSItem(GetStr(767),
    NewSItem(GetStr(768),
    nil))))));
  w := 15; cl^.SetData(w);
  Insert(cl);

  Insert(BmpView);

  R.Assign(left + 20, 198, left + 131, 221);
  PGView(Insert(New(PButton, Init(R, GetStr(769), cmClose, bfDefault))))^.
    HelpCtx := hcMorphButton;

  SelectNext(false)
end;

procedure TMorphWindow.Zoom;
begin
  MessageBoxTitle(GetStr(770), GetStr(771), nil, mfError + mfCancelButton)
end;

procedure TMorphWindow.ChangeBounds(var R: TRect);
Begin
  R.B.X := R.A.X + Size.X;
  R.B.Y := R.A.Y + Size.Y;
  inherited ChangeBounds(R)
End;

procedure TMorphWindow.Locate(var R: TRect);
var
  NewSize: TPoint;
begin
  if GetState(sfDragging) then
    TWindow.Locate(R)
  else begin
    NewSize.x := R.B.x - R.A.x;
    NewSize.y := R.B.y - R.A.y;
    SetCurrentCursor(mcNoCursor);
    if (NewSize.X <> Size.X) or (NewSize.Y <> Size.Y)
      then MessageBoxTitle(GetStr(770), GetStr(772), nil,
			   mfError + mfCancelButton)
    else begin
    TWindow.Locate(R);
      MessageBoxTitle(GetStr(773), GetStr(774),
		      nil, mfInformation + mfOKButton)
    end
  end
end;

procedure TMorphWindow.HandleEvent(var Event: TEvent);
var
  R: TRect;
begin
  TWindow.HandleEvent(Event);
  If Event.What = evCommand then
    case Event.Command of
      cmClose: Close;
    end
  else
  if (Event.What = evBroadcast) and (Event.Command = cmScrollbarChanged)
  then Begin
    MessageBoxTitle('Hey', GetStr(775), nil, mfInformation + mfOKButton);
    Event.What := evMouseUp;
    PutEvent(Event);
    ClearEvent(Event)
  End
  Else
  if not GetState(sfDragging) then
  if Event.What = evTimer
  then begin
    if Random(800) = 0
    then begin
      if MessageBoxTitle(GetStr(776), GetStr(777),
	nil, mfConfirmation + mfYesButton + mfNoButton) = cmYes
      then begin
	GOwner^.GetExtent(R);
	MoveTo(Random(R.B.x - Size.x), Random(R.B.y - Size.y))
      end
    end;
  end
  else If (Event.What = evPositionalCtx) and MouseInView(Event.Where) then Begin
    Event.What := evNothing;
    Event.InfoLong := HelpCtx;
  End;
end;

(******************************* TGhost object ******************************)

constructor TGhost.Init(var Bounds: TRect);
var
  Img: Pointer;
Begin
  { Load the bitmap from the resource.
  }
  Img := LoadBitmapImg(Res^, 'ghost');
{$ifdef FPK} { no MaskedImage yet available }
  inherited InitByImages(Bounds, Img, nil,  nil);
{$else}
  { Set the exact color that marks the transparent regions
    (for use in MaskedImage).
  }
  SetExactBkColor(128, 0, 128);
  inherited InitByImages(Bounds, Img, MaskedImage(Img),  nil);
{$endif}
  SetState(sfTransparent, true);
  EventMask := evTimer + evMouse + evBroadcast;
  With Direction do Begin
    X := Random(21) - 10;
    Y := Random(21) - 10;
  End;
End;

procedure TGhost.HandleEvent(var Event: TEvent);
const
  Naughtiness = 80;
  epsilon = 20;
  Success = 2;
var N, S: TPoint;
    P: PGView;
    R: TRect;

	function NearGhost(View: PGView): Boolean; {$ifndef FPK}far;{$endif}
	begin
	  NearGhost :=
	    (TypeOf(View^) = TypeOf(TGhost)) and
	    (View <> @Self) and
	    (abs(View^.Origin.X - Origin.X) +
	     abs(View^.Origin.Y - Origin.Y) < epsilon)
	end;

Begin
  If Event.What = evMouseDown then Begin
    ClearEvent(Event);
    Free;
    Exit
  End;
  inherited HandleEvent(Event);
  If GetShiftState and 1 <> 0 then Exit;
  If (Event.What = evTimer) or
     (Event.What = evBroadcast) and (Event.Command = cmIdle) {and (Event.InfoWord mod 3 = 0)} then Begin
    { naughty extensions }
    If Random(100) < Naughtiness
    then begin
      P := GOwner^.FirstThat(@NearGhost);
      If P <> nil
      then begin
        Direction := PGhost(P)^.Direction;
        If Random(100) < Success
        then begin
          GetBounds(R);
          P := New(PGhost, Init(R));
          with PGhost(P)^.Direction do
          begin
            X := epsilon;
            Y := epsilon
          end;
          GOwner^.Insert(P);
          with Direction do
          begin
            X := -epsilon;
            Y := -epsilon
          end
        end
      end;
    end;
    { }
    S := GOwner^.Size;
    N.X := Min(S.X - Size.X, Max(0, Origin.X + Direction.X));
    N.Y := Min(S.Y - Size.Y, Max(0, Origin.Y + Direction.Y));
    If (N.X = 0) or (N.X = S.X - Size.X) then
      Direction.X := -Direction.X;
    If (N.Y = 0) or (N.Y = S.Y - Size.Y) then
      Direction.Y := -Direction.Y;
    If Random(50) = 0 then With Direction do Begin
      X := Random(21) - 10;
      Y := Random(21) - 10;
    End;
    MoveTo(N.X, N.Y);
  End;
End;

procedure TGhost.Draw;
begin
  if (XorMask = nil) and (AndMask = nil) then begin
    { If no real ghost there, draw some ghost surrogate }
    SetColor(Red);
    SetFillStyle(SolidFill, Red);
    FillCircle(Size.x div 2, Size.y div 2, Size.x div 2)
  end
  else inherited Draw
end;

{************************** TTextInterior object ***************************}

constructor TMystify.Init(var Bounds: TRect; ACount, AVertex, ALines: Integer);
Begin
  inherited Init(Bounds);
  EventMask := evTimer + evMouse + evKeyBoard;
  Options := (Options or ofPostProcess) {$ifndef FPK} and not ofBuffer{$endif};
  GrowMode := gfGrowHiX + gfGrowHiY;
  SetParams(ACount, AVertex, ALines);
End;

destructor TMystify.Done;
Begin
  SetParams(0, 0, 0);
  inherited Done;
End;

procedure TMystify.ChangeBounds(var Bounds: TRect);
Begin
  With Bounds do
    If (B.X-A.X <> Size.X) or (B.Y-A.Y <> Size.Y) then Begin
      inherited ChangeBounds(Bounds);
      SetParams(Count, Vertex, Lines);
    End
    Else inherited ChangeBounds(Bounds);
End;

procedure TMystify.Draw;
var I: Integer;
Begin
  SetFillStyle(SolidFill, Black);
  Bar(0, 0, Size.X - 1, Size.Y - 1);
  For I := 0 to Count * Lines - 1 do DrawPoly(Myst^[I],
    Colors^[I div Lines]);
End;

procedure TMystify.DrawPoly(Poly: PPoly; Color: Byte);
var I: Byte;
Begin
  SetViewPort;
  SetColor(Color);
  For I := 1 to Vertex - 1 do begin
    Line(Poly^[I-1].P.X, Poly^[I-1].P.Y,
      Poly^[I].P.X, Poly^[I].P.Y);
  end;
  Line(Poly^[Vertex-1].P.X, Poly^[Vertex-1].P.Y,
    Poly^[0].P.X, Poly^[0].P.Y);
  RestoreViewPort;
End;

procedure TMystify.HandleEvent(var Event: TEvent);
type Poly     = 1..10;
     Vertices = 3..12;
     Line     = 1..10;
var D: PDialog;
    Control: PGView;
    R: TRect;
    Data: Array [0..2] Of Integer;
Begin
  inherited HandleEvent(Event);
  If (Event.What = evTimer) and (State and sfDragging = 0) then
    If Random(50) <> 0 then UpDate;  { damit andere auch noch drankommen }
  If ((Event.What = evMouseDown) and MouseInView(Event.Where) and
     (Event.Buttons = mbRightButton)) or
     ((Event.What = evKeyBoard) and (Event.KeyCode = kbAltF10)) then Begin
    ClearEvent(Event);
    { Nutzerdialog erzeugen .... }
    R.Assign(0, 0, 270, 200);
    D := New(PDialog, Init(R, GetStr(735)));
    With D^ do Begin
      Options := Options or ofCentered;
      SetTextParams(ftSansSerif, 0, 0, true);

      { erste Eingabezeile }
      R.Assign(87, 53, 100, 73);
      Control := Insert(New(PArrowfield, Init(R)));

      R.Assign(25,53,88,73);
      Control := Insert(New(PNumInput, Init(R, Low(Poly), High(Poly),
        PArrowField(Control))));

      R.Assign (25,30,35+TextWidth (GetStr(736)),50);
      Insert(New (PLabel, Init (R, GetStr(736), Control)));

      { zweite Eingabezeile }
      R.Assign(87, 108, 100, 128);
      Control := Insert(New(PArrowField, Init(R)));

      R.Assign(25,108,88,128);
      Control := Insert(New(PNumInput, Init(R, Low(Vertices), High(Vertices),
        PArrowField(Control))));

      R.Assign (25,85,35 + TextWidth(GetStr(737)),105);
      Insert(New (PLabel, Init (R, GetStr(737), Control)));

      { dritte Eingabezeile }
      R.Assign(87, 163, 100, 183);
      Control := Insert(New(PArrowField, Init(R)));

      R.Assign(25,163,88,183);
      Control := Insert(New(PNumInput, Init(R, Low(Line), High(Line),
        PArrowField(Control))));

      R.Assign (25,140,35 + TextWidth(GetStr(738)),160);
      Insert(New (PLabel, Init (R, GetStr(738), Control)));

      { Buttons }
      R.Assign(140, 40, 240, 68);
      Insert(New(PButton, Init(R, GetStr(739),cmOK, bfDefault)));
      R.Assign(140, 90, 240, 118);
      Insert(New(PButton, Init(R, GetStr(740),cmCancel, bfNormal)));
      SelectNext(false);
    End;
    { .... und ausfhren }
    Move(Self.Count, Data, 6);
    If Application^.ExecuteDialog(D, @Data) = cmOK then
      SetParams(Data[0], Data[1], Data[2]);
  End;
End;

procedure TMystify.SetParams(ACount, AVertex, ALines: Integer);
const Distance = 5;
var I, J, H: Byte;
    X, Y: Integer;
Begin
  { alte Daten lschen }
  If Myst <> nil then Begin
    For I := 0 to Count * Lines - 1 do
      FreeMem(Myst^[I], SizeOf(TVertex) * Vertex);
    FreeMem(Myst, SizeOf(PPoly) * Count * Lines);
    FreeMem(Colors, SizeOf(Byte) * Count);
    Myst := nil;
  End;

  { neue Daten initialisieren }
  If ACount > 0 then Begin
    GetMem(Myst, SizeOf(PPoly) * ACount * ALines);
    GetMem(Colors, SizeOf(Byte) * ACount);

    I := 0;
    While I < ACount * ALines do Begin
      For J := 0 to ALines - 1 do
        GetMem(Myst^[I+J], SizeOf(TVertex) * AVertex);

      For J := 0 to AVertex - 1 do With Myst^[I]^[J] do Begin
        P.X := Random(Size.X - ALines * Distance);
        P.Y := Random(Size.Y - ALines * Distance);
        Vec.X := Random(21) - 10; Vec.Y := Random(21) - 10;
      End;

      For J := 1 to ALines - 1 do
        For H := 0 to AVertex - 1 do Begin
          X := Myst^[I+J-1]^[H].P.X + Distance;
          Y := Myst^[I+J-1]^[H].P.Y + Distance;

          Myst^[I+J]^[H].P.X := X;
          Myst^[I+J]^[H].P.Y := Y;
          Myst^[I+J]^[H].Vec := Myst^[I+J-1]^[H].Vec;
        End;
      Colors^[I div ALines] := Random(15) + 1;
      Inc(I, ALines)
    End;
  End;
  Count := ACount;
  Lines := ALines;
  Vertex := AVertex;

  DrawView;
End;

procedure TMystify.UpDate;
const ChangeColor = 400;
var I, J: Byte;
    N: TPoint;
Begin
  For I := 0 to Count*Lines - 1 do Begin
    DrawPoly(Myst^[I], Black);
    For J := 0 to Vertex - 1 do With Myst^[I]^[J] do Begin
      N.X := Min(Size.X, Max(0, P.X + Vec.X));
      N.Y := Min(Size.Y, Max(0, P.Y + Vec.Y));
      If (N.X = 0) or (N.X = Size.X) then
        Vec.X := -Vec.X;
      If (N.Y = 0) or (N.Y = Size.Y) then
        Vec.Y := -Vec.Y;
      P := N;

      If Random(ChangeColor) = 0 then Colors^[I div Lines] := Random(15) + 1;
    End;
    DrawPoly(Myst^[I], Colors^[I div Lines])
  End
End;

{*************************** TNastyButton object ****************************}

procedure TNastyButton.ChangeBounds(var Bounds: TRect);
var R: TRect;
Begin
  If GOwner <> nil then Begin
    PWindow(GOwner)^.GetClientRect(R);
    Bounds.Move(Max(0, R.A.X - Bounds.A.X), Max(0, R.A.Y - Bounds.A.Y));
  End;
  inherited ChangeBounds(Bounds);
End;

procedure TNastyButton.HandleEvent(var Event: TEvent);
const Nastyness = 10;
var P, Vec: TPoint;
    R: TRect;
Begin
  If Event.What and evMouse <> 0 then P := Event.Where
  Else P := MouseWhere;
  If MouseInView(P) then Begin
    MakeLocal(P, P);
    If Min(P.X, Size.X div 2) = P.X then Vec.X := P.X + Random(Nastyness)
                                    else Vec.X := - (Size.X - P.X + Random(Nastyness));
    If Min(P.Y, Size.Y div 2) = P.Y then Vec.Y := P.Y + Random(Nastyness)
                                    else Vec.Y := - (Size.Y - P.Y + Random(Nastyness));
    Inc(Vec.X,Origin.X); Inc(Vec.Y, Origin.Y);
    PWindow(GOwner)^.GetClientRect(R);
    If (Vec.X < R.A.X) or (Vec.X + Size.X > R.B.X) then
      Vec.X := R.A.X + Random(R.B.X - R.A.X - Size.X);
    If (Vec.Y < R.A.Y) or (Vec.Y + Size.Y > R.B.Y) then
      Vec.Y := R.A.Y + Random(R.B.Y - R.A.Y - Size.Y);

    Moveto(Vec.X, Vec.Y);
  End
  Else inherited HandleEvent(Event);
End;

(*************************** TGNastyButton object ***************************)

procedure TGNastyButton.ChangeBounds(var Bounds: TRect);
var R: TRect;
Begin
  If GOwner <> nil then Begin
    PWindow(GOwner)^.GetClientRect(R);
    Bounds.Move(Max(0, R.A.X - Bounds.A.X), Max(0, R.A.Y - Bounds.A.Y));
  End;
  inherited ChangeBounds(Bounds);
End;

procedure TGNastyButton.HandleEvent(var Event: TEvent);
const Nastyness = 10;
var P, Vec: TPoint;
    R: TRect;
Begin
  If Event.What and evMouse <> 0 then P := Event.Where
  Else P := MouseWhere;
  If MouseInView(P) then Begin
    MakeLocal(P, P);
    If Min(P.X, Size.X div 2) = P.X then Vec.X := P.X + Random(Nastyness)
                                    else Vec.X := - (Size.X - P.X + Random(Nastyness));
    If Min(P.Y, Size.Y div 2) = P.Y then Vec.Y := P.Y + Random(Nastyness)
                                    else Vec.Y := - (Size.Y - P.Y + Random(Nastyness));
    Inc(Vec.X, Origin.X); Inc(Vec.Y, Origin.Y);
    PWindow(GOwner)^.GetClientRect(R);
    If (Vec.X < R.A.X) or (Vec.X + Size.X > R.B.X) then
      Vec.X := R.A.X + Random(R.B.X - R.A.X - Size.X);
    If (Vec.Y < R.A.Y) or (Vec.Y + Size.Y > R.B.Y) then
      Vec.Y := R.A.Y + Random(R.B.Y - R.A.Y - Size.Y);

    Moveto(Vec.X, Vec.Y);
  End
  Else inherited HandleEvent(Event);
End;

(**************************** TMyListBox object *****************************)

destructor TMyListBox.Done;
Begin
  NewList(nil);
  inherited Done
End;

(**************************** TGListBox object ******************************)

constructor TGListBox.Init(var Bounds: TRect; AScrollBar: PScrollBar);
var L: PCollection;
Begin
  inherited Init(Bounds, AScrollBar);
  Nilhorn := LoadBitmapImg(Res^, 'Nilhorn');
  Ghost := LoadBitmapImg(Res^, 'WhiteGhost');
  L := New(PStringCollection, Init(8, 8));
  With L^ do Begin
    AtInsert(Count, NewStr(GetStr(794)));
    AtInsert(Count, NewStr(GetStr(795)));
    AtInsert(Count, NewStr(' '));
    AtInsert(Count, NewStr('Text'));
    AtInsert(Count, NewStr(' '));
    AtInsert(Count, NewStr(GetStr(796)));
    AtInsert(Count, NewStr(' '));
    AtInsert(Count, NewStr('Yeah'));
    AtInsert(Count, NewStr(' '));
  End;
  Font := New(PFont, Init('Times', PixelToScaling(50), ftNormal, nil));
  NewList(L);
  Flags := lfPartialLines;
End;

destructor TGListBox.Done;
Begin
  FreeImage(Nilhorn);
  FreeImage(Ghost);
  NewList(nil);
  Dispose(Font, Done);
  inherited Done;
End;

procedure TGListBox.DrawItemText(Item: Integer; R: TRect);
var Sub: TRect;

 procedure WriteNormText(S: String; var R: TRect);
 Begin
   Dec(R.B.Y, R.A.Y);
   OutTextXY(R.A.X, R.A.Y + R.B.Y div 2 + 1, S);
 End;

 procedure WriteBigText(S: String; var R: TRect);
 var C: Byte;
 Begin
   If GetState (sfSelected) then
     If Item=Focused then C := 4
                     else C := 3
   Else C := 3;
   SetTextParams(Font^.GetFontHandle, 2, GetColor(C), true);
   SetTextJustify(CenterText, CenterText);
   Dec(R.B.X, R.A.X); Dec(R.B.Y, R.A.Y);
   OutTextXY(R.A.X + R.B.X div 2 - 1,  R.A.Y + R.B.Y div 2 + 1, S);
 End;

Begin
  GetItemSubRect(Sub);
  Sub.Intersect(R);
  SetSubRect(Sub);
  Case Item Of
    3, 7: WriteBigText(GetText(Item, $FF), R);
    6: PasteImage(R.A.X + (R.B.X - R.A.X) div 2 - 16, R.A.Y + 1,
	 Ghost, NormalPut);
    8: PasteImage(R.A.X + (R.B.X - R.A.X) div 2 - 75, R.A.Y + 1,
	 Nilhorn, NormalPut);
   else WriteNormText(GetText(Item, $FF), R);
  End;
End;

procedure TGListBox.GetItemRect(Item: Integer; var R: TRect);
var i, s: Byte;
Begin
  GetItemSubRect(R);
  R.B.Y := R.A.Y;
  For i := TopItem to Item do Begin
    Case i of
      3, 7: s := 50;
      6: s := 34;
      8: s := 102;
     else s := 15;
    End;
    Inc(R.B.Y, s);
  End;
  R.A.Y := R.B.Y - s;
End;

(**************************** TMyDesktop object *****************************)

constructor TMyDesktop.Init(var Bounds: TRect; Bitmap: String;
  FactorX, FactorY: Integer);
var
  R: TRect;
Begin
  inherited Init(Bounds, Bitmap, FactorX, FactorY);
  R.Assign(0, 0, 128, 96);
  R.Move(400, 200);
  ImageWindow := New(PDesktopImageWindow, Init(R, 'Desktop'));
  With ImageWindow^ do Begin
    Flags := (Flags or wfHideClose) and not wfZoom;
    Options := Options or ofHoldFirst;
    HelpCtx := hcNormWindow;
    PDesktopImage(Interior)^.Group := @Self;
    Hide
  End;
  Application^.Insert(ImageWindow);
End;

procedure TMyDesktop.HandleEvent(var Event: TEvent);
var R: TRect;
Begin
  inherited HandleEvent(Event);
  If (Event.What = evMouseDown) and (Event.Buttons = mbRightButton) and
    MouseInView(Event.Where)
  then Begin
    R.A := Event.Where;
    With ImageWindow^ do Begin
      R.B.X := R.A.X + Size.X;
      R.B.Y := R.A.Y + Size.Y;
      R.Move(- Size.X div 2, - Size.Y div 2);
      Locate(R);
      If not GetState(sfVisible) then Show
    end;
  End;
  If ((Event.What = evCommand) and (Event.Command = cmDesktopImage)) or
     ((Event.What = evKeyDown) and (Event.KeyCode = kbAltF10))
  then
    With ImageWindow^ do
      If GetState(sfVisible) then Hide else Show;
End;

(***************************** TDemoApp object ******************************)

constructor TDemoApp.Init;
var R: TRect;
Begin
  Res := OpenResource('gvdemo21.dll');

  VirtualFactor.X := 3;
  VirtualFactor.Y := 3;
  BackBitmap := 'nilhorn.bmp' {GetWinDir + 'BLAETTER.BMP'};
  IsVirtual := false;

  InitBWCC;
  If BWCC = nil then BWCC := Res;
  InitClasses;
  RegisterGvWinDlg;

  WindowCmds := WindowCmds + [cmCloseAll];
  DisableCommands([cmCloseAll {$ifdef Windows}, cmDos, cmScreenMode {$endif Windows}]);

  inherited Init;

  Main^.SetTitle('Graphics Vision Demo');
  RegisterHelpFile;
  New(TheHelpStateStack, Init(16));

  R.Assign (Main^.Size.X-160, -1, Main^.Size.X-70, 21);
  Heap:=New (PHeapView, Init (R));
  If Heap<>nil then PGView(Main^.Insert(Heap))^.GrowMode := gfGrowHiX + gfGrowLoX;
  R.Assign (Main^.Size.X-71, -1, Main^.Size.X+1, 21);
  Clock:=New (PClockView, Init (R));
  If Clock<>nil then PGView(Main^.Insert(Clock))^.GrowMode := gfGrowHiX + gfGrowLoX;

  Randomize;
End;

destructor TDemoApp.Done;
Begin
  Dispose(TheHelpStateStack, Done);
  TheHelpStateStack := nil;
  inherited Done;
  DoneClasses;
  if Res <> BWCC then DoneBWCC;
  Dispose(Res, Done);
End;

procedure TDemoApp.GetEvent(var Event: TEvent);
{ keep the time when the last user-input event occured
}
begin
  inherited GetEvent(Event);
  If Event.What and (evMouse + evKeyboard) <> 0
  then LastEvent := GetTimerTicks
end;

{$ifdef FPK}
{$asmmode intel}
{$endif}
procedure MultiStates; Assembler;
Asm
      DW	13
      DW	0000000000000000B
      DW	0000000000000000B
      DW	0000000000000000B
      DW	0000000000000000B
      DW	0000000000000000B
      DW	0000000000000000B
      DW	0000000000000000B
      DW	0000000000000000B
      DW	0000000000000000B
      DW	0000000000000000B
      DW	0000000000000000B
      DW	0000000000000000B
      DW	0000000000000000B
      DW 	13
      DW	0000000000000000B
      DW	0100000000010000B
      DW	0010000000100000B
      DW	0001000001000000B
      DW	0000100010000000B
      DW	0000010100000000B
      DW	0000001000000000B
      DW	0000010100000000B
      DW	0000100010000000B
      DW	0001000001000000B
      DW	0010000000100000B
      DW	0100000000010000B
      DW	0000000000000000B
      DW	13
      DW	0000000000000000B
      DW	0000000000000000B
      DW	0000011100000000B
      DW	0000100010000000B
      DW	0001100011000000B
      DW	0010010100100000B
      DW	0010000000100000B
      DW	0010010100100000B
      DW	0001100011000000B
      DW	0000100010000000B
      DW	0000011100000000B
      DW	0000000000000000B
      DW	0000000000000000B
      DW	13
      DW        0000000000000000B
      DW        0000000001000000B
      DW        0000000001000000B
      DW        0000000011000000B
      DW        0000000010000000B
      DW        0000000110000000B
      DW        0011000100000000B
      DW        0001101100000000B
      DW        0000101000000000B
      DW        0000111000000000B
      DW        0000010000000000B
      DW        0000000000000000B
      DW        0000000000000000B
End;

procedure TDemoApp.HandleEvent(var Event: TEvent);

  procedure FileOpen(FileName: PathStr);
  var
    R: TRect;
  Begin
    R.Assign(0, 0, 400, 300);
    R.Move(Random(240), Random(140));
    InsertWindow(New(PTextWindow, Init(R, Filename, wnJustANumber)))^.HelpCtx :=
      hcNormWindow;
    If LowMemory then OutOfMemory;
  End;

  procedure OpenFileDlg;
  var
    D: PFileDialog;
    S: PathStr;
  begin
    D := PFileDialog(ValidView(New(PFileDialog,
      Init('*.txt', GetStr(702), GetStr(703), fdOpenButton, 40))));
    If D = nil then Exit;
    D^.HelpCtx := hcNormDialog;
    if Desktop^.ExecView(D) <> cmCancel
    then begin
      D^.GetFileName(S);
      FileOpen(S)
    end;
    Dispose(D, Done)
  end;

  procedure BitmapOpen(FileName: PathStr);
  var
    R: TRect;
  Begin
    R.Assign(0, 0, 300, 200);
    R.Move(Random(340), Random(240));
    InsertWindow(New(PBitmapWindow, Init(R, Filename, wnJustANumber)))^.HelpCtx :=
      hcNormWindow;
  End;

  procedure OpenBitmapDlg;
  var
    D: PFileDialog;
    S: PathStr;
  begin
    D := PFileDialog(ValidView(New(PFileDialog,
      Init('*.bmp', GetStr(704), GetStr(703), fdOpenButton, 41))));
    If D = nil then Exit;
    D^.HelpCtx := hcNormDialog;
    if Desktop^.ExecView(D) <> cmCancel
    then begin
      D^.GetFileName(S);
      BitmapOpen(S)
    end;
    Dispose(D, Done)
  end;

  procedure ShowMorph;
  var
    R: TRect;
    Window: PWindow;
  begin
    R.Assign(0, 0, 421, 260);
    R.Move(Random(220), Random(200));
    Window := New(PMorphWindow, Init(R));
    InsertWindow(Window)
  end;

  procedure ShowClock;
  var
    R: TRect;
    Window: PWindow;
    i: Integer;
  begin
    i := Random(150) + 80;
    R.Assign(0, 0, i, i);
    R.Move(Random(Desktop^.Size.X-i), Random(Desktop^.Size.Y-i));
    Window := New(PStandardClockWindow, Init(R, clmAnalog, nil));
    Window^.HelpCtx := hcNormWindow;
    InsertWindow(Window)
  end;

  procedure ShowEyes;
  var
    R: TRect;
    i: Integer;
  begin
    i := Random(150) + 80;
    R.Assign(0, 0, i, i);
    R.Move(Random(Desktop^.Size.X-i), Random(Desktop^.Size.Y-i));
    If Random(2) = 0 then
      InsertWindow(New(PEyeWindow, Init(R)))
    Else PGView(Desktop^.Insert(New(PDesktopEyes, Init(R))))^.
	   HelpCtx := hcEyesInf;
  end;

  procedure ShowCharMap;
  var
    W: PCharMapWindow;
    R: TRect;
  begin
    R.Assign(0, 0, 400, 250);
    W := New(PCharMapWindow, Init(R));
    W^.Options := W^.Options or ofCentered;
    InsertWindow(W)
  end;

  procedure ShowFiler;
  var
    W: PWindow;
    R, Client, Sheet: TRect;
  begin
    R.Assign(0, 0, 300, 300);
    R.Move(Random(340), Random(140));
    W := New(PWindow, Init(R, GetStr(797), wnJustANumber));
    with W^ do
    begin
      Palette := wpGrayWindow;
      GetClientRect(Client);
      R.Assign(Client.A.X, Client.A.Y, Client.B.X, Client.A.Y + 20);
      with PFilerBar(Insert(New(PFilerBar, Init(R, fbProportionalWidth))))^ do
      begin
	Sheet.Assign(Client.A.X, Client.A.Y + 20, Client.B.X, Client.B.Y);
	with InsertSheet(New(PFilerSheet, Init(Sheet, GetStr(817))))^ do
	begin
	  R.Assign(10, 10, Size.X - 10, Size.Y - 10);
	  Insert(New(PEyes, Init(R)))
	end;
	with InsertSheet(New(PFilerSheet, Init(Sheet, GetStr(818))))^ do
	begin
          R.Assign(9, 9, Size.X - 9, Size.Y - 9);
	  PGView(Insert(New(PLevel, Init(R, -1))))^.GrowMode := gfGrowHiX + gfGrowHiY;
	  R.Assign(10, 10, Size.X - 10, Size.Y - 10);
	  Insert(New(PClock, Init(R)))
	end;
	with InsertSheet(New(PFilerSheet, Init(Sheet, GetStr(819))))^ do
	begin
	  R.Assign(10, 10, Size.X div 2 - 10, Size.Y div 2 - 10);
	  { Oh what nicely complicated expressions are possible with
	    a functional TGGroup.Insert...
	  }
	  PGView(Insert(New(PClock, Init(R))))^.GrowMode :=
	    gfGrowHiX + gfGrowHiY;
	  R.Move(Size.X div 2, 0);
	  PGView(Insert(New(PClock, Init(R))))^.GrowMode :=
	    gfGrowLoX + gfGrowHiX + gfGrowHiY;
	  R.Move(0, Size.Y div 2);
	  PGView(Insert(New(PClock, Init(R))))^.GrowMode :=
	    gfGrowLoX + gfGrowHiX + gfGrowLoY + gfGrowHiY;
	  R.Move(-Size.X div 2, 0);
	  PGView(Insert(New(PClock, Init(R))))^.GrowMode :=
	    gfGrowHiX + gfGrowLoY + gfGrowHiY
	end;
      end
    end;
    InsertWindow(W)
  end;

  procedure ShowGhost;
  var R: TRect;
  Begin
    R.Assign(0, 0, 32, 32);
    R.Move(Random(600), Random(400));
    Desktop^.Insert(New (PGhost, Init (R)));
  End;

  procedure LoadDesktop;
  var D: PFileDialog;
  Begin
    D := PFileDialog(ValidView(New(PFileDialog,
      Init('*.bmp', GetStr(705), GetStr(703), fdOpenButton, 42))));
    If D = nil then Exit;
    D^.HelpCtx := hcNormDialog;
    If ExecuteDialog(D, @BackBitmap) <> cmCancel then
      PNewDesktop(Desktop)^.NewBitmap(BackBitmap);
  End;


  procedure ShowHelp;
  var W: PWindow;
      {S: String;
      Dir: DirStr;
      N: NameStr;
      E: ExtStr;}

	function IsHelpWindow(P: PGView): Boolean; {$ifndef FPK}far;{$endif}
	begin
	  IsHelpWindow := TypeOf(P^) = TypeOf(THelpWindow)
	end;

  Begin
    W := PWindow(Desktop^.FirstThat(@IsHelpWindow));
    If W <> nil
    then W^.Select {don't load a second copy}
    else begin
      {S := ParamStr(0);
      FSplit(S, Dir, N, E);}
      Help := New(PBufStream, Init({Dir +} 'gvdemo.hlp', stOpenRead, 4096));
      If (Help = nil) or (Help^.Status <> stOK) then Begin
	MessageBox(GetStr(720), nil, mfWarning + mfOkButton);
	DisableCommands([cmGVHelp]);
      End
      Else Begin
	W := PWindow(ValidView(New(PHelpWindow,
	  InitWithButtons(New (PHelpFile, Init(Help)), 3))));
	If W = nil then Exit;
	W^.HelpCtx := hcHelpWindow;
	InsertWindow(W);
      End;
    End;
  End;

  procedure ShowMsgBoxes;
  var R: TRect;
  Begin
    MessageBox(GetStr(721), nil, mfInformation+mfOKButton);
    MessageBox(GetStr(722), nil, mfWarning+mfOKButton);
    MessageBox(GetStr(723), nil, mfError+mfOKButton);
    MessageBox(GetStr(724), nil, mfConfirmation+mfYesButton);
    R.Assign(400, 250, 600, 400);
    MessageBoxRect(R, GetStr(725), nil, mfInformation+mfOKButton);
    MessageBoxTitle(GetStr(726), GetStr(727), nil, mfInformation+mfOKButton);
    MessageBoxTitle(GetStr(728), GetStr(729), nil, mfWarning+mfYesButton)
  End;

  procedure ShowMystify;
  var W: PWindow;
      R: TRect;
  Begin
    R.Assign(0, 0, 200 + Random(200), 150 + Random(200));
    R.Move(Random(240), Random(70));
    W := New(PWindow, Init(R, GetStr(732), wnJustANumber));
    With W^ do Begin
      Flags := Flags and not wfBackground;
      Frame^.Options := Frame^.Options and not ofFirstPass;
      GetClientRect(R);
      Insert(New(PMystify, Init(R, Random(2) + 1, Random(4) + 3, 3)));

      HelpCtx := hcNormWindow;
    End;
    InsertWindow(W);
  End;

  procedure ShowWindowDialog;
  var B: PBmpView;
      R: TRect;
      S: PChar;
  Begin
    R.Assign(0, 0, 0, 0);
    B := New(PBmpView, InitByImages(R, LoadBitmapImg(Res^, 'RW'),
      bmfAdjustSize));
    With B^ do Options := Options or ofCentered;
    Desktop^.Insert(B);
    Delay(1000);
    Dispose(B, Done);

    MessageBox(GetStr(733), nil, mfInformation+mfOKButton);
    If Language = lfGerman then S := 'WinDialog'
    else If Language = lfEnglish then S := 'WinDialog_Eng';
    ExecuteDialog(LoadDialog(Res^, S), nil);
    MessageBox(GetStr(734), nil, mfInformation+mfOKButton);
    If Language = lfGerman then S := 'BorDialog'
    else If Language = lfEnglish then S := 'BorDialog_Eng';

    ExecuteDialog(LoadDialog(Res^, S), nil);
  End;

  procedure ShowNastyButton;
  const Count = 4;
  var W: PWindow;
      R: TRect;
      C, I: Word;
  Begin
    R.Assign(0, 0, 200 + Random(200), 100 + Random(200));
    R.Move(Random(240), Random(180));
    W := New(PWindow, Init(R, GetStr(741), wnJustANumber));
    C := Random(Count);
    With W^ do For I := 0 to C do Begin
      GetClientRect(R);
      If (Random(2) = 0) or (BWCC = nil) then Begin
	SetTextParams(ftSansSerif, 0, 0, false);
	R.Assign(R.A.X, R.A.Y, R.A.X + TextWidth(GetStr(742)) + Random(100),
	  R.A.Y + 28 + Random(20));
	R.Move(Random(Size.X - R.B.X), Random(Size.Y - R.B.Y));
	PGView(Insert(New(PNastyButton, Init(R, GetStr(742), cmNastyButton,
	  bfNormal))))^.GrowMode := gfGrowAll;
      End
      Else Begin
	R.Assign(R.A.X, R.A.Y, R.A.X + BWCCButtonSize.X + 2, R.A.Y + BWCCButtonSize.Y + 2);
	R.Move(Random(Size.X - R.B.X), Random(Size.Y - R.B.Y));
	PGView(Insert(New(PGNastyButton, InitByBWCC(R, GetStr(742), BWCC,
	  Random(7) + 1, cmNastyButton, bfNormal))))^.GrowMode := gfGrowAll;
      End;
    End;
    InsertWindow(W);
  End;

  procedure ShowListViewer;
  var
    R, Cl: TRect;
    Mid: TPoint;
    D: PDialog;
    VSB, HSB: PScrollbar;
    Fields: PTableFields;
    Entries, Ent2: PCollection;
    Table: PTableViewer;
    L: PListBox;
    IL: PInputLine;
    i: Byte;
  begin
    R.Assign(0, 0, 600, 430);
    D := New(PDialog, Init(R, GetStr(778)));
    With D^ do Begin
      Palette := wpGrayWindow;
      HelpCtx := hcNormDialog;
      Flags := Flags and not wfGrow;
      Options := Options or ofCentered;
      GetClientRect(Cl); Dec(Cl.B.Y, 60);
      With Cl do Begin
        Mid.X := A.X + (B.X - A.X) div 2;
        Mid.Y := A.Y + (B.Y - A.Y) div 2;
      End;

      { Tabelle }
      With Cl do
        R.Assign(Mid.X - 33, A.Y + 29, Mid.X - 15, Mid.Y - 27);
      VSB := Insert(New(PScrollbar, Init(R)));
      With Cl do
        R.Assign(A.X + 30, Mid.Y - 28, Mid.X - 32, Mid.Y - 10);
      HSB := Insert(New(PScrollbar, Init(R)));
      Fields := New(PTableFields, Init);
      With Fields^ do Begin
        DecimalField(GetStr(779), 70, 5);
	LeftField(GetStr(780), 100);
        CenterField(GetStr(781), 70);
        RightField(GetStr(782), 100);
      End;
      With Cl do
        R.Assign(A.X + 30, A.Y + 10, Mid.X - 32 , Mid.Y - 27);
      Table := Insert(New(PTableViewer, Init(R, HSB, VSB, Fields)));
      Ent2 := New(PStringCollection, Init(8, 8));
      With Ent2^ do Begin
	AtInsert(Count, NewStr(GetStr(783)));
	AtInsert(Count, NewStr(GetStr(784)));
	AtInsert(Count, NewStr(GetStr(785)));
        AtInsert(Count, NewStr(GetStr(786)));
      End;
      Table^.NewList(Ent2);

      { Normale Listbox }
      With Cl do
        R.Assign(B.X - 48, A.Y + 10, B.X - 30, Mid.Y - 10);
      VSB := Insert(New(PScrollBar, Init(R)));
      With Cl do
        R.Assign(Mid.X + 15, A.Y + 10, B.X - 47, Mid.Y - 10);
      L := Insert(New(PMyListBox, Init(R, VSB)));
      Entries := New(PStringCollection, Init(8, 8));
      With Entries^ do Begin
        AtInsert(Count, NewStr(GetStr(787)));
        AtInsert(Count, NewStr(GetStr(788)));
        AtInsert(Count, NewStr(GetStr(789)));
        AtInsert(Count, NewStr(GetStr(790)));
        For i := 1 to 20 do AtInsert(Count, NewStr(' '));
        AtInsert(Count, NewStr('Yeah !'));
      End;
      L^.NewList(Entries);

      { Graphische Listbox }
      With Cl do
        R.Assign(Mid.X - 33, Mid.Y + 10, Mid.X - 15, B.Y - 10);
      VSB := Insert(New(PScrollBar, Init(R)));
      With Cl do
        R.Assign(A.X + 30, Mid.Y + 10, Mid.X - 32, B.Y - 10);
      Insert(New(PGListBox, Init(R, VSB)));

      { Combobox }
      With Cl do
        R.Assign(Mid.X + 15, Mid.Y + 30, B.X - 47, Mid.Y + 50);
      IL := Insert(New(PInputLine, Init(R, 46)));
      L := New(PComboViewer, Init(IL));
      Entries := New(PStringCollection, Init(8, 8));
      With Entries^ do Begin
	Insert(NewStr(GetStr(791)));
	Insert(NewStr(GetStr(792)));
	Insert(NewStr(GetStr(793)))
      End;
      L^.NewList(Entries);
      PComboViewer(L)^.Validator^.Strict := true;
      With Cl do
        R.Assign(B.X - 48, Mid.Y + 30, B.X - 30, Mid.Y + 50);
      Insert(New(PCombo, Init(R, PComboViewer(L))));

      { Buttons }
      R.Assign(180, Size.Y - 55, 280, Size.Y - 25);
      Insert(New(PButton, Init(R, GetStr(739), cmOK, bfDefault)));
      R.Move(120, 0);
      Insert(New(PButton, Init(R, GetStr(740), cmCancel, bfNormal)));
      SelectNext(false);

    end;
    ExecuteDialog(D, nil);
    Dispose(Entries, Done);
    Dispose(Ent2, Done)

  end;

{$ifndef Windows}
  procedure ScreenMode;
  const
    Modes: array[0..5] of Word =
{$ifdef FPK}
  {$ifdef Linux}
    (gr640x480x16, gr360x480x256, gr800x600x256,
     gr1024x768x256, gr800x600x32K, gr800x600x64K);
  {$else}
    (gr640x480x256, gr800x600x256, gr1024x768x256,
     gr1280x1024x256, gr1024x768x32K, gr1024x768x64K);
  {$endif}
{$else}
     (gr640x480x16, gr720x480x16, gr800x600x16,
       gr640x480x256, gr800x600x256, gr1024x768x256);
{$endif}
    Min = 1; Max = 5;
  var
    Data: record
      Mode: Word;
      Stat: Word;
      Virt: Word;
      X, Y: LongInt;
    end;

    D: PDialog;
    R: TRect;
    Control: PGView;
    i: Integer;

    procedure Rangify(P: Pointer; Min, Max: LongInt);
    var Val: PValidator;
    begin
      Val := New(PRangeValidator, Init(Min, Max));
      Val^.Options := Val^.Options or voTransfer;
      PInputLine(P)^.SetValidator(Val)
    end;

  Begin
    R.Assign(0, 0, 450, 260);
    D := New(PDialog, Init(R, GetStr(746)));
    With D^ do Begin
      Options := Options or ofCentered;
      HelpCtx := hcNormDialog;
      R.Assign(30, 65, 250, 166);
      { FIXME: Change mode names in a cooler way }
      Control := PGView(Insert(New(PRadioButtons, Init(R,
{$ifdef Linux}
	NewSItem('640x480x16',
        NewSItem('360x480x256',
        NewSItem('800x600x256',
        NewSItem('1024x768x256',
        NewSItem('800x600x32K',
        NewSItem('800x600x64K', nil))))))))));
{$else}			
	NewSItem(GetStr(751),
        NewSItem(GetStr(752),
        NewSItem(GetStr(753),
        NewSItem(GetStr(754),
        NewSItem(GetStr(755),
        NewSItem(GetStr(756), nil))))))))));
{$endif}
      R.Assign(30, 40, 130, 60);
      Insert(New(PLabel, Init(R, GetStr(747), Control)));

      R.Assign(270, 65, 410, 85);
      Control := PGView(Insert(New(PCheckBoxes, Init(R,
        NewSItem(GetStr(750), nil)))));
      R.Assign(270, 40, 370, 60);
      Insert(New(PLabel, Init(R, GetStr(749), Control)));

      R.Assign(270, 130, 380, 150);
      Control := PGView(Insert(New(PCheckBoxes, Init(R,
        NewSItem(GetStr(758), nil)))));
      R.Assign(270, 105, 370, 125);
      Insert(New(PLabel, Init(R, GetStr(757), Control)));

      R.Assign(280, 163, 300, 183);
      Insert(New(PStatictext, Init(R, 'X')));
      R.Assign(300, 160, 330, 180);
      Rangify(Insert(New(PInputLine, Init(R, 5))), 1, 5);

      R.Assign(350, 163, 370, 183);
      Insert(New(PStatictext, Init(R, 'Y')));
      R.Assign(370, 160, 400, 180);
      Rangify(Insert(New(PInputLine, Init(R, 5))), 1, 5);

      R.Assign(130, 200, 230, 230);
      Insert(New(PButton, Init(R, GetStr(739), cmOK, bfDefault)));
      R.Move(120, 0);
      Insert(New(PButton, Init(R, GetStr(740), cmCancel, bfNormal)));
      SelectNext(false);
    End;
    For i := 5 downto 0 do begin
      If Modes[i] = GrMode then begin
	Data.Mode := i;
	Break;
      end;
    end;
    Data.Stat := Byte(StatusLine^.GetState(sfVisible));
    Data.Virt := Byte(IsVirtual);
    Data.X := VirtualFactor.X;
    Data.Y := VirtualFactor.Y;

    If ExecuteDialog(D, @Data) <> cmCancel then Begin
      IsVirtual := Data.Virt = 1;
      VirtualFactor.X := Data.X;
      VirtualFactor.Y := Data.Y;
      Lock;
      If Modes[Data.Mode] <> GrMode then Begin
	PNewDesktop(Desktop)^.NewBitmap('');
	SetScreenMode(Modes[Data.Mode]);
	PNewDesktop(Desktop)^.NewBitmap(BackBitmap)
      End;
      GetExtent(R);
      R.A.Y := Menubar^.Origin.Y + Menubar^.Size.Y;

      If Data.Stat = 0 then StatusLine^.Hide
      Else Begin
	R.B.Y := StatusLine^.Origin.Y;
	StatusLine^.Show;
      End;
      Desktop^.Locate(R);
      If IsVirtual then
        PVirtualDesktop(Desktop)^.SetFactor(VirtualFactor.X, VirtualFactor.Y)
      Else PVirtualDesktop(Desktop)^.SetFactor(1, 1);
      Unlock;
      If GrMode <> Modes[Data.Mode] then
	MessageBox(GetStr(748), nil, mfError + mfOkButton);
    End;
  End;
{$endif Windows}

  procedure ShowCluster;
  var D: PDialog;
      R, Cl: TRect;
      Mid: TPoint;
  const Data: Record R, C: Word; M: LongInt end = (R: 4; C: $001D;
    M: $9BC);
  Begin
    R.Assign(0, 0, 500, 340);
    D := New(PDialog, Init(R, GetStr(798)));
    With D^ do Begin
      Options := Options or ofCentered;
      HelpCtx := hcNormDialog;
      GetClientRect(Cl); Dec(Cl.B.Y, 60);
      With Cl do Begin
        Mid.X := (B.X - A.X) div 2 + A.X;
        Mid.Y := (B.Y - A.Y) div 2 + A.Y
      End;

      { Radiobuttons }
      With Cl do
        R.Assign(A.X + 30, A.Y + 10, Mid.X - 15, Mid.Y - 10);
      Insert(New(PRadioButtons, Init(R,
        NewSItem(GetStr(799),
        NewSItem(GetStr(800),
        NewSItem(GetStr(801),
        NewSItem(GetStr(802),
        NewSItem(GetStr(803),
        NewSItem(GetStr(804), nil)))))))));
      { CheckBoxes }
      With Cl do
        R.Assign(Mid.X + 15, A.Y + 10, B.X - 30, Mid.Y - 10);
      Insert(New(PCheckBoxes, Init(R,
        NewSItem(GetStr(805),
        NewSItem(GetStr(806),
        NewSItem(GetStr(807),
        NewSItem(GetStr(808),
	NewSItem(GetStr(809),
        NewSItem(GetStr(810), nil)))))))));

      { MultiCheckboxes }
      With Cl do
        R.Assign(A.X + 50, Mid.Y + 10, B.X - 50, B.Y - 10);
      Insert(New(PMultiCheckBoxes, Init(R,
        NewSItem(GetStr(811),
        NewSItem(GetStr(812),
        NewSItem(GetStr(813),
        NewSItem(GetStr(814),
        NewSItem(GetStr(815),
        NewSItem(GetStr(816), nil)))))), 4, cfTwoBits, @MultiStates)));

      { Buttons }
      R.Assign(110, Size.Y - 55, 210, Size.Y - 25);
      Insert(New(PButton, Init(R, GetStr(739), cmOK, bfDefault)));
      R.Move(120, 0);
      Insert(New(PButton, Init(R, GetStr(740), cmCancel, bfNormal)));
      SelectNext(false)
    End;
    ExecuteDialog(D, @Data);
  End;

  procedure ShowColor;
  var D: PDialog;
  Begin
    D := PDialog(ValidView(New (PColorDialog, Init ('',
      ColorGroup (GetStr(706),
	ColorItem (GetStr(707), 1, nil),
      ColorGroup (GetStr(708),
	ColorItem (GetStr(709), 2,
	ColorItem (GetStr(710), 3,
	ColorItem (GetStr(711), 4,
	ColorItem (GetStr(712), 5,
	ColorItem (GetStr(713), 6,
	ColorItem (GetStr(714), 7,
        ColorItem (GetStr(715), 8,
        ColorItem (GetStr(716), 9, nil)))))))),
      ColorGroup (GetStr(717),
        ColorItem (GetStr(718), 28,
        ColorItem (GetStr(719), 30, nil)),
      ColorGroup (GetStr(730),
	ColorItem (GetStr(731), 144, nil), nil))))))));
    If D = nil then Exit;
    D^.HelpCtx := hcNormDialog;
    If ExecuteDialog(D, Application^.GetPalette) <> cmCancel then Redraw;
  End;

  procedure LoadPalette;
  var
    D: PFileDialog;
    Path: PathStr;
    S: PStream;
  Begin
    Path := '*.pal';
    D := New(PFileDialog, Init('*.pal', GetStr(820), GetStr(703),
      fdOpenButton, 43));
    If ExecuteDialog(D, @Path) <> cmCancel then Begin
      S := New(PDosStream, Init(Path, stOpenRead));
      S^.Read(GetPalette^[1], Length(CColor));
      Dispose(S, Done);
      (* UseGvPal; {for GVTV} *)
      Redraw
    End
  End;

  procedure SavePalette;
  var
    D: PFileDialog;
    Path: PathStr;
    S: PStream;
  Begin
    Path := '*.pal';
    D := New(PFileDialog, Init('*.pal', GetStr(821), GetStr(703),
      fdOKButton, 43));
    If ExecuteDialog(D, @Path) <> cmCancel then Begin
      S := New(PDosStream, Init(Path, stCreate));
      S^.Write(GetPalette^[1], Length(GetPalette^));
      Dispose(S, Done);
    End
  End;

  procedure Close(P: PGView); {$ifndef FPK}far;{$endif}
  Begin
    If Message(P, evBroadCast, cmHeyYou, Desktop) <> nil then
      PWindow(P)^.Close;
  End;

  procedure About;
  var P: PGView;
  Begin
    P := Insert(New(PLightShow, Init));
    MessageBoxTitle(GetStr(700), GetStr(701), nil, mfInformation+mfOkButton);
    Dispose(P, Done);
  End;

var Num: Word;
    Dir: DirStr;
    Name: NameStr;
    Ext: ExtStr;
    Path: PathStr;
    Param: PString;
const FileName: String[12] = '';

begin
  inherited HandleEvent(Event);
  If Event.What = evCommand then
    case Event.Command of
      cmOpentext: OpenFileDlg;
      cmOpenBitmap: OpenBitmapDlg;
      cmChDir: ExecuteDialog(New (PChDirDialog, Init(cdNormal, 30)), nil);
      cmDos: Dosshell;
      cmListViewer: ShowListViewer;
      cmButton: ShowNastyButton;
      cmNastyButton: Begin
                       MessageBox(GetStr(743), nil, mfWarning+mfOkButton);
                       ShowEyes
                     End;
      cmCluster: ShowCluster;
      cmFiler: ShowFiler;
      cmMsgBoxes: ShowMsgBoxes;
      cmClock: ShowClock;
      cmEyes: ShowEyes;
      cmGVTV: ShowMorph;
      cmGhost: ShowGhost;
      cmMystify: ShowMystify;
      cmWinDlg: ShowWindowDialog;
      cmFonts: ShowCharMap;
      cmChangeColor: ShowColor;
      cmLoadPal: LoadPalette;
      cmSavePal: SavePalette;
      cmDesktop: LoadDesktop;
{$ifndef Windows}
      cmScreenMode: ScreenMode;
{$endif Windows}
      cmCloseAll: Desktop^.ForEach(@Close);
      cmWinList: ExecuteWindowList(New (PWListDialog, Init(wlNormal)));
{      cmDesktopImage: ImageWindow^.Show; }
      cmAbout: About;
      cmGVHelp: ShowHelp;
      201: FileName := 'sharware.doc';
      203: FileName := 'cis.doc';
      204: FileName := 'pslorder.doc';
      205: FileName := 'mkmorder.doc';
      206: FileName := 'vendor.doc';
      207: FileName := 'register.doc';
      208: FileName := 'license.doc';
    end;
  If FileName <> '' then Begin
    FSplit(ParamStr(0), Dir, Name, Ext);
    Path := FSearch(FileName, Dir + ';' + Dir + '\..;' + GetEnv('PATH'));
    Param := NewStr(FileName);
    FileName := '';
    If Path <> '' then FileOpen(Path)
    Else MessageBox(GetStr(78), @Param, mfError + mfOKButton);
    DisposeStr(Param);
  End;

  Num := GetNumberFromEvent(Event, etAltNumKeys);
  If Num <> wnNoNumber then
    Message(@Self, evBroadCast, cmSelectWindowNum, Ptr(0, Num));

end;

procedure TDemoApp.Idle;
Begin
  inherited Idle;
  If Heap <> nil then Heap^.UpDate;
  If Clock <> nil then Clock^.UpDate;
End;

procedure TDemoApp.InitDesktop;
var
  R: TRect;
Begin
  Main^.GetExtent(R);
  R.Grow(0, -21);
  If IsVirtual then Desktop := New(PMyDesktop, Init(R, BackBitmap,
    VirtualFactor.X, VirtualFactor.Y))
  Else Desktop := New(PMyDesktop,Init(R, BackBitmap, 1, 1));
End;

{ A little helper function. The menu item name is taken from the
  string resource. The key name (if any) is created by NewItemKN.
}
function NewItemX(Num: Word; Key: Word;
  Command: Word; HelpCtx: Word; Next: PMenuItem): PMenuItem;
begin
  NewItemX := NewItemKN(GetStr(Num), Key, Command, HelpCtx, Next)
end;

function NewStatusKeyX(Num: Word; AKeyCode: Word; ACommand: Word;
  ANext: PStatusItem): PStatusItem;
begin
  NewStatusKeyX := NewStatusKeyKN(GetStr(Num), AKeyCode, ACommand, ANext)
end;

procedure TDemoApp.InitMenuBar;
var
  R: TRect;
Begin
  Main^.GetExtent(R);
  R.B.Y := R.A.Y + 21;
  MenuBar := New(PMenuBar, Init(R, NewMenu(
    NewSubMenu(GetStr(500), hcFile, NewMenu(
      NewItemX(505, kbF3, cmOpenText, hcOpenText,
      NewItemX(506, kbF4, cmOpenBitmap, hcOpenBitmap,
      NewLine(
      NewItemX(507, kbNoKey, cmChDir, hcChDir,
      NewLine(
      NewItemX(509, kbNoKey, cmDos, hcDos,
      NewItemX(510, kbAltX, cmQuit, hcExit,
      nil)))))))),
    NewSubMenu(GetStr(503), hcElemente, NewMenu(
      NewItemX(504, kbNoKey, cmListViewer, hcListViewer,
      NewItemX(511, kbNoKey, cmButton, hcButton,
      NewItemX(512, kbNoKey, cmCluster, hcCluster,
      NewItemX(513, kbNoKey, cmFiler, hcFiler,
      NewItemX(514, kbNoKey, cmMsgBoxes, hcMsgBoxes,
      nil)))))),
    NewSubMenu(GetStr(515), hcSpezial, NewMenu(
      NewItemX(516, kbF9, cmFonts, hcFonts,
      NewLine(
      NewItemX(517, kbNoKey, cmClock, hcClock,
      NewItemX(518, kbNoKey, cmEyes, hcEyes,
      NewItemX(519, kbCtrlF9, cmGVTV, hcGVTV,
      NewItemX(528, kbAltF9, cmGhost, hcGhost,
      NewItemX(529, kbShiftF9, cmMystify, hcMystify,
      NewLine(
      NewItemX(520, kbNoKey, cmWinDlg, hcWinDlg,
      nil)))))))))),
    NewSubMenu(GetStr(501), hcOptions, NewMenu(
      NewSubMenu(GetStr(521), hcColor, NewMenu(
	NewItemX(530, kbNoKey, cmChangeColor, hcChangeColor,
	NewItemX(531, kbNoKey, cmLoadPal, hcLoadPal,
	NewItemX(532, kbNoKey, cmSavePal, hcSavePal,
	nil)))),
      NewLine(
      NewItemX(522, kbNoKey, cmDesktop, hcDesktop,
      NewItemX(508, kbNoKey, cmScreenMode, hcScreenMode,
      nil))))),
    NewSubMenu(GetStr(523), hcWindow, NewMenu(
      StdWindowMenuItems(
      NewLine(
      NewItemX(526, kbAlt0, cmWinList, hcWinList,
      NewItemX(527, kbAltMinus, cmDesktopImage, hcDesktopImage,
      nil))))),
    NewSubMenu(GetStr(502), hcHelp, NewMenu(
      NewSubMenu(GetStr(524), hcAboutMenu, NewMenu(
	NewItemX(533, kbShiftF1, cmAbout, hcAbout,
	NewLine(
	NewItemX(535, kbNoKey, 201, 20001,
	NewSubMenu(GetStr(536), 20002, NewMenu(
	  NewItemX(537, kbNoKey, 203, 20003,
	  NewItemX(538, kbNoKey, 204, 20004,
	  NewItemX(539, kbNoKey, 205, 20005,
	  nil)))),
	NewItemX(540, kbNoKey, 206, 20006,
	nil)))))),
      NewLine(
      NewItemX(525, kbF1, cmGVHelp, hcGVHelp,
      nil)))),
   nil)))))))));
End;

procedure TDemoApp.InitStatusLine;
var R: TRect;
Begin
  Main^.GetExtent(R);
  R.A.Y := R.B.Y - 21;
  StatusLine:=New (PMyStatusLine, Init (R,
    NewStatusDef (hcNoContext, hcNoContext,
      NewStatusKeyX(600, kbAltX, cmQuit,
      NewStatusKeyX(601, kbF10, cmMenu,
      NewStatusKey('', kbCtrlF5, cmResize, nil))),
    NewStatusDef (2, 499,
      NewStatusKeyX(606, kbAltF3,cmClose,
      NewStatusKeyX(607, kbCtrlF5,cmResize,
      NewStatusKeyX(608, kbAltF10, 0, nil))),
    NewStatusDef (500, 699,
      NewStatusKeyX(609, kbEsc, cmCancel,
      NewStatusKeyX(610, kbEnter, cmOk,
      NewStatusKeyX(611, kbCtrlF5, cmResize, nil))),
    NewStatusDef (hcHelpWindow, hcHelpWindow,
      NewStatusKeyX(612, kbCtrlLeft, cmHelpBack,
      NewStatusKeyX(613, kbCtrlRight, cmHelpForward,
      NewStatusKeyX(614, kbEsc, cmClose, nil))),
    {NewStatusDef (hcDragging, hcDragging,
      NewStatusKey (#2'~'#27#26#25#24'~ ' + GetStr(602),kbNoKey,cmError,
      NewStatusKey (#2'~Shift+'#27#26#25#24'~ ' + GetStr(603),kbNoKey,cmError,
      NewStatusKey (#2'~'#17'~ ' + GetStr(604),kbNoKey,cmError,
      NewStatusKey (#2'~Esc~ ' + GetStr(605),kbNoKey,cmError,nil)))),}
    StdDraggingStatusDef(
    NewStatusDef (1001,$FFFF,
      NewStatusKeyX(600, kbAltX, cmQuit, nil),
    nil))))))));
End;

function TDemoApp.LanguageResource: String;
Begin
  Case Language of
    lfGerman: LanguageResource := 'demoger.gvl';
   Else LanguageResource := 'demoeng.gvl';
  End;
End;

procedure TDemoApp.Timer(var Event: TEvent);
const
  HintActive: Boolean = false;
var
  P: PString;
  s: string;
  Wh: TPoint;
  Hint: PGView;
  R: TRect;
  Ev: TEvent;
begin
  inherited Timer(Event);
  If not MouseInstalled then Exit;
  If (Event.InfoLong > LastEvent + HintDelay) and not HintActive
  then begin
    Wh := MouseWhere;
    Ev.What := evPositionalCtx;
    Ev.Where := MouseWhere;
    HandleEvent(Ev);
    if Ev.What = evNothing
      then P := Ev.InfoPtr
    else P := nil;
    If P <> nil
    then begin
      If LongInt(P) < $10000
      then begin
	If LongInt(P) < HelpCtxMinimum then Exit;
	s := GetStr(LongInt(P));
	If s = '' then Exit;
      end
      else s := P^;
      GetExtent(R);
      R.A.X := Wh.x + 15;
      R.A.Y := Wh.y;
      Hint := New(PFlyingHint, Init(R, s));
      Hint^.Options := Hint^.Options or ofHoldFirst;
      HintActive := true;
      ExecView(Hint);
      HintActive := false;
      Dispose(Hint, Done)
    end;
  end;
end;

procedure TDemoApp.WriteShellMsg;
Begin
  PrintStr(GetStr(745));
End;

(**************************** TMyStatusLine object **************************)

function TMyStatusLine.Hint(AHelpCtx: Word): String;
Begin
  If AHelpCtx = 2000 then Hint := ''
  Else Hint := inherited Hint(AHelpCtx);
End;

procedure SetLanguage(S: String);
const MsgStr = 'Type GVDEMO ENGLISH for an English-language demo!'#10#13#10#13+
               'Geben Sie GVDEMO DEUTSCH ein, um das Demo-Programm in'#10#13+
               'deutscher Sprache zu starten!'#10#13;

 function Upstr(S: String): String;
 var i: Byte;
 Begin
   For i := 1 to Length(S) do S[i] := UpCase(S[i]);
   UpStr := S
 End;

Begin
  If S = '' then Begin
    {PrintStr(MsgStr);
    Halt(1)}
    S := 'ENGLISH'
  End;
  If Pos('DEUTSCH', UpStr(S)) <> 0 then Language := lfGerman
  Else If Pos('ENGLISH', UpStr(S)) <> 0 then Language := lfEnglish
       Else Begin
         PrintStr(MsgStr);
         Halt(1)
       End
End;

var App: TDemoApp;

Begin
  SetAnsiCode(false);
  SetLanguage(ParamStr(1));
  App.Init;
  App.Run;
  App.Done;
End.
