
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994 Stefan Milius                }
{                                                       }
{*******************************************************}

{ Portions Copyright (c) 1992 Borland International }

{
  GVMSGBOX.TXT GVMSGBOX.DOC GINFO.TXT NEW.TXT GV.VER
}

Unit GVMsgBox;

{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-}

interface

uses Objects, GvDialog;

const

{ Message box classes }

  mfWarning      = $0000;       { Zeigt eine Warnung }
  mfError        = $0001;       { Zeigt eine Fehlermeldung }
  mfInformation  = $0002;       { Zeigt eine Information an }
  mfConfirmation = $0003;       { Fragt eine Besttigung ab }

{ Message box button flags }

  mfYesButton    = $0100;       { Nimmt einen Ja Schalter in den Dialog auf }
  mfNoButton     = $0200;       { Nimmt einen Nein Schalter in den Dialog auf }
  mfOKButton     = $0400;       { Nimmt einen OK Schalter in den Dialog auf }
  mfCancelButton = $0800;       { Nimmt einen Abbruch Schalter in den Dialog auf }

{ Message box flag for no icon }

  mfNoIcon = $0004;

  mfYesNoCancel  = mfYesButton + mfNoButton + mfCancelButton;
				{ Standard Ja, Nein, Abbruch Dialog }
  mfOKCancel     = mfOKButton + mfCancelButton;
				{ Standard OK, Abbruch Dialog }

{ MessageBox zeigt den angegebenen String in einem Dialogfenster  }
{ an. Bevor das Dialogfenster angezeigt wird, wird Msg und Params }
{ ber FormatString verknpft. Das Ergebnis wird als TStaticText  }
{ View in den Dialog aufgenommen.                                 }

function MessageBox(Msg: String; Params: Pointer; AOptions: Word): Word;

{ MessageBoxRect erlaubt es, einen Anzeigebereich fr die         }
{ MessageBox anzugeben.                                           }

function MessageBoxRect(var R: TRect; Msg: String; Params: Pointer;
  AOptions: Word): Word;

{ MessageBoxTitle erlaubt es, einen Titel fr die MessageBox      }
{ anzugeben.                                                      }

function MessageBoxTitle(Title, Msg: String; Params: Pointer; AOptions: Word): Word;

{ MessageBoxTitleRect ermglicht es, einen Anzeigebereich und     }
{ einen Titel fr die MessageBox anzugeben.                       }

function MessageBoxTitleRect(var R: TRect; Title, Msg: String;
  Params: Pointer; AOptions: Word): Word;

{ InputBox zeigt ein einfaches Dialogfenster, das es ermglicht,  }
{ einen String einzugeben, an.                                    }

function InputBox(Title: String; ALabel: String; var S: String;
  Limit: Byte): Word;

{ InputBoxRect ist wie InputBox, erlaubt es jedoch einen Anzeige- }
{ bereich fr das Dialogfenster anzugeben.                        }

function InputBoxRect(var Bounds: TRect; Title: String; ALabel: String;
  var S: String; Limit: Byte): Word;

{ These input boxes have a THistory object associated with
  its inputline.
}
function HistoryInputBox(Title: String; ALabel: String; var S: String;
  Limit: Byte; AHistoryID: Word): Word;

function HistoryInputBoxRect(var Bounds: TRect; Title: String;
  ALabel: String; var S: String; Limit: Byte; AHistoryID: Word): Word;

{ Message Box Hooks
}

function StdCreateMessageBox(var Bounds: TRect;
  ATitle, AText: string; AOptions: Word): PDialog;

function StdCreateInputBox(var Bounds: TRect;
  ATitle, ALabel: string; ALimit: Byte; AHistoryID: Word): PDialog;

const
  CreateMessageBox: function(var Bounds: TRect;
    ATitle, AText: string; AOptions: Word): PDialog = StdCreateMessageBox;

  CreateInputBox: function(var Bounds: TRect; ATitle, ALabel: string;
    ALimit: Byte; AHistoryID: Word): PDialog = StdCreateInputBox;

implementation

{$ifdef Windows}
uses WinGr, Drivers, GvViews, GvApp, ExtGraph, GvTexts;
{$else}
uses Drivers, GVDriver, GVViews, GVApp, ExtGraph, MyFonts,
     MetaGr, GVTexts;
{$endif}

type

{ TMsgBoxIcon object }

  PMsgBoxIcon = ^TMsgBoxIcon;
  TMsgBoxIcon = object (TGView)
		  Form: Word;
		  constructor Init (var Bounds: TRect; AForm: Word);
		  procedure Draw; virtual;
                end;

constructor TMsgBoxIcon.Init;
Begin
  TGView.Init (Bounds);
  Form:=AForm;
End;

procedure TMsgBoxIcon.Draw;
var P: TPoint;
Begin
  If (GOwner <> nil) and (Form < mfNoIcon)
  then Begin
    SetFillStyle(SolidFill, GetColor(1));
    Bar(0, 0, Size.X - 1, Size.Y - 1);
    LongInt(P) := 0;
    Case Form Of
      mfWarning      : Begin
                         DrawMbIcon (P.X, P.Y, 30, $F);
                         DrawMbIcon (P.X+16, P.Y, 31, $F);
                         DrawMbIcon (P.X, P.Y, 32, $10E);
			 DrawMbIcon (P.X+16, P.Y, 33, $10E);
                       End;
      mfError        : Begin
			 DrawMbIcon (P.X, P.Y, 34, $B);
                         DrawMbIcon (P.X+16, P.Y, 35, $B);
		       End;
      mfInformation  : Begin
			 DrawMbIcon (P.X, P.Y, 24, $F);
                         DrawMbIcon (P.X+16, P.Y, 25, $F);
                         DrawMbIcon (P.X, P.Y, 28, $101);
                         DrawMbIcon (P.X+16, P.Y, 29, $101);
		       End;
      mfConfirmation : Begin
			 DrawMbIcon (P.X, P.Y, 26, $F);
			 DrawMbIcon (P.X+16, P.Y, 27, $F);
			 DrawMbIcon (P.X, P.Y, 28, $102);
			 DrawMbIcon (P.X+16, P.Y, 29, $102);
		       End;
    End;
  End;
End;

{ MessageBox functions 
}

function MessageBox;
Begin
  MessageBox:=MessageBoxTitle (GetStr(122 + AOptions and $3), Msg, Params, AOptions);
End;

function MessageBoxRect;
Begin
  MessageBoxRect:=MessageBoxTitleRect (R, GetStr(122 + AOptions and $3), Msg,
     Params, AOptions);
End;

function MessageBoxTitle;
var R: TRect;
Begin
  R.Assign (0, 0, -1, -1);
  MessageBoxTitle := MessageBoxTitleRect (R, Title, Msg, Params, AOptions);
End;

function MessageBoxTitleRect;
var
  S: String;
  Dialog: PDialog;
Begin
  FormatStr (S, Msg, Params^);
  Dialog := CreateMessageBox(R, Title, S, AOptions);
  MessageBoxTitleRect := DeskTop^.ExecView(Dialog);
  Dispose (Dialog, Done);
End;

function StdCreateMessageBox(var Bounds: TRect;
  ATitle, AText: string; AOptions: Word): PDialog;
const Commands: Array [0..3] of Word =
	(cmYes, cmNo, cmOK, cmCancel);
var I, J, X, LineCount, ButtonCount: Integer;
    Dialog: PDialog;
    Control: PGView;
    ButtonList: Array [0..4] of PGView;
    S, H: String;
    Center: Boolean;

Begin
  Center:=Bounds.B.X = -1;
  Bounds.B.X:=Bounds.A.X+400; Bounds.B.Y:=Bounds.A.Y+146;

  Dialog := New (PDialog, Init (Bounds, ATitle));
  With Dialog^ do Begin
    If Center then Options:=Options or ofCentered;
    StandardFont:=ftSystem;

    Bounds.Assign (23, 56, 55, 88);
    Insert (New (PMsgBoxIcon, Init (Bounds, AOptions and $7)));

    X := 0;
    ButtonCount := 0;
    For I := 0 to 3 do
      If AOptions and ($0100 shl I) <> 0 then Begin
	Bounds.Assign (0, 0, 100, 28);
	Control := New (PButton, Init (Bounds, GetStr(126 + I), Commands[I],
	  bfNormal));
	Inc (X, Control^.Size.X + 18);
	ButtonList [ButtonCount] := Control;
	Inc (ButtonCount);
      End;
    Dec (X, 18);
    If Size.X<X+2*47 then Begin
      Bounds.Assign (Origin.X, Origin.Y, Origin.X+X+2*47, Origin.Y+Size.Y);
      ChangeBounds (Bounds);
      X:= (Size.X - X) shr 1;
    End
    Else X:= (Size.X - X) shr 1;

    SetTextParams (ftSystem, 0, 0, false);
    LineCount := StaticTextHeight(AText, Size.X - (23 + 74));
    If LineCount > 54 then Begin
      Bounds.Assign (Origin.X, Origin.Y,
	Origin.X + Size.X, Origin.Y + Size.Y + LineCount - 54);
      ChangeBounds (Bounds);
    End;

    Bounds.Assign (74, 40, Size.X - 23, Size.Y - 52);
    Control := New (PStaticText, Init (Bounds, AText));
    Insert (Control);

    For I := 0 to ButtonCount - 1 do Begin
      Control := ButtonList [I];
      Insert (Control);
      Control^.MoveTo (X, Size.Y - 40);
      Inc (X, Control^.Size.X + 18);
    End;
    SelectNext (False);
  End;
  StdCreateMessageBox := Dialog;
End;

{ Inputbox functions 
}

function InputBox;
begin
  InputBox := HistoryInputBox(Title, ALabel, S, Limit, 0)
end;

function HistoryInputBox;
var R: TRect;
Begin
  R.Assign (0, 0, 320, 135);
  R.Move ((Desktop^.Size.X - R.B.X) div 2, (Desktop^.Size.Y - R.B.Y) div 2);
  HistoryInputBox := HistoryInputBoxRect (R, Title, ALabel, S, Limit, AHistoryID);
End;

function InputBoxRect;
begin
  InputBoxRect := HistoryInputBoxRect(Bounds, Title, ALabel, S, Limit, 0)
end;

function HistoryInputBoxRect;
var
  Dialog: PDialog;
  C: Word;
Begin
  Dialog := CreateInputBox(Bounds, Title, ALabel, Limit, AHistoryID);
  Dialog^.SetData (S);
  C := DeskTop^.ExecView (Dialog);
  If C <> cmCancel then Dialog^.GetData (S);
  Dispose (Dialog, Done);
  HistoryInputBoxRect := C;
End;

function StdCreateInputBox(var Bounds: TRect;
  ATitle, ALabel: string; ALimit: Byte; AHistoryID: Word): PDialog;
var Dialog: PDialog;
    Control: PInputLine;
    R: TRect;
Begin
  Dialog := New(PDialog, Init(Bounds, ATitle));
  With Dialog^ do Begin
    StandardFont:=ftSystem;
    R.Assign (30, 60, Size.X - 30, 80);
    Control := New (PInputLine, Init (R, ALimit));
    Insert(Control);
    If AHistoryID <> 0
    then begin
      R.Assign(Size.X - 31, 60, Size.X - 13, 80);
      Insert(New(PHistory, Init(R, Control, AHistoryID)));
    end;
    SetTextParams (ftSystem, 0, 0, True);
    R.Assign (30, 40, 35 + TextWidth (ALabel), 60);
    Insert (New (PLabel, Init(R, ALabel, Control)));
    R.Assign ((Size.X-218) div 2, Size.Y - 40,
	      ((Size.X-218) div 2)+100, Size.Y - 12);
    Insert (New (PButton, Init (R, GetStr(128), cmOk, bfDefault)));
    Inc (R.A.X, 118); Inc (R.B.X, 118);
    Insert (New (PButton, Init (R, GetStr(129), cmCancel, bfNormal)));
    SelectNext(False);
  End;
  StdCreateInputBox := Dialog;
End;

end.
