
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{       Copyright (c) 1994 Stefan Milius                }
{                                                       }
{*******************************************************}

{
  GVWLIST.TXT GVWLIST.DOC GINFO.TXT NEW.TXT GV.VER
}

Unit GVWList;

{$A+,B-,D+,F+,G+,O+,R-,S-,X+,I-,V-}

interface

uses Objects, Drivers, Views, GVViews, GVDialog, GVApp;

const

{ TWindowList flags }

  wlNormal        = $0000;
  wlNoShowDesktop = $0001;
  wlHelpButton    = $0002;

type
  PWindowColl = ^TWindowColl;
  TWindowColl = object(TCollection)
    procedure FreeItem(Item: pointer); virtual;
  end;

{ TWindowlist object }

  PWindowList = ^TWindowList;
  TWindowList = object (TListBox)
                  constructor Init (var Bounds: TRect; AScrollBar: PScrollBar);
                  destructor Done; virtual;
                  function GetText(Item: Integer; MaxLen: Integer): String; virtual;
                  procedure HandleEvent (var Event: TEvent); virtual;
                  procedure GetDesktop;
                  procedure Store(var S: TStream);
                end;

{ TWListDialog object }

  PWListDialog = ^TWListDialog;
  TWListDialog = object (TDialog)
                   List: PWindowList;
                   constructor Init (AOptions: Word);
                   constructor Load (var S: TStream);
                   procedure GetDeskTop;
                   procedure Store (var S: TStream);
                 end;

{ TWListDialog execution procedure }

  procedure ExecuteWindowList(AWListDialog: PWListDialog);

{ Stream registration procedure }

  procedure RegisterGVWList;

const

{ Stream registration records }

  RWindowList: TStreamRec = (
     ObjType: 190;
     VmtLink: Ofs(TypeOf(TWindowList)^);
     Load:    @TWindowList.Load;
     Store:   @TWindowList.Store);

  RWListDialog: TStreamRec = (
     ObjType: 191;
     VmtLink: Ofs(TypeOf(TWListDialog)^);
     Load:    @TWListDialog.Load;
     Store:   @TWListDialog.Store);

implementation

Uses GVTexts;

const

{ TWindowlist commands }

  cmSelect = 900; cmDelete = 901;

(*********************** TWListDialog execution procedure *******************)

procedure ExecuteWindowList(AWListDialog: PWListDialog);
Begin
  If Application^.ValidView(AWListDialog) <> nil then Begin
    Application^.ExecView(AWListDialog);
    Dispose(AWListDialog, Done)
  End
End;

(***************************** TWindowColl object ***************************)

procedure TWindowColl.FreeItem(Item: pointer);
begin
end;

(***************************** TWindowList object ***************************)

constructor TWindowList.Init;
Begin
  TListBox.Init (Bounds, AScrollBar);
  Options:=Options or ofPostProcess;
  NewList (nil);
End;

destructor TWindowList.Done;
Begin
  NewList(nil);
  TListBox.Done
End;

procedure TWindowList.GetDesktop;
var NList: PCollection;

 procedure SearchWindows (P: PGView); far;
 Begin
   If P^.GetState(sfVisible) and
      (Message(P, evBroadcast, 40 {cmHeyYou}, nil) = P)
   then NList^.Insert(P)
 End;

Begin
  NList:=New (PWindowColl, Init (8,8));
  Desktop^.ForEach (@SearchWindows);
  NewList (NList);
End;

function TWindowList.GetText;
begin
  GetText := PWindow(List^.At(Item))^.GetTitle(MaxLen)
end;

procedure TWindowList.HandleEvent;

 function GetSel: PGView;
 Begin
   If Focused < List^.Count
   then GetSel := List^.At(Focused)
   else GetSel := nil
 End;

 procedure SelectSel;
 var P: PGView;
 Begin
   P := GetSel;
   If P<>nil then P^.Select;
 End;

 procedure CloseSel;
 var P: PGView;
 Begin
   P:=GetSel;
   If P <> nil then Begin
     PWindow(P)^.Close;
     GetDesktop;
   End;
 End;

Begin
  If GetState (sfSelected) then TListBox.HandleEvent (Event);
  If (Event.What=evKeyDown) and (Event.KeyCode=kbDel) then Begin
    CloseSel;
    ClearEvent (Event);
  End;
  If Event.What=evBroadCast then Begin
    Case Event.Command Of
      cmSelect: Begin
                  SelectSel;
                  GOwner^.EndModal (cmOK);
                End;
      cmDelete: CloseSel;
     else Exit;
    End;
    ClearEvent (Event);
  End;
  If (Event.What=evCommand) and (Event.Command=cmListItemSelected) and
     (Event.InfoPtr=@Self) then Begin
    Message (@Self, evBroadCast, cmSelect, nil);
    ClearEvent (Event);
  End;
End;

procedure TWindowList.Store(var S: TStream);
var
  Save: PCollection;
begin
  Save := List;
  List := nil;
  inherited Store(S);
  List := Save
end;

(***************************** TWListDialog object **************************)

constructor TWListDialog.Init;
var R: TRect;
    Control: PGView;
Begin

  R.Assign (0,0,430,220);
  TDialog.Init (R, GetStr(132));

  Options:=Options or ofCentered;

  R.Assign (Size.X-125,35,Size.X-25,60);
  Insert (New (PButton, Init (R, '~O~K', cmSelect, bfDefault+bfBroadCast)));
  R.Move (0,35);
  Insert (New (PButton, Init (R, GetStr(133), cmDelete, bfNormal+bfBroadCast)));
  R.Move (0,35);
  Insert (New (PButton, Init (R, GetStr(134), cmCancel,bfNormal)));
  R.Move (0,35);
  If AOptions and wlHelpButton <>0 then Begin
    Control:=New (PButton, Init (R, GetStr(135),cmHelp,bfNormal));
    Insert (Control);
  End;

  R.Assign (262,60,280,198);
  Control:=New (PScrollBar, Init(R));
  R.Assign(15,60,263,198);
  List:=New (PWindowList, Init (R, PScrollBar(Control)));
  Insert (Control);
  R.Assign (15,35,80,55);
  Control:=New (PLabel, Init (R, GetStr(136), List));
  Insert (List);
  Insert (Control);
  If AOptions and wlNoShowDesktop = 0 then GetDesktop;
End;

constructor TWListDialog.Load;
Begin
  TDialog.Load (S);
  GetSubViewPtr (S,List);
  GetDesktop;
End;

procedure TWListDialog.GetDesktop;
Begin
  List^.GetDesktop;
  List^.FocusItem(1);
End;

procedure TWListDialog.Store;
Begin
  TDialog.Store (S);
  PutSubViewPtr (S, PGView (List));
End;

(*********************** Stream registration procedure **********************)

procedure RegisterGVWList;
Begin
  RegisterType(RWindowList);
  RegisterType(RWListDialog);
End;

End.
