// -*- C++ -*- header file
#include "data-input.h"
#include <queue>
#include <algorithm>

typedef Matrix<unsigned short int> TMatrix;

const int MAXZIMMER = 500; // 101;
const int MAX_INT = 100000000;
extern int Scale;
extern int AnzZimmer;

template <class T>
inline const T& MIN(const T& a, const T& b) {
  return b < a ? b : a;
}

template <class T>
inline const T& MAX(const T& a, const T& b) {
  return  a < b ? b : a;
}

template <class T>
class IndexMatrix {
public:
  IndexMatrix(short Anz, Matrix<T> *m) :
    Size(Anz), matrix(m)
  {
    int i;
    for (i = 0; i<=Anz; i++) 
      si[i] = zi[i] = saddr[i] = zaddr[i] = i;
  }
  IndexMatrix(const IndexMatrix &M) :
    zi(M.zi),
    si(M.si),
    Size(M.Size),
    matrix(new Matrix<T>(M.Size+1, M.Size+1))
    {
      int i, j;
      for (i=0; i<=Size; i++) zaddr[i] = saddr[i] = i;
      for (i=0; i<=Size; i++) 
	for (j=0; j<=Size; j++)
	  (*this)(i, j) = M(i, j);
    }
  IndexMatrix &operator= (const IndexMatrix &M) { 
    zi = M.zi;
    si = M.si;
    Size = M.Size;
    delete matrix;
    matrix = new Matrix<T>(M.Size+1, M.Size+1);
    int i, j;
    for (i=0; i<=Size; i++) zaddr[i] = saddr[i] = i;
    for (i=0; i<=Size; i++)
      for (j=0; j<=Size; j++)
	(*this)(i, j) = M(i, j);
    return *this;
  }
  // Zis is a hack.
  IndexMatrix(const IndexMatrix<short unsigned int> &M, int) :
    zi(M.zi),
    si(M.si),
    Size(M.Size),
    matrix(new Matrix<T>(M.Size+1, M.Size+1))
    {
      int i, j;
      for (i=0; i<=Size; i++) zaddr[i] = saddr[i] = i;
      for (i=0; i<=Size; i++) 
	for (j=0; j<=Size; j++)
	  (*this)(i, j) = M(i, j);
    }
  IndexMatrix(const IndexMatrix<int> &M, int) :
    zi(M.zi),
    si(M.si),
    Size(M.Size),
    matrix(new Matrix<T>(M.Size+1, M.Size+1))
    {
      int i, j;
      for (i=0; i<=Size; i++) zaddr[i] = saddr[i] = i;
      for (i=0; i<=Size; i++) 
	for (j=0; j<=Size; j++)
	  (*this)(i, j) = M(i, j);
    }
  ~IndexMatrix() {delete matrix;}
  char zi[MAXZIMMER], si[MAXZIMMER];   // Namen 
  char zaddr[MAXZIMMER], saddr[MAXZIMMER]; // Adressen in Matrix
  short Size;
  Matrix<T> *matrix;
public:
  T &operator()(int i, int j)
  {return (*matrix)[zaddr[i]][saddr[j]];}
  const T &operator()(int i, int j) const
  {return (*matrix)[zaddr[i]][saddr[j]];} 
  void DeleteRowCol(int i, int j) // given are names  
  {
    int k = 0;
    while ((zi[k] != i) && (k < Size)) k++;
    for (; k<=Size-1; k++) zi[k] = zi[k+1], zaddr[k] = zaddr[k+1];
    int l = 0;
    while ((si[l] != j) && (l < Size)) l++;
    for (; l<=Size-1; l++) si[l] = si[l+1], saddr[l] = saddr[l+1];
    Size--;
  }    
};

typedef IndexMatrix<unsigned short int> TIndexMatrix;

#if defined(BREADTHFIRST)
extern char *NodeBlock;
extern char *NodePtr;
#endif
extern int NewNodeCount, DeleteNodeCount;

class TNode {
public:
#if defined(BREADTHFIRST)
  void *operator new(size_t size) {
    void *result = NodePtr;
    NodePtr += size;
    return result;
  }
  void operator delete(void *p){}
#else
  void *operator new(size_t size) {
    NewNodeCount++;
    return ::operator new(size);
  }
  void operator delete(void *p)
  {
    DeleteNodeCount++;
    ::operator delete(p);
  }
#endif
  TNode(int bound, TIndexMatrix *matrix, short rightend, short I,
	short J, TNode *up) :
    Bound(bound), Matrix(matrix), RightEnd(rightend), i(I), j(J),
    LeftValid(1), RightValid(1), Up(up), Left(0), Right(0) 
  {
  }
  ~TNode() {
    if (Left) delete Left;
    if (Right) delete Right;
    if (Matrix) delete Matrix;
  }
  int Bound;
  TIndexMatrix *Matrix;
  short RightEnd;
  short i, j;
  char LeftValid, RightValid;
  TNode *Up, *Left, *Right;
};

class TNodePtr {
  TNode *node;
  int Bound;
  int Size;
public:
  TNodePtr() : node(0), Bound(0), Size(0) {}
  TNodePtr(int bound) : node(0), Bound(bound), Size(0) {}
  TNodePtr(TNode *Node) : node(Node), Bound(Node->Bound),
    Size(Node->Matrix->Size) {}
  friend operator<(const TNodePtr &A, const TNodePtr &B)
  {
    if (A.Size > B.Size) return 1;
    if (A.Size < B.Size) return 0;
    return A.Bound > B.Bound;
  } 
  friend operator&&(const TNodePtr &A, const TNodePtr &B)
  {
    return A.Bound > B.Bound;
  }    
  operator TNode *() {return node;}
};

//typedef priority_queue<vector<TNodePtr>, less<TNodePtr> > TNodePQ;

#if defined(BREADTHFIRST)

// Breadth-first search
class TNodePQ :
  public priority_queue<vector<TNodePtr>, logical_and<TNodePtr> > { 
public:
    TNodePQ() {}
    int LowerBoundThan(int Bound) {
      return 0;
    }
};

#else 

// Depth-first search
class TNodePQ :
  public priority_queue<vector<TNodePtr>, less<TNodePtr> > { 
public:
    TNodePQ() {}
    int LowerBoundThan(int Bound) {
      return find_if(c.begin(), c.end(),
		     bind1st(logical_and<TNodePtr>(), Bound)) != 0;
    }
};

#endif


TMatrix *MakeMatrix();

