// Euclidean-TSP support
// Written by Matthias K"oppe <mkoeppe@csmd.cs.uni-magdeburg.de>

// This can read data files in the format of
// TSPLIB's NODE_COORD_SECTION, that is, name of the city, followed by
// integer x co-ordinate, followed by integer y-coordinate.

#include "data-input.h"

vector<City> cities;

void ReadCities(istream &S)
{
  do { 
    int x, y;
    string name;
    S >> name >> x >> y;
    if (S) {
      cities.push_back(City(x, y, name));
      //      cout << "City " << name << " at " << x << "|" << y << '\n';
    }
  } while (S);
}

double DoubleDist(const City &a, const City &b)
{
  return sqrt((a.x - b.x)*(a.x - b.x)
	      + (a.y - b.y)*(a.y - b.y));
}

// double DistEpsilon()
// {
//   /* Bildet alle Teilsummen von Distanzen und ermittelt den
//      kleinsten Abstand */
//   /* Grober Unfug (Aufwand 2^{n^2}) */
//   vector<double> distances;
//   vector<City>::iterator i, k;
//   distances.push_back(0.0);
//   for (i = cities.begin(); i != cities.end(); ++i) {
//     for (k = cities.begin(); k != cities.end(); ++k) {
//       int j;
//       double d = DoubleDist(*i, *k);
//       if (d != 0.0) {
// 	for (j = distances.size() - 1; j>=0; j++) 
// 	  distances.push_back(distances[j] + d);
//       }
//     }
//   }
//   vector<double>::iterator m, n;
//   double mindelta = 1.0E5;
//   const double epsilon = 1.0E-7;  /* numerical eps */
//   for (m = distances.begin(); m != distances.end(); ++m) {
//     for (n = distances.begin(); n != distances.end(); ++n) {
//       double delta = fabs(*m - *n);
//       if (delta > epsilon) {
// 	mindelta = min(mindelta, delta);
//       }
//     }
//   }
//   return mindelta;
// }

Matrix<int> *distances;

Matrix<int> *CalcDistances(const vector<City> &cities, double Scale)
{
  vector<City>::const_iterator i, k;
  Matrix<int> *matrix = new Matrix<int>(cities.size(), cities.size());
  int x, y;
  for (x = 0, i = cities.begin(); i != cities.end(); ++i, x++) {
    for (y = 0, k = cities.begin(); k != cities.end(); ++k, y++) {
      int j;
      double d = DoubleDist(*i, *k);
      (*matrix)[x][y] = (int) rint(d * Scale);
    }
  }
  return matrix;
}

int length(const Tour &tour, const Matrix<int> *distances = ::distances)
{
  int len = (*distances)[tour[0]][tour[tour.size() - 1]];
  int i;
  for (i = 0; i < tour.size() - 1; i++) 
    len += (*distances)[tour[i]][tour[i+1]];
  return len;
}

// double dlength(const Tour &tour)
// {
//   int len = (*distances)[tour[0]][tour[tour.size() - 1]];
//   double dlen = DoubleDist(cities[tour[0]], cities[tour[tour.size() - 1]]);
//   //  cout << len << ' ' << dlen << '\n';
//   int i;
//   for (i = 0; i < tour.size() - 1; i++) {
//     len += (*distances)[tour[i]][tour[i+1]];
//     dlen += DoubleDist(cities[tour[i]], cities[tour[i+1]]);
//     //cout << len << ' ' << dlen << '\n';
//   }
//   return dlen;
// }


 
   
