// -*- C++ -*- header file
#if !defined(_DATA_INPUT_H)
#define _DATA_INPUT_H
#include <string>
#include <iostream.h>
#include <fstream.h>
#include <vector.h>
#include <iterator>
#include <math.h>

class City {
public:
  int x, y;
  string name;
  City() {}
  City(int ax, int ay, string aname) :
    x(ax), y(ay), name(aname) {}
};

template <class T>
class Matrix {
  T *data;
  int XSize, YSize;
  Matrix &operator=(const Matrix &);
public:
  Matrix(int xsize, int ysize) :
    XSize(xsize), YSize(ysize), data(new T[xsize * ysize])
  {
    //    cout << "data at " << (void *) data << '\n';
  }
  Matrix(const Matrix &M) :
    XSize(M.XSize),
    YSize(M.YSize),
    data(new T[M.XSize*M.YSize])
  {
    memcpy(data, M.data, XSize * YSize * sizeof(T));
    //cout << "data at " << (void *) data << '\n';
  }
  ~Matrix() {delete[] data;}
  T *operator[](int y) {return data + y*XSize;}
  const T *operator[](int y) const {return data + y*XSize;}
};

extern Matrix<int> *distances;
extern vector<City> cities;

class Tour {
  int *p;
  int s;
public:
  Tour(int siz) :
    p(new int[siz]),
    s(siz)
  {
    int i;
    for (i = 0; i<siz; i++)
      p[i] = i;
  }
  Tour (const Tour &tour) :
    s(tour.s),
    p(new int[tour.s])
  {
    int i;
    for (i = 0; i < s; i++) 
      p[i] = tour.p[i];
  }
  ~Tour() {
    delete[] p;
  }
  Tour &operator= (const Tour &tour) {
    delete[] p;
    s = tour.s;
    p = new int[tour.s];
    int i;
    for (i = 0; i < s; i++) 
      p[i] = tour.p[i];
    return *this;
  }
    
  friend ostream &operator <<(ostream &st, const Tour &tour) {
    int i;
    for (i = 0; i < tour.s; i++) {
      st << cities[tour.p[i]].name << " ";
    }
    return st;
  }    
  const int &operator[] (int i) const {return p[i];}
  int &operator[] (int i) {return p[i];}
  int size() const {return s;}
};

void ReadCities(istream &S);
double DoubleDist(const City &a, const City &b);
Matrix<int> *CalcDistances(const vector<City> &cities, double Scale);
int length(const Tour &tour, const Matrix<int> *distances = ::distances);


#endif
