#ifndef DEBUG_H_

#define _PRINTVAR(var)        cerr <<  #var << " = " << var
#define _PRINT(var)           cerr <<  var

#if __LINE__
#   define _PRINTPLACE(name)  cerr <<  __FILE__ << '(' << __LINE__ << "): " << name
#   define _ASSERT(var)       cerr <<  __FILE__ << '(' << __LINE__ << "): " #var " = \"" << var << "\"" << endl;
#else
#   define _PRINTPLACE(name)  cerr <<  name
#   define _ASSERT(var)      _PRINTVAR(var) << endl
#endif

#define _D(x)       x
#define INDENT(a)   cerr << setw(a) << ' '

#if defined(DEBUG)
#   define D(x)         x
#define PRINTVAR(var)        cerr <<  #var << " = " << var
#define PRINT(var)           cerr <<  var
#   if __LINE__
#       define PRINTPLACE(name)  cerr <<  __FILE__ << '(' << __LINE__ << "): " << name
#       define ASSERT(var)       cerr <<  __FILE__ << '(' << __LINE__ << "): " #var " = \"" << var << "\"" << endl;
#   else
#       define PRINTPLACE(name)  cerr <<  name
#       define ASSERT(var)      _PRINTVAR(var) << endl
#   endif
#else
#   define D(x)
#   define PRINT(var)
#   define PRINTPLACE(name)
#   define PRINTVAR(a)
#   define ASSERT(a)
#endif

#else
#include <stdio.h>

#define _PRINTVAR(var, type)        fprintf(stderr, " " #var " = %" #type , var)
#define _PRINT(var, type)           fprintf(stderr, "   %" #type , var)

#if __LINE__
#   define _PRINTPLACE(name)        fprintf(stderr, "%s(%d): %s", __FILE__, __LINE__, name)
#   define _ASSERT(var, type)       fprintf(stderr, "%s(%d): " #var " = \"%" #type "\"\n", __FILE__, __LINE__, var)
#else
#   define _PRINTPLACE(name)        fprintf(stderr, "%s", #name)
#   define _ASSERT(var, type)      _PRINTVAR(var, type ## \n)
#endif
#define _D(x)       x
#define INDENT(a)   fprintf(stderr, "%*c", a, ' ');

#define _MAKE_DEBUGFILE(dir)         if (!debugfile) debugfile = fopen(tempnam(dir, "WNK_"), "w")
#define _DPRINTVAR(var, type)        debugfile && fprintf(debugfile, " " #var " = %" #type , var)
#define _DPRINT(var, type)           debugfile && fprintf(debugfile, "   %" #type , var)

#if __LINE__
#   define _DPRINTPLACE(name)        debugfile && fprintf(debugfile, "%s(%d): %s", __FILE__, __LINE__, name)
#   define _DASSERT(var, type)       debugfile && fprintf(debugfile, "%s(%d): " #var " = \"%" #type "\"\n", __FILE__, __LINE__, var)
#else
#   define _DPRINTPLACE(name)        debugfile && fprintf(debugfile, "%s", #name)
#   define _DASSERT(var, type)      _DPRINTVAR(var, type ## \n)
#endif

#if defined(DEBUG)
#   define D(x)         x
#   define PRINTVAR(var, type)      _PRINTVAR(var, type)
#   define PRINT(var, type)         _PRINT(var, type)
#   define PRINTPLACE(name)         _PRINTPLACE(name)
#   define ASSERT(var, type)        _ASSERT(var, type)
#   define MAKE_DEBUGFILE(dir)      _MAKE_DEBUGFILE(dir)
#   define DPRINTVAR(var, type)     _DPRINTVAR(var, type)
#   define DPRINT(var, type)        _DPRINT(var, type)
#   define DPRINTPLACE(name)        _DPRINTPLACE(name)
#   define DASSERT(var, type)       _DASSERT(var, type)
#else
#   define D(x)
#   define PRINT(var, type)
#   define PRINTPLACE(name)
#   define PRINTVAR(a, b)
#   define ASSERT(a, b)
#   define MAKE_DEBUGFILE(dir)      
#   define DPRINTVAR(var, type)     
#   define DPRINT(var, type)        
#   define DPRINTPLACE(name)        
#   define DASSERT(var, type)
#endif

#endif

