/*-------------------------------------SAMSET.H------------------------------------------
|public:                                                                                |
|                                                                                       |
| set () : HEAD(NULL), TAIL(NULL) {}                                                    |
|                                                                                       |
| friend ostream & operator << (ostream & a_stream, const set<T> & a_set);              |
|                                                                                       |
| bool operator == (const set<T> &) const;                                              |
|                                                                                       |
| const set<T> &operator = (const set<T> &);                                            |
|                                                                                       |
| void add_element (const T&);                                                          |
|                                                                                       |
| set<T> without_element (T) const;                                                     |
|                                                                                       |
| void remove_element (T);                                                              |
|                                                                                       |
| void setHEAD (elt<T> * new_head);                                                     |
|                                                                                       |
| void setTAIL (elt<T> * new_tail);                                                     |
|                                                                                       |
| elt<T> * getHEAD () const;                                                            |
|                                                                                       |
| elt<T> * getTAIL () const;                                                            |
|                                                                                       |
| elt<T> * in_set (T) const;                                                            |
|                                                                                       |
| bool is_contained (const set<T> &query) const;                                        |
|                                                                                       |
| void complement (set<T> &another_set);                                                |
|                                                                                       |
|private:                                                                               |
|                                                                                       |
| elt<T> * HEAD;                                                                        |
| elt<T> * TAIL;                                                                        |
|                                                                                       |
---------------------------------------------------------------------------------------*/


# include <iostream.h>
# include <stdlib.h>
# include "math.h"


/*************************************************************************************
* THIS FILE CONTAINS:
* declarations and template information for the "set" data type
*************************************************************************************/


#ifndef SAMSET_H
#define SAMSET_H


//THE SET IS REPRESENTED AS A DOUBLY LINKED LIST, SO EACH ELEMENT HAS A PREVIOUS, A NEXT
//AND A VALUE.
template<class T>
struct elt {
  T value;
  elt<T> * prev;
  elt<T> * next;
};


template< class T >
class set {

public:



//CONSTRUCTORS


/*******************************************************************
* purpose: default constructor for a set
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  set () : HEAD(NULL), TAIL(NULL) {}



//OPERATORS


/*******************************************************************
* purpose: a layer of abstraction by which sets may be output
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  friend ostream & operator << (ostream & a_stream, const set<T> & a_set);


/*******************************************************************
* purpose: checks the equality of two sets
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  bool operator == (const set<T> &) const;


/*******************************************************************
* purpose: assignment from one set to another
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  const set<T> &operator = (const set<T> &);



//DATA ACQUISITION


/*******************************************************************
* purpose: returns the head of the set (the first element)
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  elt<T> * getHEAD () const;


/*******************************************************************
* purpose: returns the tail of the set (the last element)
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  elt<T> * getTAIL () const;


/*******************************************************************
* purpose: determines whether or not the given value is in the set.
*          If so, the element of the set with that value is returned.
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  elt<T> * in_set (T) const;


/*******************************************************************
* purpose: determines whether or not the given set is a subset of the set
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  bool is_contained (const set<T> &query) const;
  

/*******************************************************************
* purpose: returns a set exactly like this set, but without the input element
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  set<T> without_element (T) const;



//MODIFIERS


/*******************************************************************
* purpose: adds the given element to the set
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  void add_element (const T&);


/*******************************************************************
* purpose: removes the given element from the set
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  void remove_element (T);


/*******************************************************************
* purpose: sets the head of the set to be the input element
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  void setHEAD (elt<T> * new_head);


/*******************************************************************
* purpose: sets the tail of the set to be the input element
* date: 05.25.98
* notes/explanation: 
********************************************************************/

  void setTAIL (elt<T> * new_tail);


/*******************************************************************
* purpose: subtracts the input set from the set
* date: 05.25.98
* notes/explanation: 
********************************************************************/
  
  void complement (set<T>& another_set);

//MEMBER DATA


 private:

  elt<T> * HEAD;        //FIRST ELEMENT IN THE SET
  elt<T> * TAIL;        //LAST ELEMENT IN THE SET

};


#endif



//OPERATORS


/*******************************************************************
* purpose: a layer of abstraction by which sets may be output
* date: 05.25.98
* notes/explanation: 
********************************************************************/

template<class T>
ostream & operator << (ostream & a_stream, const set<T> & a_set) {

  elt<T> * ptr = a_set.HEAD;
  a_stream << "{ ";

  while (ptr) {

    a_stream << ptr->value << " ";
    ptr = ptr->next;
  }

  a_stream << "}";
  return a_stream;
}


/*******************************************************************
* purpose: assignment from one set to another
* date: 05.25.98
* notes/explanation: 
********************************************************************/

template< class T >
const set<T> & set<T> :: operator = (const set<T> &another_set) {

  HEAD = TAIL = NULL;
  elt<T> * ptr = another_set.getHEAD();

  while (ptr) {

    add_element(ptr->value);
    ptr = ptr->next;
  }

  return another_set;
}


/*******************************************************************
* purpose: checks the equality of two sets
* date: 05.25.98
* notes/explanation: 
********************************************************************/

template< class T >
bool set<T> :: operator == (const set<T> &query) const {

  return ((is_contained(query)) && (query.is_contained(*this)));

}



//DATA ACQUISITION


/*******************************************************************
* purpose: returns the head of the set (the first element)
* date: 05.25.98
* notes/explanation: 
********************************************************************/
  
template<class T>
elt<T> * set<T> :: getHEAD () const {

  return HEAD;

}


/*******************************************************************
* purpose: returns the tail of the set (the last element)
* date: 05.25.98
* notes/explanation: 
********************************************************************/

template<class T>
elt<T> * set<T> :: getTAIL () const {

  return TAIL;

}


/*******************************************************************
* purpose: determines whether or not the given value is in the set.
*          If so, the element of the set with that value is returned.
* date: 05.25.98
* notes/explanation: 
********************************************************************/

template<class T>
elt<T> * set<T> :: in_set (T element) const {

  elt<T> * ptr = HEAD;

  while (ptr) {

    if (ptr->value == element) {
      return ptr;                //IF THE VALUE IS IN THE SET RETURN ITS ELEMENT
    }

    ptr = ptr->next;
  }

  return NULL;          //IF THE VALUE IS NOT IN THE SET, RETURN NULL

}


/*******************************************************************
* purpose: determines whether or not the given set is a subset of the set
* date: 05.25.98
* notes/explanation: 
********************************************************************/

template<class T>
bool set<T> :: is_contained (const set<T> &query) const {

  elt<T> * query_ptr = query.getHEAD();

  while (query_ptr) {

    if (!(in_set(query_ptr->value))) {  //IF JUST ONE ELEMENT OF THE INPUT SET IS NOT
      return false;                     //CONTAINED, RETURN FALSE
    }

    query_ptr = query_ptr->next;
  }

  return true;
}


/*******************************************************************
* purpose: returns a set exactly like this set, but without the input element
* date: 05.25.98
* notes/explanation: 
********************************************************************/

template<class T>
set<T> set<T> :: without_element (T bad_element) const {

  elt<T> * ptr = HEAD;
  set<T> new_set;

  while (ptr) {

    if (!(ptr->value == bad_element)) {   //ADD ALL ELEMENTS OF THE SET TO THE NEW
      new_set.add_element(ptr->value);    //SET EXCEPT FOR THE BAD_ELEMENT
    }

    ptr = ptr->next;
  }

  return new_set;
}



//MODIFIERS


/*******************************************************************
* purpose: adds the given element to the set
* date: 05.25.98
* notes/explanation: 
********************************************************************/

template<class T>
void set<T> :: add_element (const T &element) {

  if (in_set(element)) {        //IF THE ELEMENT IS ALREADY IN THE SET, DO NOTHING
    return;
  }

  elt<T> * new_elt = new elt<T>;
  new_elt->value = element;
  new_elt->next = HEAD;
  new_elt->prev = NULL;

  if (HEAD) {                   //IF THE SET HAS ANY ELEMENTS, SET THE PREV ELEMENT
    HEAD->prev = new_elt;       //OF HEAD TO BE THE NEW ELEMENT.
  }

  HEAD = new_elt;               //ADD THE ELEMENT TO THE BEGINNING OF THE SET

  if (!TAIL) {                  //IF THE SET IS EMPTY, SET THE TAIL TO THE NEW ELEMENT
    TAIL = new_elt;             //AS WELL
  }

  return;
}


/*******************************************************************
* purpose: removes the given element from the set
* date: 05.25.98
* notes/explanation: 
********************************************************************/

template<class T>
void set<T> :: remove_element (T bad_element) {

  elt<T> * bad_elt_ptr = in_set(bad_element);  //GET TO THE ELEMENT WHOSE VALUE IS BAD

  if (bad_elt_ptr) {

    if (HEAD == bad_elt_ptr) {          //IF THE BAD ELEMENT IS THE HEAD
      HEAD = bad_elt_ptr->next;         //SET THE HEAD TO THE NEXT ELEMENT IN THE SET
    }
    
    else {
      bad_elt_ptr->prev->next = bad_elt_ptr->next;  //O.W. SET THE NEXT POINTER OF THE
    }                                               //PREVIOUS ELEMENT TO THE NEXT 
                                                    //ELEMENT IN THE SET

    if (TAIL == bad_elt_ptr) {          //IF THE BAD ELEMENT IS THE TAIL
      TAIL = bad_elt_ptr->prev;         //SET THE TAIL TO THE PREVIOUS ELEMENT IN THE SET
    }     

    else {
      bad_elt_ptr->next->prev = bad_elt_ptr->prev;  //O.W. SET THE PREVIOUS POINTER OF 
    }                                               //THE NEXT ELEMENT TO THE PREVIOUS
  }                                                 //ELEMENT
}


/*******************************************************************
* purpose: sets the head of the set to be the input element
* date: 05.25.98
* notes/explanation: 
********************************************************************/

template<class T>
void set<T> :: setHEAD (elt<T> * new_head) {

  HEAD = new_head;

}


/*******************************************************************
* purpose: sets the tail of the set to be the input element
* date: 05.25.98
* notes/explanation: 
********************************************************************/

template<class T>
void set<T> :: setTAIL (elt<T> * new_tail) {

  TAIL = new_tail;

}


/*******************************************************************
* purpose: subtracts the input set from the set
* date: 05.25.98
* notes/explanation: 
********************************************************************/

template<class T>
void set<T> :: complement (set<T> &another_set) {

  elt<T> * query_ptr = another_set.getHEAD();
  elt<T> * bad_elt;

  while (query_ptr) {

    remove_element(query_ptr->value);
    query_ptr = query_ptr->next;
  }

  return;
}
