c     
c     
c     =========================================================
      subroutine out2iso(maxmx,maxmy,meqn,mbc,mx,my,x,y,q,t,iunit)
c     =========================================================
c
c     Derived from out2eu from CLAWPACK.
c     
c     # Output the results for the isothermal gas dynamics equations in primitive variables
c     # (density, x-velocity, y-velocity, 0).
c     
      implicit double precision (a-h,o-z)
      dimension q(1-mbc:maxmx+mbc, 1-mbc:maxmy+mbc, meqn)
      dimension x(1-mbc:maxmx+mbc),y(1-mbc:maxmy+mbc)
      character*8 fname
c     
c     
c     # write the results to the file fort.iunit
c     # first create the file name and open file
c     
      fname = 'fort.xxx'
      nstp = iunit
      do 55 ipos = 8, 6, -1
         idigit = mod(nstp,10)
         fname(ipos:ipos) = char(ichar('0') + idigit)
         nstp = nstp / 10
 55   continue
      open(unit=iunit,file=fname,status='unknown',
     .     form='formatted')

c     
      write(iunit,1001) t,mx,my,meqn
 1001 format(e16.8, 3i5, /)
      do 20 j=1,my
         do 10 i=1,mx
            do 5 m=1,meqn
c     # suppress tiny values that cause problems in plotting:
               if (dabs(q(i,j,m)) .lt. 1d-90) q(i,j,m) = 0.d0
 5          continue
            rho = q(i,j,1)
            u = q(i,j,2)
            v = q(i,j,3)
            write(iunit,1002) rho,u,v
 1002       format(4e16.8)
c     
c     # alternative version that also prints x and y:
c     write(iunit,109) x(i),y(j),rho,u,v,pr
c     
 109        format(2f9.4,4e14.6)
 10      continue
         write(iunit,*) ' '
 20   continue
      write(iunit,*) ' '
c     
      close(iunit)
      return
      end
