
c
c
c
c     =====================================================
       subroutine ic2rp(maxmx,maxmy,meqn,mbc,mx,my,x,y,dx,dy,q)
c     =====================================================
c
c     # Set initial conditions for q.
c
c      # Data is piecewise constant with 4 values in 4 quadrants
c      # 2D Riemann problem from Figure 4 of
c        @article{csr-col-glaz,
c          author="C. W. Schulz-Rinne and J. P. Collins and H. M. Glaz",
c          title="Numerical Solution of the {R}iemann Problem for 
c                 Two-Dimensional Gas Dynamics",
c          journal="SIAM J. Sci. Comput.",
c          volume="14",
c          year="1993",
c          pages="1394-1414" }
c
c     Modified for isothermal gas dynamics.
c
       implicit double precision (a-h,o-z)
       dimension q(1-mbc:maxmx+mbc, 1-mbc:maxmy+mbc, meqn)
       dimension x(1-mbc:maxmx+mbc),y(1-mbc:maxmy+mbc)
       dimension rpr(4),rpu(4),rpv(4)
       common /param/  gamma,gamma1
c
c
c      # First quadrant:
c$$$       rpp(1) = 1.5d0
       rpr(1) = 1.5d0
       rpu(1) = 0.d0
       rpv(1) = 0.d0
c
c      # Second quadrant:
c$$$       rpp(2) = 0.3d0
       rpr(2) = 0.532258064516129d0
       rpu(2) = 0.0d0   !# 1.206045378311055d0
       rpv(2) = 0.0d0
c
c      # Third quadrant:
c$$$       rpp(3) = 0.029032258064516d0
       rpr(3) = 0.137992831541219d0
       rpu(3) = 0.0d0  !# 1.206045378311055d0
       rpv(3) = 0.0d0  !# 1.206045378311055d0
c
c      # Fourth quadrant:
c$$$       rpp(4) = 0.3d0
       rpr(4) = 0.532258064516129d0
       rpu(4) = 0.0d0
       rpv(4) = 0.0d0 !# 1.206045378311055d0
c
c      # location of four corners:
       xs = .3d0
       ys = .3d0
c
       do 15 i=1,mx
	  do 15 j=1,my
	     if (x(i).ge.xs .and. y(j).ge.ys) iq = 1
	     if (x(i).lt.xs .and. y(j).ge.ys) iq = 2
	     if (x(i).lt.xs .and. y(j).lt.ys) iq = 3
	     if (x(i).ge.xs .and. y(j).lt.ys) iq = 4
 	     q(i,j,1) = rpr(iq)
 	     q(i,j,2) = rpr(iq)*rpu(iq)
 	     q(i,j,3) = rpr(iq)*rpv(iq)
c$$$ 	     q(i,j,4) = rpp(iq)/gamma1 + 0.5d0*rpr(iq)*(rpu(iq)**2 + 
c$$$     &					rpv(iq)**2)
   15        continue
       return
       end
