
c     
c     
c     
c     =====================================================
      subroutine ic2rp(maxmx,maxmy,meqn,mbc,mx,my,x,y,dx,dy,q)
c     =====================================================
c     
c     # Set initial conditions for q.
c     # Riemann problem across a circular interface centered at (x0,y0)
c     # with radius r0.  The state inside is specified by qin and
c     # outside by qout.  The cellave routine is used to determine what
c     # fraction of the cell is in each state and set the value of q
c     # to be the appropriate average of qin and qout.
c     # 
c     
      implicit double precision (a-h,o-z)
      dimension q(1-mbc:maxmx+mbc, 1-mbc:maxmy+mbc, meqn)
      dimension x(1-mbc:maxmx+mbc),y(1-mbc:maxmy+mbc)
      dimension qin(4),qout(4)
      common/cdisc/ x0,y0,alf,beta,r0,idisc
c     
c     
c     # set idisc for cellave routines (see function fdisc) 
      idisc = 2
c     
      write(6,*) 'input x0, y0, and r0 for radial Riemann problem'
      read(5,*) x0,y0,r0
      write(6,*) 'input of rho inside'
      read(5,*) rhoin
      write(6,*) 'input of rho outside'
      read(5,*) rhoout
c     
      qin(1) = rhoin
      qin(2) = 0.d0
      qin(3) = 0.d0
c
      qout(1) = rhoout
      qout(2) = 0.d0
      qout(3) = 0.d0
c     
c     
      do 21 i=1,mx
         do 20 j=1,my
c     # set (xlow,ylow) to lower left corner of grid cell:
            xlow = x(i) - 0.5d0*dx
            ylow = y(j) - 0.5d0*dy
            call cellave(xlow,ylow,dx,dy,win)
c     # win is now the fraction of the cell that lies inside the circle
            do 10 m=1,meqn
               q(i,j,m) = win*qin(m) + (1.d0-win)*qout(m)
 10         continue
 20      continue
 21   continue
      return
      end
