// This is a -*- C++ -*- header file.

// Input pipe with a single block of data.

#if !defined(_STPIPE_H)
#define _STPIPE_H

#include <iostream.h>
#include "pipebase.h"
#include <string>

class TBlockReadPipe : public TPipeBase<char> {
  char *Block;
  char *Cur;
public:
  TBlockReadPipe(char *block) : Block(block), Cur(block) {}
  ~TBlockReadPipe() { if (Block) delete[] Block; }
  virtual char *Get() { 
    if (Cur) {
      char *b = Cur;
      char *r = Cur;
      while (*b && *b!='\n') b++;
      if (!*b) Cur = 0; else Cur = b+1;

      char *s = new char[b - r + 2];
      memcpy(s, r, b - r + 1);
      s[b - r + 1] = 0;
      return s;
    }
    char *b = new char[2];
    b[0] = '\004'; b[1] = 0; 
    return b;
  }
  virtual char *Read() { return Get(); }
  virtual void Put(const char *Item) {}
  virtual void Write(const char* Item) {}
};

#endif
