// ESSO: Extensible Shell with Scheme Orientation
// Written by Matthias Koeppe <mkoeppe@csmd.cs.uni-magdeburg.de>

// This is the main file for use in StuBS.

extern "C" {
#include "library/libfile.h"
#include "library/syslib.h"
#include "library/iolib.h"
#include "library/error.h"
#include "system/mailbox.h"
#include "system/loader.h"
#include "system/process.h"
}
#include "lisp.h"
#include "cmailbox.h"
#include "mboxpipe.h"
#include "bpipe.h"

extern int mmopgood;
#if defined(USESHM)
void initmmop();
#endif

unsigned memfreesize();
unsigned memmaxsize();

TLispRef lisp_load(TTextPipe &Pipe, TTextPipe &o, TLispRef Frame)
{
  TLispRefOS lastresult, result, expr;
  do {
    expr = lisp_read(Pipe);
    lastresult = result;
    result = lisp_eval(expr, Frame);
  } while (result.Type() != TLispBase::Eof);
  return lastresult;
}

semaphore esso_up_sema;

extern "C" 
void essoinit(void)
{
  sema_init(&esso_up_sema, 0);
}

extern "C" 
void essoapp(void)
{
  cls();
  if (!mmopgood) {
    initmmop();
    mmopgood = 1;
  }

  // init globals
  _LispNull = new TLispRef(NEW TLispNull());
  _LispFalse = new TLispRef(NEW TLispBoolean(false));
  _LispTrue = new TLispRef(NEW TLispBoolean(true));
  _GlobalFrame = new TLispRef(MakeGlobalFrame());
  SyntaxAListName = new string("syntax-alist");
  //
  TMailBox inmbox = sys_get_stdin();
  TMailBox outmbox = sys_get_stdout();
  TInteractiveMailBoxPipe csp(inmbox, outmbox);
  TIMailBoxPipe isp(inmbox);
  TOMailBoxPipe osp(outmbox);
  {
#if 0
    ifstream ls("essolib.scm");
    TIstreamPipe lsp(ls);
#else
    TBlockReadPipe lsp(strdup(
#include "essolib.ci"
));
#endif
    TRY {
      lisp_write(osp, lisp_load(lsp, osp, GlobalFrame));
    }
#ifdef OWNEXCEPTIONS
    else {
      osp.Put(strdup(Exception->Message().c_str()));	
      osp.Put(strdup("\n"));				
      delete Exception;
      Exception = 0;
#else
    catch (...) {
#endif
      osp.Put(strdup("Error reading essolib.scm; probably nothing will work."));
    }
    osp.Put(strdup("\n"));
  }
  // Esso is up, so other essoterms may attach.
  sys_sema_v(&esso_up_sema);
  // 
  read_eval_write_loop(isp, csp, osp);  
  UnregisterThreadWithTries();
  sys_exit_process();
}

extern "C" 
void essoterm(void) 
{
  sys_sema_p(&esso_up_sema);
  {
    TMailBox inmbox = sys_get_stdin();
    TMailBox outmbox = sys_get_stdout();
    TInteractiveMailBoxPipe csp(inmbox, outmbox);
    TIMailBoxPipe isp(inmbox);
    TOMailBoxPipe osp(outmbox);

    TLispRef MyFrame = new TLispFrame(GlobalFrame);
    CastFrame(MyFrame)->Define("terminal-number",
			       NEW TLispNumber(sys_get_vt_nr()));
    // An expression, not a procedure, because we have to operate on
    // the current frame; but the thing will come from the global frame. 
    lisp_eval((*CastFrame(GlobalFrame))("terminal-open-expression"), MyFrame);
    sys_sema_v(&esso_up_sema); // let others boot
    read_eval_write_loop(isp, csp, osp, MyFrame);
  }
  UnregisterThreadWithTries();
  sys_exit_process();
}

extern "C"
int esso_vt (int vn, void (*appl)(), char* stack, int stack_size)
  {  
    RegisterThreadWithTries(stack, stack + stack_size);
    return standard_vt(vn, appl, stack, stack_size);
  }
