(define (quiz-finish ports)
  (task-force (delay (write-line "n" (car ports))))
  (lazy-load-text (cdr ports)))

(define (quiz-step-aux ports lower tried higher)
  (let ((line (read-line (cdr ports))))
    (begin
      (write-line line (current-output-port))
      (cond ((string=? (substring line 23 25) "kl")
	     (quiz-step ports lower (- tried 1)))
	    ((string=? (substring line 23 25) "gr")
	     (quiz-step ports (+ tried 1) higher))
	    ((string=? (substring line 0 2) "ri")
	     (quiz-finish ports))
	    (else (quiz-step-aux ports lower tried higher))))))
	   
(define (quiz-step ports lower higher)
  (if (> lower higher) 
      (write-line "quizquiz: Ich glaube, hier wird geschummelt." (current-output-port))
      (let ((tried (quotient (+ lower higher) 2)))
	(begin
	  (write tried (car ports))
	  (newline (car ports))
	  (quiz-step-aux ports lower tried higher)))))

(define (quizquiz)
  (define ports (run-executable "/quiz"))
  (quiz-step ports 1 100)
  #t)

quizquiz
