"Functions from EssoLib that are so slow that we had to"
"take them out again and code them directly in C++."
"Or, architecture was changed, which required coding things"
"differently. In either case, no-one will need what is here."
"If you want, you may consider this as a kind of version log."
"Written by Matthias Koeppe <mkoeppe@csmd.cs.uni-magdeburg.de>"

(define (string-append-slow . strings)
  (list->string (apply append (map string->list strings))))

(define (string-copy-slow s)
  (list->string (string->list s)))

(define (read-line-aux port str)
  (let ((c (read-char port)))
    (cond ((eof-object? c) (if (null? (string-length str)) c str))
	  ((char=? c #\newline) str)
	  (else (read-line-aux port (string-append str (string c)))))))
(define (slow-read-line port)
  (read-line-aux port ""))

"This function has become superfluous; ESSO supports"
"implicit forcing, with promises being first-class objects."
(define make-promise
  (lambda (proc)
    (let ((result-ready? #f)
	  (result #f))
      (lambda ()
	(if result-ready?
	    result
	    (let ((x (proc)))
	      (if result-ready?
		  result
		  (begin (set! result-ready? #t)
			 (set! result x)
			 result))))))))
(define force
  (lambda (object)
    (object)))

(define (file-directory-list-aux-slow dir-list last-pos cur-pos str)
  (cond ((>= cur-pos (string-length str))
	 (append dir-list (list (substring str last-pos cur-pos))))
	((char=? (string-ref str cur-pos) #\/)
	 (file-directory-list-aux-slow (append dir-list
					  (list (substring str last-pos cur-pos)))
				  (+ 1 cur-pos)
				  (+ 1 cur-pos)
				  str))
	(else (file-directory-list-aux-slow dir-list last-pos (+ 1 cur-pos) str))))

(define (substring-slow s start end)
  (list->string (string->list-aux s () start end)))


(define (file-name-aux char-list)
  (let ((result (memv #\/ char-list)))
    (if result
	(file-name-aux (cdr result))
	char-list)))
(define (file-name name)
  (list->string (file-name-aux (string->list name))))	
(define (file-extension name)
  (let ((result (memv #\. (file-name-aux (string->list name)))))
    (if result
	(list->string (cdr result))
	"")))
(define (file-base name)
  (let ((extlength (string-length (file-extension name)))
	(fn (file-name name)))
    (if (zero? extlength)
	fn
	(substring fn 0 (- (string-length fn) (+ extlength 1))))))
