"Esso: Frame functions"
"Written by Matthias Koeppe <mkoeppe@csmd.cs.uni-magdeburg.de>"

(define (procedure-symbol? x)
  (procedure? (eval x the-global-frame)))
(define (variable-symbol? x)
  (not (procedure? (eval x the-global-frame))))
(define (good-procedure-name? s)
  (not (string=? (substring s (- (string-length s) 4) (string-length s))
		 "-aux")))
'(or (< (string-length s) 4))

(define (not-good-procedure-symbol? x)
  (not (and (procedure-symbol? x)
	    (good-procedure-name? (symbol->string x)))))

(define (bindings)
  (frame-bindings the-global-frame))
(define (procedures)
  (remove-if (bindings) not-good-procedure-symbol?))
(define (variables)
  (remove-if (bindings) procedure-symbol?))

"This function might be used by a line editor when the Tab key is pressed."
"That is, save the current line, send a (tab \"xyz\") line to Esso, and"
"restore the line. Maybe, someone even wants to do this context-dependent"
"and sort out procedures etc.; then this procedure is not enough."
(define (tab symbol-head)
  (remove-if (bindings)
	     (lambda (s)
	       (let ((sn (symbol->string s)))
		 (or (< (string-length sn) (string-length symbol-head))
		     (not (string=? (substring sn 0 (string-length symbol-head))
				    symbol-head)))))))

"frame"
