// Memory operators, using memory messages
// <mkoeppe@csmd.cs.uni-magdeburg.de>
// memory mgmt by <mahrenho@csmd.cs.uni-magdeburg.de>

int mmopgood = 0;

#if defined(_LowLevel)

extern "C" {
#include "library/syslib.h"
}
#include "mmserv.inc"

#define MM_shm_size 1024*1024

void initmmop()
{
  ERamSize = MM_shm_size;
  ERamStart = (int) sys_malloc(ERamSize);
  initmem(ERamStart, ERamSize);
}

#else

#include <iostream.h>
#include <sys/ipc.h>
#include <sys/shm.h>
#include <errno.h>
#include "asmmacro.h"
#include <string.h> //memset

#define MM_shm_magic 0x0dd000ff
#define MM_shm_size 3*1024*1024

int shmid;

#if 1
#include "mmserv.inc"

size_t blocksize(char *ptr)
{
  //& do sth about smb
  TMemBlock *b = (TMemBlock *)(((unsigned)(ptr))-sizeof(TMemBlock));
  return b->size;
}

#endif

void initmmop()
{
  ERamSize = MM_shm_size;

  shmid = shmget(MM_shm_magic, ERamSize, 0);
  if (shmid <= 0) shmid = shmget(MM_shm_magic, ERamSize, IPC_CREAT | 0666);
  cout << "Esso: Using shared memory management services." << endl; 
  if (shmid <0) {
    cerr << "Esso: Error installing shm segment (" << strerror(errno) << ")" << endl;
    exit(-1);
  }

  ERamStart = (int)shmat(shmid, 0, 0);
  //cout << "ESSOsh-mm: using shm " << shmid << " at " << ERamStart << endl;
  initmem(ERamStart, ERamSize);
}

#endif

extern "C" {

  void *malloc(size_t size) 
  {
    if (!mmopgood) {
      initmmop();
      mmopgood=1;
    }
    if (!size) size = 1;
    return memalloc(size);
  }

  void *calloc(size_t nmemb, size_t size)
    {
      void *m = malloc(nmemb * size);
      memset(m, 0, nmemb * size);
      return m;
    }

  void *free(void *p)
    {
      if (p) memfree((char *) p);
    }

#if !defined(_LowLevel)
  void *realloc(void *ptr, size_t size)
    {
      if (ptr == 0) return malloc(size);
      else if (size == 0) {
	free(ptr);
	return 0;
      }
      else {
	size_t oldsize = blocksize((char *)ptr);
	void *newptr = malloc(size);
	//& actually fetch old size...
	if (oldsize <= size) memcpy(newptr, ptr, oldsize);
	else memcpy(newptr, ptr, size);
	free(ptr);
	return newptr;
      }
    }
#endif
}

extern int statistics[33];

void *operator new (size_t size)
{
  if (!size) size = 1;
#if !defined(_LowLevel)
  if (size >= 256) statistics[33]++;
  else statistics[(size+7)/8]++;
#endif
  if (!mmopgood) return malloc(size);
  return (void *) memalloc(size);
}

void *operator new[] (size_t size)
{
  if (!size) size = 1;
#if !defined(_LowLevel)
  if (size >= 256) statistics[33]++;
  else statistics[(size+7)/8]++;
#endif
  if (!mmopgood) return malloc(size);
  return (void *) memalloc(size);
}

void operator delete (void *ptr)
{
  if (!mmopgood) free(ptr);
  else if (ptr) memfree((char *) ptr);
}

void operator delete[] (void *ptr)
{
  if (!mmopgood) free(ptr);
  else if (ptr) memfree((char *) ptr);
}

void *operator new(size_t, void *place) { return place; }
void *operator new[](size_t, void *place) { return place; }

