;;;
;;; Einfache Eingabe logischer Formeln
;;;

(define (parse formula)
  ;; Untersucht die Formel und wandelt sie 
  ;; in die interne Repr"asentation um.
  (cond ((and (pair? formula)
	      (null? (cdr formula)))
	 ;; Entfernt ein "uberfl"ussiges Klammerpaar.
	 (parse (car formula)))

	((and (pair? formula)
	      (symbol? (car formula)))
	 ;; Interpretiert Schl"usselw"orter.
	 (case (car formula)
	   ((all forall) 
	    (make-forall-quantification (cadr formula)
					(parse (cddr formula))))
	   ((ex exist exists)
	    (make-exists-quantification (cadr formula)
					(parse (cddr formula))))
	   ((and)
	    (apply make-conjunction (map parse (cdr formula))))
	   ((or)
	    (apply make-disjunction (map parse (cdr formula))))
	   ((not)
	    (make-negation (parse (cdr formula))))
	   ((xor)
	    (make-xor (parse (cadr formula)) 
		      (parse (caddr formula))))
	   ((imp imply implies)
	    (make-implication (parse (cadr formula)) 
			      (parse (caddr formula))))
	   ((eq eqv equiv equivalent)
	    (make-equivalence (parse (cadr formula)) 
			      (parse (caddr formula))))
	   (else (parse-for-predicate formula))))

	((pair? formula) 
	 ;; Sieht die Formel als Pr"adikat-Anwendung an.
	 (parse-for-predicate formula))

	(else formula)))
	 

(define (parse-for-predicate formula)
  (make-predicate-application (car formula) 
			      (map parse-term (cdr formula))))

(define (parse-term formula)
  ;; Untersucht den Term und wandelt ihn in die interne
  ;; Repr"asentation um.
  (cond ((pair? formula) 
	 (case (car formula)
	   ((var vari variable)
	    (if (pair? (cdr formula))
		(make-variable (cadr formula))
		(make-variable (cdr formula))))
	   ((const constant)
	    (if (pair? (cdr formula))
		(make-constant (cadr formula))
		(make-constant (cdr formula))))
	   (else (make-function-application 
		  (car formula)
		  (map parse-term (cdr formula))))))
	((symbol? formula) 
	 (if (means-variable? formula)
	     (make-variable formula)
	     (make-constant formula)))
	(else (make-constant formula))))

(define (means-variable? symbol)
  ;; Per Konvention sind alle Symbole, die mit den Buchstaben 
  ;; \texttt{X} bis \texttt{Z} beginnen, Variablennamen.
  (let ((first-character 
	 (car (string->list (symbol->string symbol)))))
    (and (char-ci>=? first-character #\X)
	 (char-ci<=? first-character #\Z))))
