is responsible for managing/deleting the data.

    u32 DataSize () const;
    // Return the data size

    void PutData (void* DataPtr, u32 DataSize);
    // Free the current data and store the new data in the container.

    Container& CopyFrom (void* DataPtr, u32 DataSize);
    // Free the current data, create a new data block, copy given data

    int StoreData (const String& Filename) const;
    // Store the current data in the given file. Return 1 on success, 0 on
    // failure.

    int LoadData (const String& Filename);
    // Delete the current data, read new data from a file. The function
    // returns 1 on success, 0 on failure.

    Container& operator = (const Container& C);
    // Assignment operator for containers
};



inline Container::Container (StreamableInit)
{
}



inline Container::Container () :
    Data (NULL), Size (0)
{
}



inline u32 Container::DataSize () const
{
    return Size;
}



// End of CONT.H

#endif

                                                                     
                              SPUNK LIBRARY

              (C) Copyright 1992-1996 Ullrich von Bassewitz

                           COPYING CONDITIONS


  This software is provided 'as-is', without any express or implied
  warranty.  In no event will the authors be held liable for any damages
  arising from the use of this software.

  Permission is granted to anyone to use this software for any purpose,
  including commercial applications, and to alter it and redistribute it
  freely, subject to the following restrictions:

  1. The origin of this software must not be misrepresented; you must not
     claim that you wrote the original software. If you use this software
     in a product, an acknowledgment in the product documentation would be
     appreciated but is not required.
  2. Altered source versions must be plainly marked as such, and must not
     be misrepresented as being the original software.
  3. This notice may not be removed or altered from any source
     distribution

                   /*****************************************************************************/
/*									     */
/*				    CPUCVT.CC				     */
/*									     */
/* (C) 1993-96	Ullrich von Bassewitz					     */
/*		Wacholderweg 14						     */
/*		D-70597 Stuttgart					     */
/* EMail:	uz@ibb.schwaben.com					     */
/*									     */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



// This file contains code to convert to and from little endian data types
// into the native format.



#include "cpucvt.h"



/*****************************************************************************/
/*				     Code				     */
/*****************************************************************************/



#ifdef CPU_BIG_ENDIAN



void ToLittleEndian (i16& X)
{
    X = ((X << 8) & 0xFF00) |
	((X >> 8) & 0x00FF);
}



void ToLittleEndian (i32& X)
{
    X = ((X >> 24) & 0x000000FF) |
	((X >>	8) & 0x0000F