keyboard

    Key Peek ();
    // Return the next key but don't remove it from the queue. This function
    // returns kbNoKey if no key is currently available.

    void Put (Key);
    // Put back a key into the queue

    int KeyAvail ();
    // Return true if a key is available

    int IsConsole ();
    // Return true if the keyboard is the console keyboard

    String GetKeyName (Key K);
    // Return a string describing the give key
};



inline Key Keyboard::Translate (Key K)
// Translate plain keys via the translation table (if valid)
{
    return IsPlainKey (K) && TransTable != NULL ? TransTable [K] : K;
}



inline Key Keyboard::Get ()
{
    if (KeyBuf.IsEmpty ()) {
        // Get a key from the os
        GetMappedKey ();
    }

    // In any case a key is now available
    return KeyBuf.Get ();
}



inline Key Keyboard::Peek ()
// Return the next key but don't remove it from the queue. This function
// returns kbNoKey if no key is currently available.
{
    if (KeyBuf.IsEmpty ()) {
        // Get new key but don't wait
        GetMappedKey (0);
    }

    // Return kbNoKey if no key is available, otherwise return the first
    // key in the buffer
    if (KeyBuf.IsEmpty ()) {
        return kbNoKey;
    } else {
        // Return top of stack
        return KeyBuf.Peek ();
    }
}



inline void Keyboard::Put (Key K)
{
    KeyBuf.PutInFront (K);
}



inline int Keyboard::KeyAvail ()
{
    if (!KeyBuf.IsEmpty ()) {
        // Buffer contains characters
        return 1;
    }

    // Buffer is emtpy, read new keys if there are any
    GetMappedKey (0);

    // Now return the buffer status
    return KeyBuf.IsEmpty () == 0;
}



inline int Keyboard::IsConsole ()
// Return true if the keyboard is the console keyboard
{
    return Console;
}



// End of KBD.H

#endif
                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 /*****************************************************************************/
/*                                                                           */
/*                                 KEYDEF.CC                                 */
/*                                                                           */
/* (C) 1993-95  Ullrich von Bassewitz                                        */
/*              Zwehrenbuehlstrasse 33                                       */
/*              D-72070 Tuebingen                                            */
/* EMail:       uz@ibb.schwaben.com                                          */
/*                                                                           */
/*****************************************************************************/



// $Id$
//
// $Log$
//
//



#include <stddef.h>

#include "keydef.h"



/*********************************************************************