program AnimFromResource;

{ Mouse cursor animation from Windows resource, MyMouse/WinRes sample program,
  Copr. 1994 Matthias Kppe.
}

uses Crt, Drivers, Gr, Objects, MyMouse, MAnimate, WinRes;

var
  Anim: PAnimation;
  SavedGC: TGetMCProc;

{ Service routines
}

procedure AChangeCursor; far;
Begin
  Anim^.ChangeCursor
End;

procedure AGetCursor(n: Integer); far;
Begin
  If not Anim^.GetCursor(n) then
  SavedGC(n);
End;

function LoadAnimation: PAnimation;
{ Loads mouse cursors from a Windows resource.
}
var
  S: PStream;
  Anim: PAnimation;
  i: Integer;
Begin
  Anim := New(PAnimation, Init(100, 1));
  { clock.exe is a dummy Windows EXE file, which defines the cursor resources
    named 1 through 12.
  }
  S := New(PBufStream, Init('clock.exe', stOpenRead, 2048));
  If SkipStub(S^) and SkipToResTbl(S^) then
    For i := 1 to 12 do
      Anim^.Insert(LoadCursor(S^, MakeIntResource(i)));
  Dispose(S, Done);
  LoadAnimation := Anim
End;

procedure Run;
var
  Event: TEvent;
Begin
  Repeat
    GetTimerEvent(Event);
    If Event.What = evTimer then AnimTimer;
    GetMouseEvent(Event)
  Until Event.What = evMouseDown
End;

Begin
  Anim := LoadAnimation;
  SetGrMode(grVgaHiStd);
  UserParams(0); InitGraphProc;
  MaxWidth := 4; MaxLength := 32;
  InitMyMouse;
  SavedGC := GetMCursor;
  GetMCursor := AGetCursor;
  ChangeCursor := AChangeCursor;
  Run;
  DoneMyMouse;
  Dispose(Anim, Done);
  UserParams(0); CloseGraphProc
End.
