; MetaGraph 16 color modes drawing procs
; Copyright 1994,96 by Daniel Mahrenholz

INCLUDE	grdef.asm
INCLUDE metagr.def

IDEAL

INCLUDE	"MetaGlob.inc"
INCLUDE "MetaGr.con"
INCLUDE "MetaGr.mac"

SEGMENT	Data	word 	public
ASSUME	ds: Data

	SaveSD		dw	?
	SaveCX		dw	?
	Map		dw	?
	SaveDI		dw	?
	SavMap  	dw	?
	SMask		dw	?
        LMask           db      ?
        RMask           db      ?
        FillLine        dw      ?
ENDS

SEGMENT	Code	byte	public
ASSUME	cs: Code

P386

LOCALS @@

PROC	P_VL_16M near

	test	[MetaState], ms_Draw
	jnz	@@2
	add	sp, 8
	retn
@@2:
	mov	ax, [DColor16]
	mov	dx, 03ceh
	xor	al, al
	out	dx, ax
	mov	ax, 0f01h
	out	dx, ax
	mov	ax, [daWriteMode]
	out	dx, ax
	pop	di bx dx

IFDEF	uMetaOrigin
	add	di, [(TPoint MetaOrigin).x]
	add	bx, [(TPoint MetaOrigin).y]
	add	dx, [(TPoint MetaOrigin).y]
ENDIF

	cmp	di, [(TRect ClipRect).a.x]
	jl	@@3
	cmp	di, [(TRect ClipRect).b.x]
	jnl	@@3
	cmp	dx, [(TRect ClipRect).a.y]
	jl	@@3
	cmp	dx, [(TRect ClipRect).b.y]
	jl	@@4
	mov	dx, [(TRect ClipRect).b.y]
	dec	dx
@@4:
	cmp	bx, [(TRect ClipRect).b.y]
	jnl	@@3
	cmp	bx, [(TRect ClipRect).a.y]
	jnl	@@5
	mov	bx, [(TRect ClipRect).a.y]
@@5:
	push	dx bx
	mov	ax, bx
	mul	[BytesPerLine]
	mov	bx, di
	shr	di, 3
	add	di, ax
	and	bx, 7
	mov	cx, bx
	mov	bx, 80h
	shr	bx, cl
	mov	dx, 03ceh
	mov	al, 8
	out	dx, al
	inc	dx
	mov     al, bl
	out	dx, al
	pop	bx cx
	sub	cx, bx
	inc	cx
	add	di, [ActivePOfs]
	mov	bx, [daLnStyle]
@@6:
	ror	bx, 1
	jnc	@@7
	inc	[(byte fs:di)]
@@7:
	add	di, [BytesPerLine]
	dec	cx
	jnz	@@6
@@3:
	ret

ENDP


PROC 	P_HL_16M near

	pop	[ya] [xe] [xa]
	test	[MetaState], ms_Draw
	jz	@@2

IFDEF	uMetaOrigin
	mov	ax, [(TPoint MetaOrigin).x]
	mov	bx, [(TPoint MetaOrigin).y]
	add	[xa], ax
	add	[xe], ax
	add	[ya], bx
ENDIF

	mov	ax, [(TRect ClipRect).a.x]
	mov	bx, [(TRect ClipRect).a.y]
	mov	cx, [(TRect ClipRect).b.x]
	mov	dx, [(TRect ClipRect).b.y]
	cmp	[ya], bx
	jl	@@2
	cmp	[ya], dx
	jnl	@@2
	cmp	[xa], cx
	jnl	@@2
	cmp	[xe], ax
	jl	@@2
	cmp	[xa], ax
	jg	@@3
	mov	[xa], ax
@@3:
	cmp	[xe], cx
	jl	@@4
	mov	[xe], cx
	dec	[xe]
@@4:
	mov	dx, [daLnStyle]
	cmp	[FillFlag], Fill_Line
	je	@@10
	mov	si, [ya]
	and	si, 7
	shl	si, 1
	add	si, [FillBase]
	mov	dx, [ds:si]
@@10:
	mov	[Map], dx
	mov	ax, [HColor16]
	mov	dx, 03ceh
	xor	al, al
	out	dx, ax
	mov	ax, 0f01h
	out	dx, ax
	mov	ax, [daWriteMode]
	out	dx, ax
	mov	al, 8
	out	dx, al
	inc	dx
	push	dx
	mov	ax, [ActivePSeg]
	mov	es, ax
	mov	ax, [ya]
	mul	[BytesPerLine]
	mov	bx, [xa]
	shr	bx, 3
	add	ax, bx
	mov	di, ax
	add	di, [ActivePOfs]
	mov	ax, [xa]
	shr	ax, 3
	mov	cx, [xe]
	shr	cx, 3
	sub	cx, ax
	jnz	@@5
	mov	dx, 0ffffh
	mov	cx, [xa]
	and	cl, 7
	shr	dl, cl
	mov	cx, [xe]
	not	cl
	and	cl, 7
	shl	dh, cl
	and	dh, dl
	mov	al, dh
	pop	dx
	and	ax, [Map]
	out	dx, al
	inc	[(Byte es:di)]
	jmp	@@6
@@5:
	mov	dx, 0ffffh
	mov	cx, [xa]
	and	cl, 7
	shr	dl, cl
	mov	cx, [xe]
	not	cl
	and	cl, 7
	shl	dh, cl
	mov	si, dx
	pop	dx
	mov	ax, si
	and	ax, [Map]
	out	dx, al
	inc	[(Byte es:di)]
	inc	di
	mov	ax, [xa]
	shr	ax, 3
	mov	cx, [xe]
	shr	cx, 3
	sub	cx, ax
	dec	cx
	jz	@@7
	mov	ax, [Map]
	out	dx, al
	cld
	push	si
	mov	si, di
	rep	seges movsb
	pop	si
@@7:
	mov	ax, si
	mov	al, ah
	and	ax, [Map]
	out	dx, al
	inc	[(Byte es:di)]
	jmp	@@6
@@2:
@@6:
	ret

ENDP


PROC	P_Bar_16M near

	pop	[ye] [ya] [xe] [xa]
	test	[MetaState], ms_Draw
	jz	@@e

IFDEF	uMetaOrigin
	mov	ax, [(TPoint MetaOrigin).x]
	mov	bx, [(TPOint MetaOrigin).y]
	add	[xa], ax
	add	[xe], ax
	add	[ya], bx
	add	[ye], bx
ENDIF

	mov	ax, [(TRect ClipRect).a.x]
	mov	bx, [(TRect ClipRect).a.y]
	mov	cx, [(TRect ClipRect).b.x]
	mov	dx, [(TRect ClipRect).b.y]
	cmp     [ye], bx
	jl	@@e
	cmp	[ya], dx
	jnl	@@e
	cmp	[xa], cx
	jnl	@@e
	cmp	[xe], ax
	jl	@@e
	cmp	[xa], ax
	jg	@@3
	mov	[xa], ax
@@3:
	cmp	[xe], cx
	jl	@@4
	mov	[xe], cx
	dec	[xe]
@@4:
	cmp	[ya], bx
	jg	@@5
	mov	[ya], bx
@@5:
	cmp	[ye], dx
	jl	@@6
	mov	[ye], dx
	dec	[ye]
@@6:
	mov	ax, [xe]
	sub	ax, [xa]
	js	@@e
	mov	ax, [ye]
	sub	ax, [ya]
	js	@@e
	inc	ax
	mov	[yd], ax

	mov	ax, [FColor16]
	mov	dx, 03ceh
	xor	al, al
	out	dx, ax
	mov	ax, 0f01h
	out	dx, ax
	mov	ax, [daWriteMode]
	out	dx, ax
	mov	al, 8
	out	dx, al
	inc	dx
	push	dx
	mov	ax, [ActivePSeg]
	mov	es, ax
	mov	ax, [ya]
	mul	[BytesPerLine]
	mov	bx, [xa]
	shr	bx, 3
	add	ax, bx
	mov	di, ax
	add	di, [ActivePOfs]

	mov	ax, [xa]
	shr	ax, 3
	mov	cx, [xe]
	shr	cx, 3
	sub	cx, ax
        mov     [xd], cx

        mov     dx, 0ff80h
        mov     cx, [xa]
        and     cx, 7
        shr     dx, cl
        mov     [LMask], dh
        mov     dx, 0ff80h
        mov     cx, [xe]
        and     cx, 7
        shr     dx, cl
        mov     [RMask], dl
        mov     si, [FillBase]
        mov     [FillLine], 8
        pop     dx

        cmp     [xd], 0
        jne     @@long

        mov     al, [LMask]
        and     al, [RMask]
        mov     [LMask], al
@@yls:
        mov     al, [LMask]
        and     al, [(Byte ds:si)]
        out     dx, al
        inc     [(Byte es:di)]
        add     si, 2
        dec     [FillLine]
        jnz     @@yls1
        mov     [FillLine], 8
        sub     si, 16
@@yls1:
        add     di, [BytesPerLine]
        dec     [yd]
        jnz     @@yls
        jmp     @@e
@@long:
        mov     bx, si
        dec     [xd]
@@yll:
        mov     si, di
        mov     al, [LMask]
        and     al, [(Byte ds:bx)]
        out     dx, al
        seges   movsb
        mov     cx, [xd]
        or      cx, cx
        jz      @@yll1
        mov     al, [(Byte ds:bx)]
        out     dx, al
        rep     seges   movsb
@@yll1:
        mov     al, [RMask]
        and     al, [(Byte ds:bx)]
        out     dx, al
        inc     [(Byte es:di)]
        add     bx, 2
        dec     [FillLine]
        jnz     @@yll2
        sub     bx, 16
        mov     [FillLine], 8
@@yll2:
        add     di, [BytesPerLine]
        sub     di, [xd]
        dec     di
        dec     [yd]
        jnz     @@yll
@@e:
	ret

ENDP

PROC	F_Point_16M

	mov	ebx, [fx]
	mov	eax, [fy]
	mov	si, [DColor16]
	jmp	F_Point_16M_Entry

ENDP

PROC	P_Point_16M near

	pop	si bx ax
	test	[MetaState], ms_Draw
	jz	@@2

IFDEF	uMetaOrigin
	add	bx, [(TPoint MetaOrigin).x]
	add	ax, [(TPoint MetaOrigin).y]
ENDIF

	cmp	bx, [(TRect ClipRect).b.x]
	jnl	@@2
	cmp	bx, [(TRect ClipRect).a.x]
	jl	@@2
	cmp	ax, [(TRect ClipRect).b.y]
	jnl	@@2
	cmp	ax, [(TRect ClipRect).a.y]
	jl	@@2
F_Point_16M_Entry:
	mul	[BytesPerLine]
	mov	di, bx
	shr	di, 3
	add	di, ax
	and	bx, 7
	mov	cx, bx
	mov	bx, 80h
	shr	bx, cl
	mov	dx, 03ceh
	mov	ax, 0f01h
	out	dx, ax
	mov	ax, [daWriteMode]
	out	dx, ax
	mov	ax, si
	xor	al, al
	out	dx, ax
	mov	ah, bl
	mov	al, 8
	out	dx, ax
	add	di, [ActivePOfs]
	inc	[(Byte fs:di)]
@@2:
	ret

ENDP

PROC 	P_GetP_16M near

	pop	bx ax

IFDEF	uMetaOrigin
	add	ax, [(TPoint MetaOrigin).y]
	add	bx, [(TPoint MetaOrigin).x]
ENDIF

	cmp	bx, [(TRect ClipRect).b.x]
	jnl	@@1
	cmp	bx, [(TRect ClipRect).a.x]
	jl	@@1
	cmp	ax, [(TRect ClipRect).b.y]
	jnl	@@1
	cmp	ax, [(TRect ClipRect).a.y]
	jl	@@1
	mul	[BytesPerLine]
	mov	di, bx
	shr	di, 3
	add	di, ax
	and	bx, 7
	mov	cx, bx
	mov	bx, 80h
	shr	bx, cl
	add	di, [ActivePOfs]
	mov	si, 0
	mov	cx, 0
	mov	dx, 03ceh
	mov	ax, 5
	out	dx, ax
	mov	al, 4
	out	dx, al
	inc	dx
	mov	al, 3
	out	dx, al
	mov	cl, [fs:di]
	and	cl, bl
	jz	@@2
	mov	si, 8
@@2:
	dec	al
	out	dx, al
	mov	cl, [fs:di]
	and	cl, bl
	jz	@@3
	add	si, 4
@@3:
	dec	al
	out	dx, al
	mov	cl, [fs:di]
	and	cl, bl
	jz	@@4
	add	si, 2
@@4:
	dec	al
	out	dx, al
	mov	cl, [fs:di]
	and	cl, bl
	jz	@@5
	inc	si
@@5:
	mov	ax, si
	ret
@@1:
	mov	ax, 0
	ret

ENDP

PROC	P_Line_16M NEAR

	pop	dx cx bx ax

	LOCAL	flip, xmin, xmax, ymin, ymax, x1, x2, y1, y2, d: DWord, \
		diag: DWord, sd: DWOrd, xinc: DWord, yinc: DWord = LocalSize

	push	bp
	mov	bp, sp
	sub	sp, LocalSize

	push	[daLnStyle]
	pop	[Style]
	mov	[diag], 0
	mov	[flip], 0
	mov     [y1], dx
	mov	[ymin], dx
	mov	[y2], cx
	mov	[ymax], cx
	mov	[x1], bx
	mov	[xmin], bx
	mov	[x2], ax
	mov	[xmax], ax
	sub	cx, dx
	mov	[yd], cx
	jns	@@dt2
	neg	cx
	mov	dx, [ymin]
	xchg	dx, [ymax]
	mov	[ymin], dx
@@dt2:
	sub	ax, bx
	mov	[xd], ax
	jns	@@dt1
	neg	ax
	mov	bx, [xmin]
	xchg	bx, [xmax]
	mov	[xmin], bx
@@dt1:
	mov	bx, ax
	or	bx, cx
	jnz	@@np
	movsx	eax, [x1]
	mov	[fx], eax
	movsx	ebx, [y1]
	mov	[fy], ebx

	; clipping

	cmp	ax, [(TRect ClipRect).a.x]
	jl	@@e
	cmp	ax, [(TRect ClipRect).b.x]
	jnl	@@e
	cmp	bx, [(TRect ClipRect).a.y]
	jl	@@e
	cmp	bx, [(TRect ClipRect).b.y]
	jnl	@@e

	rol	[Style], 1
	jnc	@@e

	call	F_Point_16M
	jmp	@@e
@@np:
	mov	bx, ax

	mov	ax, [DColor16]
	mov	dx, 03ceh
	out	dx, ax
	mov	ax, 0f01h
	out	dx, ax
	mov	ax, [daWriteMode]
	out	dx, ax
	mov	al, 8
	out	dx, al
	inc	dx

	cmp	bx, cx
	jg	@@xd
	jne	@@yd

	mov	[diag], 1
	test	[yd], 08000h
	jz	@@edz
	neg	[flip]
	mov	dx, [y1]
	xchg	[y2], dx
	mov	[y1], dx
	neg	[yd]
	mov	ax, [x1]
	xchg	ax, [x2]
	mov	[x1], ax
	neg	[xd]
@@edz:
	movsx	eax, [x1]
	mov	[fx], eax
	mov	[xinc], 1
	test	[xd], 08000h
	jz	@@edxz
	neg	[xinc]
	neg	[diag]
@@edxz:
	mov	eax, 080000000h
	jmp	@@ydcs

@@yd:

	; sort y-Coords for y1<y2
	; calculate d as dx/dy

	test	[yd], 08000h
	jz	@@ydz

	neg	[flip]
	mov	dx, [y1]
	xchg	[y2], dx
	mov	[y1], dx
	mov	dx, [x1]
	xchg	dx, [x2]
	mov	[x1], dx
	neg	[yd]
	neg	[xd]

@@ydz:
	movsx	eax, [x1]
	mov	[fx], eax
	mov	[xinc], 1
	test	[xd], 08000h
	jz	@@ydxz
	neg	[xinc]
@@ydxz:
	movsx	ebx, [yd]
	movsx	eax, [xd]
	mov	ecx, 080000000h
	imul	ecx
	idiv	ebx
	shr	ebx, 1
	cmp	bx, dx
	jge	@@ydc3
	inc	eax
@@ydc3:

@@ydcs:
	mov	[d], eax
	mov	[sd], 0
	; x-Clipping I

	mov	ax, [xmax]
	cmp	ax, [(TRect ClipRect).a.x]
	jl	@@e				; invisible
	mov	ax, [xmin]
	cmp	ax, [(TRect ClipRect).b.x]
	jge	@@e				; invisible

	; y-clipping

	mov	ax, [ymin]
	cmp	ax, [(TRect ClipRect).b.y]
	jge	@@e				; invisible
	mov	bx, [ymax]
	cmp	bx, [(Trect ClipRect).a.y]
	jl	@@e				; invisible
	mov	ax, [y1]
	cmp	ax, [(TRect ClipRect).a.y]
	jnl	@@ydc1

	; clip y1 to ClipRect.a.x
	neg	ax
	add	ax, [(TRect ClipRect).a.y]
	cwde
	test	[diag], 1
	jz	@@ydnodiag
	imul	[diag]
	mov	edx, eax
	jmp	@@ydc4
@@ydnodiag:
	shl	eax, 1
	imul	[d]
	shr	eax, 1
	test	[flip], 1
	jnz	@@ydc4
	neg	edx
@@ydc4:
	add	[fx], edx			; new starting x
	mov	[sd], eax			; rest
	mov	ax, [(TRect ClipRect).a.y]
	mov	[y1], ax

@@ydc1:
	mov	bx, [y2]
	cmp	bx, [(TRect ClipRect).b.y]
	jl	@@ydc2

	; clip y2 to ClipRect.b.y
	mov	ax, [(TRect ClipRect).b.y]
	mov	[y2], ax
@@ydc2:
	mov	ax, [y2]
	sub	ax, [y1]
        jnz     @@ydcnp
        ; only one linepoint to draw
        rol    [Style], 1
        jnc    @@e
	movsx	eax, [y1]
	mov	[fy], eax
        call   F_Point_16M
        jmp    @@e

@@ydcnp:
	mov	[yd], ax
	xor	eax, eax
	movsx	eax, [y1]
	mov	[fy], eax
	mov	esi, [d]
	test	[xinc], 08000000h
	jnz	@@ydloopb
	movsx	ecx, [(TRect ClipRect).a.x]

@@ydloop:
	cmp	[fx], ecx
	jge	@@ydloop2

	rol	[Style], 1
	inc	[fy]
	add	[sd], esi
	jns	@@yd_nox		; 31bit-overflow

	inc	[fx]
	and	[sd], 07fffffffh

@@yd_nox:
	dec	[yd]
	jnz	@@ydloop
	jmp	@@e

@@ydloop2:
	mov	eax, [fx]
	mov	edi, [fy]
	imul	edi, [BytesPerLine32]
        add     edi, [ActiveLinear32]
	xor	ecx, ecx
	shrd	ecx, eax, 3
	shr	eax, 3
	add	edi, eax
	shr	ecx, 29
	mov	al, 080h
	ror	al, cl
	movsx	ecx, [(TRect ClipRect).b.x]
	mov	dx, 03cfh
@@ydl2s:
	cmp	[fx], ecx
	jge	@@e

	rol	[Style], 1
	jnc	@@ydl2nd
	out	dx, al
	inc	[(byte fs:di)]
@@ydl2nd:
	add	edi, [BytesPerLine32]
	add	[sd], esi
	jns	@@yd_nox2		; 31bit-overflow

	ror	al, 1
	adc	edi, 0
	inc	[fx]
	and	[sd], 07fffffffh

@@yd_nox2:

	dec	[yd]
	jnz	@@ydl2s
	jmp	@@e

@@ydloopb:
	movsx	ecx, [(TRect ClipRect).b.x]
@@ydlbs:
	cmp	[fx], ecx
	jl	@@ydloopb2

	rol	[Style], 1
	inc	[fy]
	add	[sd], esi
	jns	@@yd_noxb		; 31bit-overflow

	dec	[fx]
	and	[sd], 07fffffffh

@@yd_noxb:
	dec	[yd]
	jnz	@@ydlbs
	jmp	@@e

@@ydloopb2:
	mov	eax, [fx]
	mov	edi, [fy]
	imul	edi, [BytesPerLine32]
        add     edi, [ActiveLinear32]
	xor	ecx, ecx
	shrd	ecx, eax, 3
	shr	eax, 3
	add	edi, eax
	shr	ecx, 29
	mov	al, 080h
	ror	al, cl
	movsx	ecx, [(TRect ClipRect).a.x]
	mov	dx, 03cfh
@@ydlb2s:
	cmp	[fx], ecx
	jl	@@e

	rol	[Style], 1
	jnc	@@ydlb2nd
	out	dx, al
	inc	[(byte fs:di)]
@@ydlb2nd:
	add	edi, [BytesPerLine32]
	add	[sd], esi
	jns	@@yd_noxb2		; 31bit-overflow

	rol	al, 1
	sbb	edi, 0
	dec	[fx]
	and	[sd], 07fffffffh

@@yd_noxb2:

	dec	[yd]
	jnz	@@ydlb2s
	jmp	@@e

@@xd:

	test	[xd], 08000h
	jz	@@xdz

	mov	dx, [x1]
	xchg	[x2], dx
	mov	[x1], dx
	neg	[xd]
	mov	ax, [y1]
	xchg	ax, [y2]
	mov	[y1], ax
	neg	[yd]

@@xdz:
	movsx	eax, [y1]
	mov	[fy], eax
	mov	[yinc], 1
	test	[yd], 08000h
	jz	@@xdyz
	neg	[yinc]
@@xdyz:

	movsx	ebx, [xd]
	movsx	eax, [yd]
	mov	ecx, 080000000h
	imul	ecx
	idiv	ebx
	shr	ebx, 1
	cmp	bx, dx
	jge	@@xdc3
	inc	eax
@@xdc3:
	mov	[d], eax
	mov	[sd], 0
	; y-Clipping I

	mov	ax, [ymax]
	cmp	ax, [(TRect ClipRect).a.y]
	jl	@@e				; invisible
	mov	ax, [ymin]
	cmp	ax, [(TRect ClipRect).b.y]
	jge	@@e				; invisible

	; x-clipping

	mov	ax, [xmin]
	cmp	ax, [(TRect ClipRect).b.x]
	jge	@@e				; invisible
	mov	bx, [xmax]
	cmp	bx, [(Trect ClipRect).a.x]
	jl	@@e		; invisible
	mov	ax, [x1]
	cmp	ax, [(TRect ClipRect).a.x]
	jnl	@@xdc1

	; clip x1 to ClipRect.a.x
	neg	ax
	add	ax, [(TRect ClipRect).a.x]
	cwde
	test	[diag], 1
	jz	@@xdnodiag
	imul	[diag]
	mov	edx, eax
	jmp	@@xdc4
@@xdnodiag:
	shl	eax, 1
	imul	[d]
	shr	eax, 1
	test	[flip], 1
	jnz	@@xdc4
	neg	edx
@@xdc4:
	add	[fy], edx			; new starting y
	mov	[sd], eax			; rest
	mov	ax, [(TRect ClipRect).a.x]
	mov	[x1], ax

@@xdc1:
	mov	bx, [x2]
	cmp	bx, [(TRect ClipRect).b.x]
	jl	@@xdc2

	; clip x2 to ClipRect.b.x
	mov	ax, [(TRect ClipRect).b.x]
	mov	[x2], ax
@@xdc2:
	mov	ax, [x2]
	sub	ax, [x1]
        jnz     @@xdcnp
        ; only one linepoint to draw
        rol    [Style], 1
        jnc    @@e
	movsx	eax, [x1]
	mov	[fx], eax
        call   F_Point_16M
        jmp    @@e

@@xdcnp:
	mov	[xd], ax
	xor	eax, eax
	movsx	eax, [x1]
	mov	[fx], eax
	mov	esi, [d]
	test	[yinc], 08000000h
	jnz	@@xdloopb
	movsx	ecx, [(TRect ClipRect).a.y]

@@xdloop:
	cmp	[fy], ecx
	jge	@@xdloop2

	rol	[Style], 1
	inc	[fx]
	add	[sd], esi
	jns	@@xd_noy		; 31bit-overflow

	inc	[fy]
	and	[sd], 07fffffffh

@@xd_noy:
	dec	[xd]
	jnz	@@xdloop
	jmp	@@e

@@xdloop2:
	mov	eax, [fx]
	mov	edi, [fy]
	imul	edi, [BytesPerLine32]
        add     edi, [ActiveLinear32]
	xor	ecx, ecx
	shrd	ecx, eax, 3
	shr	eax, 3
	add	edi, eax
	shr	ecx, 29
	mov	al, 080h
	ror	al, cl
	movsx	ecx, [(TRect ClipRect).b.y]
	mov	dx, 03cfh

@@xdl2s:
	cmp	[fy], ecx
	jge	@@e

	rol	[Style], 1
	jnc	@@xdl2nd

	out	dx, al
	inc	[(byte fs:di)]

@@xdl2nd:
	ror	al, 1
	adc	edi, 0
	add	[sd], esi
	jns	@@xd_noy2		; 31bit-overflow

	inc	[fy]
	add	edi, [BytesPerLine32]
	and	[sd], 07fffffffh

@@xd_noy2:

	dec	[xd]
	jnz	@@xdl2s
	jmp	@@e

@@xdloopb:
	movsx	ecx, [(TRect ClipRect).b.y]
@@xdlbs:
	cmp	[fy], ecx
	jl	@@xdloopb2

	rol	[Style], 1
	inc	[fx]
	add	[sd], esi
	jns	@@xd_noyb		; 31bit-overflow

	dec	[fy]
	and	[sd], 07fffffffh

@@xd_noyb:
	dec	[xd]
	jnz	@@xdlbs
	jmp	@@e

@@xdloopb2:
	mov	eax, [fx]
	mov	edi, [fy]
	imul	edi, [BytesPerLine32]
        add     edi, [ActiveLinear32]
	xor	ecx, ecx
	shrd	ecx, eax, 3
	shr	eax, 3
	add	edi, eax
	shr	ecx, 29
	mov	al, 080h
	ror	eax, cl
	movsx	ecx, [(TRect ClipRect).a.y]
	mov	dx, 03cfh

@@xdlb2s:
	cmp	[fy], ecx
	je	@@e

	rol	[Style], 1
	jnc	@@xdlb2nd
	out	dx, al
	inc	[(byte fs:di)]

@@xdlb2nd:
	ror	al, 1
	adc	edi, 0
	add	[sd], esi
	jns	@@xd_noyb2		; 31bit-overflow

	dec	[fy]
	sub	edi, [BytesPerLine32]
	and	[sd], 07fffffffh

@@xd_noyb2:

	dec	[xd]
	jnz	@@xdlb2s
	jmp	@@e
@@e:
	leave
	ret

ENDP

PROC	P_HL_16C

	pop	[ya] [xe] [xa]
	test	[MetaState], ms_Draw
	jz	@@3

IFDEF	uMetaOrigin
	mov	ax, [(TPoint MetaOrigin).x]
	mov	bx, [(TPoint MetaOrigin).y]
	add	[xa], ax
	add	[xe], ax
	add	[ya], bx
ENDIF

	mov	ax, [(TRect ClipRect).a.x]
	mov	bx, [(TRect ClipRect).a.y]
	mov	cx, [(TRect ClipRect).b.x]
	mov	dx, [(TRect ClipRect).b.y]
	cmp	[ya], bx
	jl	@@7
	cmp	[ya], dx
	jnl	@@7
	cmp	[xa], cx
	jnl	@@7
	cmp	[xe], ax
	jl	@@7
	cmp	[xa], ax
	jg	@@4
	mov	[xa], ax
@@4:
	cmp	[xe], cx
	jl	@@5
	mov	[xe], cx
	dec	[xe]
@@5:
	mov	dx, [daLnStyle]
	cmp	[FillFlag], Fill_Line
	je	@@10
	mov	si, [ya]
	and	si, 7
	shl	si, 1
	add	si, [FillBase]
	mov	dx, [ds:si]
@@10:
	mov	[Map], dx
	mov	ax, [HColor16]
	mov	dx, 03ceh
	xor	al, al
	out	dx, ax
	mov	ax, 0f01h
	out	dx, ax
	mov	ax, [daWriteMode]
	out	dx, ax
	mov	al, 8
	out	dx, al
	inc	dx
	push	dx
	mov	ax, [ActivePSeg]
	mov	es, ax
	mov	ax, [ya]
	mul	[BytesPerLine]
	mov	bx, [xa]
	shr	bx, 3
	add	ax, bx
	mov	di, ax
	add	di, [ActivePOfs]
	mov	ax, [xa]
	shr	ax, 3
	mov	cx, [xe]
	shr	cx, 3
	sub	cx, ax
	jnz	@@6
	mov	dx, 0ffffh
	mov	cx, [xa]
	and 	cl, 7
	shr	dl, cl
	mov	cx, [xe]
	not	cl
	and	cl, 7
	shl	dh, cl
	and	dh, dl
	mov	al, dh
	pop	dx
	and	ax, [Map]
	out	dx, al
	inc	[(byte es:di)]
	jmp	@@7
@@6:
	mov	dx, 0ffffh
	mov	cx, [xa]
	and	cl, 7
	shr	dl, cl
	mov	cx, [xe]
	not	cl
	and	cl, 7
	shl	dh, cl
	mov	si, dx
	pop	dx
	mov	ax, si
	and	ax, [Map]
	out	dx, al
	inc	[(Byte es:di)]
	inc	di
	mov	ax, [xa]
	shr	ax, 3
	mov	cx, [xe]
	shr	cx, 3
	sub	cx, ax
	dec	cx
	jz	@@8
	mov	ax, [Map]
	out	dx, al
	cld
	push	si
	mov	si, di
	rep	stosb
	pop	si
@@8:
	mov	ax, si
	mov	al, ah
	and	ax, [Map]
	out	dx, al
	inc	[(Byte es:di)]
	jmp	@@7
@@3:
@@7:
	ret
ENDP

PROC	P_Bar_16C near

	pop	[ye] [ya] [xe] [xa]
	test	[MetaState], ms_Draw
	jz	@@e

IFDEF	uMetaOrigin
	mov	ax, [(TPoint MetaOrigin).x]
	mov	bx, [(TPOint MetaOrigin).y]
	add	[xa], ax
	add	[xe], ax
	add	[ya], bx
	add	[ye], bx
ENDIF

	mov	ax, [(TRect ClipRect).a.x]
	mov	bx, [(TRect ClipRect).a.y]
	mov	cx, [(TRect ClipRect).b.x]
	mov	dx, [(TRect ClipRect).b.y]
	cmp     [ye], bx
	jl	@@e
	cmp	[ya], dx
	jnl	@@e
	cmp	[xa], cx
	jnl	@@e
	cmp	[xe], ax
	jl	@@e
	cmp	[xa], ax
	jg	@@3
	mov	[xa], ax
@@3:
	cmp	[xe], cx
	jl	@@4
	mov	[xe], cx
	dec	[xe]
@@4:
	cmp	[ya], bx
	jg	@@5
	mov	[ya], bx
@@5:
	cmp	[ye], dx
	jl	@@6
	mov	[ye], dx
	dec	[ye]
@@6:
	mov	ax, [xe]
	sub	ax, [xa]
	js	@@e
	mov	ax, [ye]
	sub	ax, [ya]
	js	@@e
	inc	ax
	mov	[yd], ax

	mov	dx, 03ceh
	mov	ax, 0f01h
	out	dx, ax
	mov	ax, [daWriteMode]
	out	dx, ax
	mov	ax, [FColor16]
	xor	al, al
	out	dx, ax
	mov	al, 8
	out	dx, al
	inc	dx
	push	dx
	mov	ax, [ActivePSeg]
	mov	es, ax
	mov	ax, [ya]
	mul	[BytesPerLine]
	mov	bx, [xa]
	shr	bx, 3
	add	ax, bx
	mov	di, ax
	add	di, [ActivePOfs]

	mov	ax, [xa]
	shr	ax, 3
	mov	cx, [xe]
	shr	cx, 3
	sub	cx, ax
        mov     [xd], cx

        mov     dx, 0ff80h
	mov     cx, [xa]
	and     cx, 7
	shr     dh, cl
	mov     [LMask], dh
	mov     dx, 0ff80h
	mov     cx, [xe]
	and     cx, 7
	shr     dx, cl
	mov     [RMask], dl
	mov     si, [FillBase]
	mov     [FillLine], 8
	pop     dx

	cmp     [xd], 0
	jne     @@long

	mov     al, [LMask]
	and     al, [RMask]
	mov     [LMask], al
@@yls:
	mov     al, [LMask]
	and     al, [(Byte ds:si)]
	out     dx, al
;	mov     [(Byte es:di)], al	; warum zum Geier geht das nicht ???
	inc	[(Byte es:di)]
	add     si, 2
	dec     [FillLine]
	jnz     @@yls1
	mov     [FillLine], 8
	sub     si, 16
@@yls1:
	add     di, [BytesPerLine]
	dec     [yd]
	jnz     @@yls
	jmp     @@e
@@long:
	mov     bx, si
	dec     [xd]
@@yll:
	mov     si, di
	mov     al, [LMask]
	and     al, [(Byte ds:bx)]
	out     dx, al
	inc	[(Byte es:di)]
	inc	di
	mov     cx, [xd]
	or      cx, cx
	jz      @@yll1
	mov     al, [(Byte ds:bx)]
	out     dx, al
	rep     seges   stosb
@@yll1:
	mov     al, [RMask]
	and     al, [(Byte ds:bx)]
	out     dx, al
	inc	[(Byte es:di)]
	add     bx, 2
	dec     [FillLine]
	jnz     @@yll2
	sub     bx, 16
	mov     [FillLine], 8
@@yll2:
	add     di, [BytesPerLine]
	sub     di, [xd]
	dec     di
	dec     [yd]
	jnz     @@yll
@@e:
	ret

ENDP

ENDS

END