; TrueType: WriteFont
;
; Copr. 1994 Matthias Kppe

		TITLE	WriteFont

		JUMPS

		LOCALS	@@

	; publics

		PUBLIC	writefntLine

	; includes

		INCLUDE	scandef.asm
		INCLUDE	wfntdef.asm

	; Code Segment

CODE		SEGMENT BYTE PUBLIC

		ASSUME	CS: CODE

writefntLine	PROC NEAR
		ARG	y: WORD, x2: WORD, x1: WORD, ABitmap: DWORD = ArgSize
		push	bp
		mov	bp, sp
		les	si, ABitmap

	; Handle x

		mov	ax, x1
		mov     bx, x2

	; Clip x1

		or	ax, ax
		jns	@@1
		xor	ax, ax
@@1:
		cmp	ax, es:[si].TWriteFntBuf.ExtentX
		jge	@@0

	; Clip x2

		cmp	bx, es:[si].TWriteFntBuf.ExtentX
		jl	@@2
		mov	bx, es:[si].TWriteFntBuf.ExtentX
		dec	bx
@@2:
	; Left Mask and Pos

		mov	cl, al
		and	cl, 7
		mov	ch, 0FFh
		shr	ch, cl			; CH left mask
		shr	ax, 3
		mov	di, ax
		mul	es:[si].TWriteFntBuf.ExtentY	; AX offset

	; Right Mask and Pos

		mov     cl, bl
		shr	bx, 3
		mov	dx, 07F80h
		and	cl, 7
		shr	dx, cl
		mov	cl, dl			; CL right mask
		sub	bx, di			; BX byte count - 1
		jnz	SHORT @@3

		and	ch, cl			; intersect masks
@@3:

	; Handle y

		mov	di, y

		or	di, di
		js	@@0

		cmp	di, es:[si].TWriteFntBuf.ExtentY
		jge	@@0

		add	ax, di
		mov	dx, es:[si].TWriteFntBuf.ExtentY
		les	di, es:[si].TWriteFntBuf.Buffer
		add	di, ax

	; Write loop

		or	es:[di], ch		; store left mask
		or	bx, bx
		jz	SHORT @@0

		add	di, dx
@@4:
		dec	bx
		jz	SHORT @@5
		mov	BYTE PTR es:[di], 0FFh
		add	di, dx
		jmp	@@4
@@5:
		or	es:[di], cl
@@0:
		pop	bp
		ret	ArgSize
writeFntLine	ENDP

CODE		ENDS

		END
