
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Stefan Milius                }
{                                                       }
{*******************************************************}

(* To run this program you'll have to build EXAM.GVL by:

   GVLC exam.gvl english.gvs englishx.gvs exam.gvs

   Hint: If you want another than the English language just translate all
   the texts in the GVS files into this language and then rebuild EXAM.GVL!
   (Germans only have to translate exam.gvs)


This application shows:

   - how to use client windows
   - does not really run at the moment

*)

Uses Dos, Objects, MetaGr, Drivers, KeyNames, ExtGraph, MyFonts, GVViews,
     GVMenus, GVApp, GVTexts, GVClient;

const

{ Commands }

  cmNew = 100;

{ HelpCtx }

  hcWindow = 3000;

type

{ TDemoWindow object }

  PDemoWindow = ^TDemoWindow;
  TDemoWindow = object(TWindow)
    constructor Init(Bounds: TRect; WinTitle: String; WindowNo: Word);
  end;

{ TInterior object }

  PInterior = ^TInterior;
  TInterior = object(TGView)
    constructor Init(var Bounds: TRect);
    procedure Draw; virtual;
  end;

{ TDemoApp object }

  TDemoApp = object(TApplication)
               procedure HandleEvent(var Event: TEvent); virtual;
               procedure InitStatusLine; virtual;
               function LanguageResource: String; virtual;
             end;

(***************************** TInterior object *****************************)

constructor TInterior.Init(var Bounds: TRect);
begin
  TGView.Init(Bounds);
  GrowMode := gfGrowHiX + gfGrowHiY;
end;

procedure TInterior.Draw;
const
  Greeting: string = 'Hello, World!';
begin
  SetFillStyle (SolidFill, GetColor(21));
  Bar (0,0, Size.X-1, Size.Y-1);
  SetTextParams(ftSansSerif, 0, GetColor(19), false);
  SetTextJustify(LeftText, TopText);
  OutTextXY(20, 35, Greeting);
end;

(*************************** TDemoWindow object *****************************)

constructor TDemoWindow.Init(Bounds: TRect; WinTitle: String; WindowNo: Word);
var
  Interior: PInterior;
begin
  TWindow.Init(Bounds, WinTitle, wnNoNumber);
  Flags := Flags and not wfBackground;
  GetExtent(Bounds);
  GetClientRect(Bounds);
  Interior := New(PInterior, Init(Bounds));
  Insert(Interior);
end;


(******************************** TDemoApp object ***************************)

procedure TDemoApp.HandleEvent(var Event: TEvent);
var Num: Byte;

  procedure NewWindow;
  var R: TRect;
      W: PParentWindow;
  Begin
    R.Assign(0, 0, GMinWinSize.X + Random(200), GMinWinSize.Y + Random(200));
    R.Move(Random(200), Random(200));
    W := New(PParentWindow, Init(R, GetStr(745), wnJustANumber,
    NewMenu(
      NewSubMenu(GetStr(507), hcWindow, NewMenu(
      StdWindowMenuItems(nil)), nil))));
    With W^ do Begin
      R.Assign(0, 0, 100, 100);
      R.Move(Random(100), Random(100));
      Insert(New(PDemoWindow, Init(R, GetStr(705), wnNoNumber)));
    End;
    W^.InsertIn(Desktop);
  End;

Begin
  inherited HandleEvent(Event);
  If (Event.What = evCommand) and (Event.Command = cmNew) then
    NewWindow;
End;

procedure TDemoApp.InitStatusLine;
var R: TRect;
Begin
  GetExtent(R);
  R.A.Y := R.B.Y - 21;
  StatusLine := New(PStatusLine, Init(R,
    StdDraggingStatusDef(
    NewStatusDef(0, $FFFF,
      NewStatusKeyKN(GetStr(600), kbAltX, cmQuit,
      NewStatusKeyKN(GetStr(613), kbF3, cmNew,
      NewStatusKey('', kbAltF3, cmClose,
      NewStatusKey('', kbCtrlF5, cmResize, nil)))),
    nil))));
End;

function TDemoApp.LanguageResource: String;
Begin
  LanguageResource := 'EXAM.GVL';
End;

var App: TDemoApp;

Begin
  Language := lfEnglish;
  App.Init;
  App.Run;
  App.Done;
End.
