
{*******************************************************}
{                                                       }
{       Graphics Vision Unit                            }
{                                                       }
{	Portions copyright (c) 1992 Borland Intl.       }
{       Copyright (c) 1994 Stefan Milius                }
{	Copyright (c) 1997 Matthias Koeppe              }
{                                                       }
{*******************************************************}

unit Dos;

{$ifndef Windows}
' This is not the original DOS unit of the Runtime Lib.  '
' It only contains a few definitions for use with the    '
' Windows version of Graphics Vision. Remove the path to '
' this source from your unit search path if you want to  '
' compile for DOS or DPMI target.                        '
{$endif}

interface

uses WinTypes, WinDos;

const

{ Flags bit masks }

  FCarry     = $0001;
  FParity    = $0004;
  FAuxiliary = $0010;
  FZero      = $0040;
  FSign      = $0080;
  FOverflow  = $0800;

{ File mode magic numbers }

  fmClosed = $D7B0;
  fmInput  = $D7B1;
  fmOutput = $D7B2;
  fmInOut  = $D7B3;

{ File attribute constants }

  ReadOnly  = $01;
  Hidden    = $02;
  SysFile   = $04;
  VolumeID  = $08;
  Directory = $10;
  Archive   = $20;
  AnyFile   = $3F;

type

{ String types }

  ComStr  = string[127];        { Command line string }
  PathStr = string[79];         { File pathname string }
  DirStr  = string[67];         { Drive and directory string }
  NameStr = string[8];          { File name string }
  ExtStr  = string[4];          { File extension string }

{ Search record used by FindFirst and FindNext }

  SearchRec = record
		Fill: array[1..21] of Byte;
		Attr: Byte;
		Time: Longint;
		Size: Longint;
		Name: string[12];
	      end;

{ Rename WinDos data structures }

  DateTime = TDateTime;
  TextRec = TTextRec;
  FileRec = TFileRec;
  TextBuf = TTextBuf;

function FExpand(Path: PathStr): PathStr;
procedure FindFirst(Path: PathStr; Attr: Word; var F: SearchRec);
procedure FindNext(var F: SearchRec);
function FSearch(Path: PathStr; DirList: String): PathStr;
procedure FSplit(Path: PathStr; var Dir: DirStr;
  var Name: NameStr; var Ext: ExtStr);
function GetEnv(EnvVar: String): String;
procedure Exec(Path: PathStr; ComLine: ComStr);
function DosExitCode: Word;

const
  ExecCmdShow: Word = sw_Show;
  ExecWait: Boolean = false;

{ Registers record used by Intr and MsDos }
type
  Registers = record
                case Integer of
                  0: (AX,BX,CX,DX,BP,SI,DI,DS,ES,Flags: Word);
                  1: (AL,AH,BL,BH,CL,CH,DL,DH: Byte);
              end;

implementation

uses WinProcs, Strings;

function FExpand(Path: PathStr): PathStr;
begin
  Path[Length(Path) + 1] := #0;
  Path[0] := Chr(StrLen(FileExpand(@Path[1], @Path[1])));
  FExpand := Path
end;

procedure FindFirst(Path: PathStr; Attr: Word; var F: SearchRec);
var
  l: Integer;
begin
  Path[Length(Path) + 1] := #0;
  WinDos.FindFirst(@Path[1], Attr, TSearchRec(F));
  l := StrLen(@F.Name);
  Move(F.Name, F.Name[1], 12);
  F.Name[0] := Chr(l);
end;

procedure FindNext(var F: SearchRec);
var
  l: Integer;
begin
  WinDos.FindNext(TSearchRec(F));
  l := StrLen(@F.Name);
  Move(F.Name, F.Name[1], 12);
  F.Name[0] := Chr(l);
end;

function FSearch(Path: PathStr; DirList: String): PathStr;
var
  Res: string;
begin
  Path[Length(Path)+1] := #0;
  DirList[Length(DirList)+1] := #0;
  FileSearch(@Res[1], @Path[1], @DirList[1]);
  Res[0] := Chr(StrLen(@Res[1]));
  FSearch := Res
end;

procedure FSplit(Path: PathStr; var Dir: DirStr;
  var Name: NameStr; var Ext: ExtStr);
begin
  Path[Length(Path)+1] := #0;
  FileSplit(@Path[1], @Dir[1], @Name[1], @Ext[1]);
  Dir[0] := Chr(StrLen(@Dir[1]));
  Name[0] := Chr(StrLen(@Name[1]));
  Ext[0] := Chr(StrLen(@Ext[1]));
end;

function GetEnv(EnvVar: String): String;
var
  v: PChar;
begin
  EnvVar[Length(EnvVar)+1] := #0;
  v := GetEnvVar(@EnvVar[1]);
  If v = nil
  then GetEnv := ''
  else GetEnv := StrPas(v)
end;

var ExitCode: Word;

procedure Exec(Path: PathStr; ComLine: ComStr);
var
  CmdLine: array[0..512] of Char;
  Module: THandle;
  Usage: Integer;
begin
  StrPCopy(CmdLine, Path);
  StrCat(CmdLine, ' ');
  StrPCopy(StrEnd(CmdLine), ComLine);
  Module := WinExec(CmdLine, ExecCmdShow);
  if Module < 32
  then ExitCode := 1 {Error}
  else begin
    If ExecWait
    then begin
      Usage := GetModuleUsage(Module);
      repeat
        Yield;
      until GetModuleUsage(Module) < Usage;
    end;
    ExitCode := 0
  end;
end;

function DosExitCode: Word;
begin
  DosExitCode := ExitCode
end;

end.

