; MetaGraph main part
; Copyright 1994,96 by Daniel Mahrenholz
; last modified 05/05/1996


INCLUDE	grdef.asm
INCLUDE metagr.def

IDEAL

INCLUDE "metagr.str"		; data structures
INCLUDE "metagr.con"		; global constants
INCLUDE "metaglob.inc"		; global symbols

extrn	MemAllocSeg	: far

SEGMENT	code byte public
	assume cs: code, ds: data

P386

locals	@@

MASM

INCLUDE	grserv.asm

def_mapping32

IDEAL

INCLUDE	"metagr.mac"

extrn	CallFreeMem	: near
extrn	ChMetaParams	: far
extrn	Save		: near
extrn	SetLineStyle	: far
extrn	SetMetaClipRect : near
extrn	DefaultErrorProc: far
extrn	SaveRegs	: near
extrn	RestoreRegs	: near

IDEAL

PROC	PutPixel far
PUBLIC	PutPixel

	ARG	aColor: Byte : 2, y1: Word, x1: Word = ArgSize
	push	bp
	mov	bp, sp

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@1
	call	SaveRegs
@@1:
ENDIF

	mov	ch, [aColor]
	push	offset (@@2)
	mov	ax, [(TPoint DrawOrigin).x]
	mov	bx, [(TPoint DrawOrigin).y]
	add	[x1], ax
	add	[y1], bx
	push	[y1] [x1] cx
	jmp	M_Point
@@2:

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@3
	call	RestoreRegs
@@3:
ENDIF

	pop	bp
	ret     ArgSize

ENDP

PROC 	GetPixel far
PUBLIC	GetPixel

	ARG	y1: Word, x1: Word = ArgSize
	push	bp
	mov	bp, sp

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@1
	call	SaveRegs
@@1:
ENDIF

	push	offset (@@2)
	mov	ax, [(TPoint DrawOrigin).x]
	mov	bx, [(TPoint DrawOrigin).y]
	add	[x1], ax
	add	[y1], bx
	push	[y1] [x1]
	jmp	M_GetP
@@2:

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@3
	push	ax
	call	RestoreRegs
	pop	ax
@@3:
ENDIF

	pop	bp
	ret	ArgSize

ENDP

PROC	HoriLine far
PUBLIC	HoriLine

	ARG	x2: Word, y1: Word, x1: Word = ArgSize
	push	bp
	mov	bp, sp

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@1
	call	SaveRegs
@@1:
ENDIF

	mov	ax, [x1]
	cmp	ax, [x2]
	jl	@@2
	xchg	ax, [x2]
	mov	[x1], ax
@@2:
	push	offset(@@3)

IFDEF	uDrawOrigin
	mov	ax, [(TPoint DrawOrigin).x]
	mov	bx, [(TPoint DrawOrigin).y]

	add	[x1], ax
	add	[y1], bx
	add	[x2], ax
ENDIF
	push	[x1] [x2] [y1]
	jmp	M_HL
@@3:

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@4
	call	RestoreRegs
@@4:
ENDIF

	pop	bp
	ret     ArgSize

ENDP

PROC	VertLine far
PUBLIC	VertLine

	ARG	y2: Word, y1: Word, x1: Word = ArgSize
	push	bp
	mov	bp, sp

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@1
	call	SaveRegs
@@1:
ENDIF

	mov	ax, [y1]
	cmp	ax, [y2]
	jl	@@2
	xchg	ax, [y2]
	mov	[y1], ax
@@2:
	push	offset (@@3)

IFDEF	uDrawOrigin
	mov	ax, [(TPoint DrawOrigin).x]
	mov	bx, [(TPoint DrawOrigin).y]
	add	[y1], bx
	add	[y2], bx
	add	[x1], ax
ENDIF
	push	[y2] [y1] [x1]
	jmp	M_VL
@@3:

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@4
	call	RestoreRegs
@@4:
ENDIF

	pop	bp
	ret	ArgSize

ENDP

PROC	Line far
PUBLIC	Line

	ARG	y2: Word, x2: Word, y1: Word, x1: Word = ArgSize
	push	bp
	mov	bp, sp

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@1
	call	SaveRegs
@@1:
ENDIF

	push	offset (@@2)

IFDEF	uDrawOrigin
	mov	ax, [(TPoint DrawOrigin).x]
	mov	bx, [(TPoint DrawOrigin).y]
	add	[x1], ax
	add	[x2], ax
	add	[y1], bx
	add	[y2], bx
ENDIF
	push	[x2] [x1] [y2] [y1]
	jmp	M_Line
@@2:

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@3
	call	RestoreRegs
@@3:
ENDIF

	pop	bp
	ret	ArgSize

ENDP

PROC 	MoveTo far
PUBLIC	MoveTo

	ARG	y1: Word, x1: Word = ArgSize
	push	bp
	mov	bp, sp

	mov	ax, [x1]
	mov	[last_x], ax
	mov	ax, [y1]
	mov	[last_y], ax
	pop	bp
	ret	ArgSize

ENDP

PROC	MoveRel far
PUBLIC	MoveRel

	ARG	y1: Word, x1: Word = ArgSize
	push	bp
	mov	bp, sp

	mov	ax, [x1]
	add	[last_x], ax
	mov	ax, [y1]
	add	[last_y], ax
	pop	bp
	ret	ArgSize

ENDP

PROC	LineTo far
PUBLIC	LineTo

	ARG	y1: Word, x1: Word = ArgSize
	push	bp
	mov	bp, sp

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@1
	call	SaveRegs
@@1:
ENDIF

	mov	ax, [last_x]
	mov	bx, [x1]
	mov	[last_x], bx
	mov	cx, [last_y]
	mov	dx, [y1]
	mov	[last_y], dx
	cmp	ax, bx
	jl	@@2
	xchg	ax, bx
	xchg	cx, dx
@@2:
	push	offset (@@3)

IFDEF	uDrawOrigin
	add	ax, [(TPoint DrawOrigin).x]
	add	bx, [(TPOint DrawOrigin).x]
	add	cx, [(TPoint DrawOrigin).y]
	add	dx, [(TPoint DrawOrigin).y]
ENDIF

	push	bx ax dx cx
	jmp	M_Line
@@3:

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@4
	call	RestoreRegs
@@4:
ENDIF

	pop	bp
	ret	ArgSize

ENDP

PROC	LineRel far
PUBLIC	LineRel

	ARG	y1: Word, x1: Word = ArgSize
	push	bp
	mov	bp, sp

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@1
	call	SaveRegs
@@1:
ENDIF

	mov	ax, [last_x]
	mov	bx, ax
	add	bx, [x1]
	mov	[last_x], bx
	mov	cx, [last_y]
	mov	dx, cx
	add	dx, [y1]
	mov	[last_y], dx
	cmp	ax, bx
	jl	@@2
	xchg	ax, bx
	xchg	cx, dx
@@2:
	push	offset (@@3)

IFDEF	uDrawOrigin
	add	ax, [(TPoint DrawOrigin).x]
	add	bx, [(TPoint DrawOrigin).x]
	add	cx, [(TPoint DrawOrigin).y]
	add	dx, [(TPoint DrawOrigin).y]
ENDIF

	push	bx ax dx cx
	jmp	M_Line
@@3:

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@4
	call	RestoreRegs
@@4:
ENDIF

	pop	bp
	ret	ArgSize

ENDP

PROC	Rectangle far
PUBLIC	Rectangle

	ARG	y2: Word, x2: Word, y1: Word, x1: Word = ArgSize
	push	bp
	mov	bp, sp

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@1
	call	SaveRegs
@@1:
ENDIF

	mov	ax, [x1]
	cmp	ax, [x2]
	jl	@@2
	xchg	ax, [x2]
	mov	[x1], ax
@@2:
	mov	ax, [y1]
	cmp	ax, [y2]
	jl	@@3
	xchg	ax, [y2]
	mov	[y1], ax
@@3:

IFDEF	uDrawOrigin
	mov	ax, [(TPoint DrawOrigin).x]
	mov	bx, [(Tpoint DrawOrigin).y]
	add	[x1], ax
	add	[x2], ax
	add	[y1], bx
	add	[y2], bx
ENDIF

	push	offset(@@4) [x1] [x2] [y1]
	jmp	M_HL
@@4:
	mov	ax, [y2]
	cmp	ax, [y1]
	je	@@5
	push	offset(@@6) [x1] [x2] [y2]
	jmp	M_HL
@@6:
	mov	ax, [y2]
	sub	ax, [y1]
	cmp	ax, 1
	jng	@@5
	inc	[y1]
	dec	[y2]
	push	offset(@@7) [y2] [y1] [x1]
	jmp	M_VL
@@7:
	push	offset(@@5) [y2] [y1] [x2]
	jmp	M_VL
@@5:
IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@8
	call	RestoreRegs
@@8:
ENDIF

	pop	bp
	ret	ArgSize

ENDP

PROC	Bar far
PUBLIC	Bar

	ARG	y2: Word, x2: Word, y1: Word, x1: Word = ArgSize
	push	bp
	mov	bp, sp

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@1
	call	SaveRegs
@@1:
ENDIF

	mov	ax, [x1]
	cmp	ax, [x2]
	jl	@@2
	xchg	ax, [x2]
	mov	[x1], ax
@@2:
	mov	ax, [y1]
	cmp	ax, [y2]
	jl	@@3
	xchg	ax, [y2]
	mov	[y1], ax
@@3:

IFDEF	uDrawOrigin
	mov	ax, [(TPoint DrawOrigin).x]
	mov	bx, [(TPoint DrawOrigin).y]
	add	[x1], ax
	add	[x2], ax
	add	[y1], bx
	add	[y2], bx
ENDIF

	push	offset(@@4) [x1] [x2] [y1] [y2]
	jmp	M_Bar
@@4:

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@5
	call	RestoreRegs
@@5:
ENDIF

	pop	bp
	ret	ArgSize

ENDP

PROC	D_Circle near

	test	[MetaState], ms_Record
	jz	@@1
	metafile	3, @@1
@@2:
	add	sp, 6
	retn
@@1:
	test	[MetaState], ms_Draw
	jz	@@2

	pop	cx
	pop	ax
	pop	bx

	push	bp
	mov	bp, sp

	LOCAL	r, d, xp, yp, cp1x, cp1y, cp2x, cp2y, cp3x, cp3y, \
		cp4x, cp4y, re, xF: DWord, yF: DWord, oldMetaState = LocalSize
	sub	sp, LocalSize

	mov	dx, [MetaState]
	mov	[oldMetaState], dx
	and	[MetaState], not ms_Record

	mov	[r], bx
	mov	[xp], 0
	mov     [yp], bx


IFDEF	uMetaOrigin
	add	ax, [(TPoint MetaOrigin).x]
	add	cx, [(TPoint MetaOrigin).y]
ENDIF

	mov	[cp1x], ax

	mov	[cp2x], ax
	add	[cp2x], bx

	mov	[cp3x], ax

	mov	[cp4x], ax
	sub	[cp4x], bx

	mov	[cp1y], cx
	and	ebx, 0ffffh
	mov     eax, [SF]
	mul	ebx
	shrd	eax, edx, 16

	add	[cp1y], ax

	mov	[cp2y], cx

	mov	[cp3y], cx
	sub	[cp3y], ax

	mov	[cp4y], cx

	; SC: Punkte cp?x/cp?y testen und Clipping-Flags fr alle setzen


	push	offset (@@i1) [cp1y] [cp1x]
	jmp	[F_Point]
@@i1:
	push	offset (@@i2) [cp2y] [cp2x]
	jmp	[F_Point]
@@i2:
	push	offset (@@i6) [cp3y] [cp3x]
	jmp	[F_Point]
@@i6:
	push	offset (@@i7) [cp4y] [cp4x]
	jmp	[F_Point]
@@i7:


	; SC: Vor Ausfhrung F_Point Sprung Clipping-Flag testen

        mov     bx, [r]
	shl	bx, 1
	mov	[d], 3
	sub	[d], bx
	mov	ax, 46341		; SQRT(2)/2 *2^16
	mul	[r]
	shr	ax, 15
	add	dx, ax
	mov	[re], dx
	mov	[xF], 0
	mov	[yF], 0

@@xl:
	test	[D], 08000h
	jz	@@ydec

	mov	ax, [xp]
	shl	ax, 2
	add	ax, 2
	add	[D], ax
	jmp	@@xinc

@@ydec:
	mov	ax, [xp]
	sub	ax, [yp]
	shl	ax, 2
	add	ax, 6
	add	[D], ax
	dec	[yp]

	dec	[cp2x]
	inc	[cp4x]

	mov	eax, [SF]
	add	[yF], eax
	test	[yF], 00010000h
	jz	@@noydec

	dec	[cp1y]
	inc	[cp3y]
	and	[yF], 0ffffh

@@noydec:

	; SC: Nach jeder Vernderung entsprechende Richtung testen und Flags setzen

@@xinc:
	inc	[cp1x]
	dec	[cp3x]

	mov	eax, [SF]
	add	[xF], eax
	test	[xF], 00010000h
	jz	@@noxinc

	inc	[cp2y]
	dec	[cp4y]
	and	[xF], 0ffffh

@@noxinc:

	; SC: s. yinc

	; SC: Vor Ausfhrung FPoint Routine Clipping Flag testen

	push	offset (@@b1) [cp1y] [cp1x]
	jmp	[F_Point]
@@b1:
	push	offset (@@b5) [cp1y] [cp3x]
	jmp	[F_Point]
@@b5:
	push	offset (@@b2) [cp2y] [cp2x]
	jmp	[F_Point]
@@b2:
	push	offset (@@b6) [cp2y] [cp4x]
	jmp	[F_Point]
@@b6:
	push	offset (@@b4) [cp4y] [cp4x]
	jmp	[F_Point]
@@b4:
	push	offset (@@b8) [cp4y] [cp2x]
	jmp	[F_Point]
@@b8:
	push	offset (@@b3) [cp3y] [cp3x]
	jmp	[F_Point]
@@b3:
	push	offset (@@b7) [cp3y] [cp1x]
	jmp	[F_Point]
@@b7:

	inc	[xp]
	mov	ax, [re]
	cmp	ax, [xp]
	jne	@@xl

	mov	ax, [oldMetaState]
	mov	[MetaState], ax

	leave
	ret

ENDP

PROC	Circle far
PUBLIC	Circle

	ARG	r: Word, ym: Word, xm: Word = ArgSize
	push	bp
	mov	bp, sp

        cmp     [r], 0
        je      @@e

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@1
	call	SaveRegs
@@1:
ENDIF
	test	[r], 08000h
	jz	@@2
	neg	[r]
@@2:

IFDEF	uDrawOrigin
	mov	ax, [(TPoint DrawOrigin).x]
	mov	bx, [(TPoint DrawOrigin).y]
	add	[xm], ax
	add	[ym], bx
ENDIF

	cmp	[r], 1
	jne	@@3
	push	offset(@@4) [ym] [xm]
	jmp	[F_Point]
@@3:
	push	offset(@@4) [r] [xm] [ym]
	jmp	D_Circle

@@4:

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@5
	call	RestoreRegs
@@5:
ENDIF

@@e:
	pop	bp
	ret	ArgSize

ENDP

PROC	D_FillCircle near

	test	[MetaState], ms_Record
	jz	@@1
	metafile	3, @@1
@@2:
	add	sp, 6
	retn
@@1:
	test	[MetaState], ms_Draw
	jz	@@2

	HL_Fill
	pop	cx
	pop	ax
	pop	bx

	push	bp
	mov	bp, sp

	LOCAL	r, d, xp, yp, cp1x, cp1y, cp2x, cp2y, cp3x, cp3y, \
		cp4x, cp4y, hlx1, hlx2, hlx3, hlx4, re, xF: DWord, \
		yF: DWord, L1, L2, L3, L4, Last = LocalSize
	sub	sp, LocalSize

	mov	[r], bx
	mov	[xp], 0
	mov     [yp], bx

	; SC: MetaOrigin dazu

	mov	[cp1x], ax

	mov	[cp2x], ax
	add	[cp2x], bx

	mov	[cp3x], ax

	mov	[cp4x], ax
	sub	[cp4x], bx

	mov	[cp1y], cx
	and	ebx, 0ffffh
	mov     eax, [SF]
	mul	ebx
	shrd	eax, edx, 16

	add	[cp1y], ax
	mov	di, [cp1y]
	mov	[L1], di

	mov	[cp2y], cx
	mov	[L2], cx

	mov	[cp3y], cx
	sub	[cp3y], ax
	mov	di, [cp3y]
	mov	[L3], di

	mov	[cp4y], cx
	mov	[L4], cx

	; SC: Punkte cp?x/cp?y testen und Clipping-Flags fr alle setzen


	push	offset (@@i1) [cp1y] [cp1x]
	jmp	[F_Point]
@@i1:
	push	offset (@@i2) [cp2y] [cp2x]
	jmp	[F_Point]
@@i2:
	push	offset (@@i6) [cp3y] [cp3x]
	jmp	[F_Point]
@@i6:
	push	offset (@@i7) [cp4y] [cp4x]
	jmp	[F_Point]
@@i7:
	push	offset (@@i8) [cp4x]
	inc	[Last-6]
	push	[cp2x]
	dec	[Last-8]
	push	[cp2y]
	jmp	M_HL
@@i8:


	; SC: Vor Ausfhrung F_Point Sprung Clipping-Flag testen

	mov	bx, [yp]
	shl	bx, 1
	mov	[d], 3
	sub	[d], bx
	mov	ax, 46341		; SQRT(2)/2 *2^16
	mul	[r]
	shr	ax, 15
	add	dx, ax

	inc	dx			; test

	mov	[re], dx
	mov	[xF], 0
	mov	[yF], 0

@@xl:
	test	[D], 08000h
	jz	@@ydec

	mov	ax, [xp]
	shl	ax, 2
	add	ax, 2
	add	[D], ax
	jmp	@@xinc

@@ydec:
	mov	ax, [xp]
	sub	ax, [yp]
	shl	ax, 2
	add	ax, 6
	add	[D], ax
	dec	[yp]

	dec	[cp2x]
	inc	[cp4x]

	mov	eax, [SF]
	add	[yF], eax
	test	[yF], 00010000h
	jz	@@noydec

	dec	[cp1y]
	inc	[cp3y]
	and	[yF], 0ffffh
	mov	si, [cp1y]
	cmp	[L2], si
	je	@@e
	push	offset (@@hl1)
	mov	[L1], si
	push	[cp3x]
	push	[cp1x]
	push	[cp1y]
	jmp	M_HL
@@hl1:
	push	offset (@@hl2)
	push	[cp3x]
	push	[cp1x]
	push	[cp3y]
	jmp	M_HL
@@hl2:

@@noydec:

	; SC: Nach jeder Vernderung entsprechende Richtung testen und Flags setzen

@@xinc:
	inc	[cp1x]
	dec	[cp3x]

	mov	eax, [SF]
	add	[xF], eax
	test	[xF], 00010000h
	jz	@@noxinc

	inc	[cp2y]
	dec	[cp4y]
	and	[xF], 0ffffh
	mov	si, [cp2y]
	cmp	[L1], si
	je	@@e
	mov	[L2], si
	push	offset (@@hl3)
	push	[cp4x]
	inc	[Last-6]
	push	[cp2x]
	dec	[Last-8]
	push	[cp2y]
	jmp	M_HL
@@hl3:
	push	offset (@@hl4)
	push	[cp4x]
	inc	[Last-6]
	push	[cp2x]
	dec	[Last-8]
	push	[cp4y]
	jmp	M_HL
@@hl4:


@@noxinc:

	; SC: s. yinc

	; SC: Vor Ausfhrung FPoint Routine Clipping Flag testen

	push	offset (@@b1) [cp1y] [cp1x]
	jmp	[F_Point]
@@b1:
	push	offset (@@b5) [cp1y] [cp3x]
	jmp	[F_Point]
@@b5:
	push	offset (@@b2) [cp2y] [cp2x]
	jmp	[F_Point]
@@b2:
	push	offset (@@b6) [cp2y] [cp4x]
	jmp	[F_Point]
@@b6:
	push	offset (@@b4) [cp4y] [cp4x]
	jmp	[F_Point]
@@b4:
	push	offset (@@b8) [cp4y] [cp2x]
	jmp	[F_Point]
@@b8:
	push	offset (@@b3) [cp3y] [cp3x]
	jmp	[F_Point]
@@b3:
	push	offset (@@b7) [cp3y] [cp1x]
	jmp	[F_Point]
@@b7:

	mov	ax, [cp2y]
	inc	ax
	cmp	ax, [cp1y]
	jge	@@e

	inc	[xp]
	mov	ax, [re]
	cmp	ax, [xp]
	jne	@@xl

@@e:
	HL_draw
	leave
	ret

ENDP


PROC	FillCircle far
PUBLIC	FillCircle

	ARG	r: Word, ym: Word, xm: Word = ArgSize
	push	bp
	mov	bp, sp

	cmp     [r], 0
	je      @@e

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@1
	call	SaveRegs
@@1:
ENDIF

	test	[r], 08000h
	jz	@@2
	neg	[r]
@@2:

IFDEF	uDrawOrigin
	mov	ax, [(TPoint DrawOrigin).x]
	mov	bx, [(TPoint DrawOrigin).y]
	add	[xm], ax
	add	[ym], bx
ENDIF

	cmp	[r], 1
	jne	@@3
	push	offset(@@4) [ym] [xm]
	jmp	[F_Point]
@@3:
	push	offset(@@4) [r] [xm] [ym]
	jmp	D_FillCircle

@@4:

IFDEF	uBGI
	test	[MetaState], ms_BGI
	jz	@@5
	call	RestoreRegs
@@5:
ENDIF

@@e:
	pop	bp
	ret	ArgSize

ENDP

PROC	ClearDevice far
PUBLIC	ClearDevice

	cmp	[MGCMode], cm16
	jne	@@2
	mov	dx, 03ceh
	mov	ax, 0f01h
	out	dx, ax
	mov	ax, 3
	out	dx, ax
	xor	ax, ax
	out	dx, ax
	mov	ax, 0ff08h
	out	dx, ax
	mov	ax, [ActivePSeg]
	mov	es, ax
	xor	di, di
	mov	cx, 8000h
	xor	ax, ax
	cld
	rep	stosw
@@2:
	cmp	[MGCMode], cm256
	jne	@@e
	xor	eax, eax
	call	MapLinear32
	mov	es, dx
	mov	edi, eax

	mov	bx, [EndSeg]
	xor	eax, eax
@@3:
	mov	ecx, [WindowSize32]
	shr	ecx, 2
	rep	stosd
	dec	bx
	jz	@@e
	call	NextWindow32
	jmp	@@3
@@e:
	ret

ENDP

PROC	ClearPage far
PUBLIC	ClearPage

	cmp	[MGCMode], cm16
	jne	@@1

	mov	dx, 03ceh
	mov	ax, 0f01h
	out	dx, ax
	mov	ax, 3
	out	dx, ax
	xor	ax, ax
	out	dx, ax
	mov	ax, 0ff08h
	out	dx, ax
	mov	ax, [ActivePSeg]
	mov	es, ax
	mov	di, [ActivePOfs]
	mov	ax, [SizeY]
	mul	[BytesPerLine]
	mov	cx, ax
	xor	ax, ax
	rep	stosb
	jmp	@@e
@@1:
	cmp	[MGCMode], cm256
	jne	@@e

	mov	eax, [ActiveLinear32]
	call	MapLinear32
	mov	es, dx
	mov	edi, eax
	xor	eax, eax
	mov	bx, [SizeY]
@@2:
	mov	ecx, [BytesPerLine32]
	DoRepDest edi, [WindowSize32],,,DWord,stos,,dx,edx
	dec	bx
	jnz	@@2
@@e:
	ret

ENDP


PROC	InitData near
PUBLIC	InitData

	jmp	@@1
	db	'MetaGraph copyright 1994, 96 by Daniel Mahrenholz'
@@1:
	xor	eax, eax
	mov	[ErrorProc], eax
	mov	[MetaStack], eax
	ret

ENDP

PROC	DoNormal16Mode near

	mov	ax, [MetaState]
	and	ax, ms_Record
	jz	@@1
	metafile	0, @@1
	retn
@@1:
	mov	[MGCMode], cm16
	mov	[F_Point], SMALL offset (F_Point16)
	mov	[daWriteMode], 0003h
	mov	[P_VL], SMALL offset (P_VL_16M)
	mov	[P_HL], SMALL offset (P_HL_16C)
	mov	[P_Bar], SMALL offset (P_Bar_16c)
	mov	[P_Point], SMALL offset (P_Point_16M)
	mov	[P_GetP], SMALL offset (P_GetP_16M)
	mov	[P_Line], SMALL offset (P_Line_16M)
	mov	[P_LineD], SMALL offset (P_Line_16M)
	ret

ENDP

PROC	DoXor16Mode near

	mov	ax, [MetaState]
	and	ax, ms_Record
	jz	@@1
	metafile	0, @@1
	retn
@@1:
	mov	[MGCMode], cm16
	mov	[F_Point], SMALL offset (F_Point16)
	mov	[daWriteMode], 1803h
	mov	[P_VL], SMALL offset (P_VL_16M)
	mov	[P_HL], SMALL offset (P_HL_16M)
	mov	[P_Bar], SMALL offset (P_Bar_16M)
	mov	[P_Point], SMALL offset (P_Point_16M)
	mov	[P_GetP], SMALL offset (P_GetP_16M)
	mov	[P_LineD], SMALL offset (P_Line_16M)
	mov	[P_Line], SMALL offset (P_Line_16M)
	ret

ENDP

PROC	DoAnd16Mode near

	mov	ax, [MetaState]
	and	ax, ms_Record
	jz	@@1
	metafile	0, @@1
	retn
@@1:
	mov	[MGCMode], cm16
	mov	[F_Point], SMALL offset (F_Point16)
	mov	[daWriteMode], 8003h
	mov	[P_VL], SMALL offset (P_VL_16M)
	mov	[P_HL], SMALL offset (P_HL_16M)
	mov	[P_Bar], SMALL offset (P_Bar_16M)
	mov	[P_Point], SMALL offset (P_Point_16M)
	mov	[P_GetP], SMALL offset (P_GetP_16M)
	mov	[P_Line], SMALL offset (P_Line_16M)
	mov	[P_LineD], SMALL offset (P_Line_16M)
	ret

ENDP

PROC	DoOr16Mode near

	mov	ax, [MetaState]
	and	ax, ms_Record
	jz	@@1
	metafile	0, @@1
	retn
@@1:
	mov	[MGCMode], cm16
	mov	[F_Point], SMALL offset (F_Point16)
	mov	[daWriteMode], 1003h
	mov	[P_VL], SMALL offset (P_VL_16M)
	mov	[P_HL], SMALL offset (P_HL_16M)
	mov	[P_Bar], SMALL offset (P_Bar_16M)
	mov	[P_Point], SMALL offset (P_Point_16M)
	mov	[P_GetP], SMALL offset (P_GetP_16M)
	mov	[P_Line], SMALL offset (P_Line_16M)
	mov	[P_LineD], SMALL offset (P_Line_16M)
	ret

ENDP

PROC	DoNormal256Mode near

	mov	ax, [MetaState]
	and	ax, ms_Record
	jz	@@1
	metafile	0, @@1
	retn
@@1:
	mov	[MGCMode], cm256
	mov	[F_Point], SMALL offset (F_Point256)
	mov	[P_VL], SMALL offset (P_VL_256mov)
	mov	[P_HL], SMALL offset (P_HL_256stos)
	mov	[P_Bar], SMALL offset (P_Bar_256stos)
	mov	[P_Point], SMALL offset (P_Point_256mov)
	mov	[P_GetP], SMALL offset (P_GetP_256)
	mov	[P_Line], SMALL offset (P_Line_256mov)
	mov	[P_LineD], SMALL offset (P_Line_256mov)
	ret

ENDP

PROC	DoXor256Mode near

	mov	ax, [MetaState]
	and	ax, ms_Record
	jz	@@1
	metafile	0, @@1
	retn
@@1:
	mov	[MGCMode], cm256
	mov	[F_Point], SMALL offset (F_Point256)
	mov	[P_VL], SMALL offset (P_VL_256xor)
	mov	[P_HL], SMALL offset (P_HL_256xors)
	mov	[P_Bar], SMALL offset (P_Bar_256xors)
	mov	[P_Point], SMALL offset (P_Point_256xor)
	mov	[P_GetP], SMALL offset (P_GetP_256)
	mov	[P_Line], SMALL offset (P_Line_256xor)
	mov	[P_LineD], SMALL offset (P_Line_256xor)
	ret

ENDP

PROC	DoAnd256Mode near

	mov	ax, [MetaState]
	and	ax, ms_Record
	jz	@@1
	metafile	0, @@1
	retn
@@1:
	mov	[MGCMode], cm256
	mov	[F_Point], SMALL offset (F_Point256)
	mov	[P_VL], SMALL offset (P_VL_256and)
	mov	[P_HL], SMALL offset (P_HL_256ands)
	mov	[P_Bar], SMALL offset (P_Bar_256ands)
	mov	[P_Point], SMALL offset (P_Point_256and)
	mov	[P_GetP], SMALL offset (P_GetP_256)
	mov	[P_Line], SMALL offset (P_Line_256and)
	mov	[P_LineD], SMALL offset (P_Line_256and)
	ret

ENDP

PROC	DoOr256Mode near

	mov	ax, [MetaState]
	and	ax, ms_Record
	jz	@@1
	metafile	0, @@1
	retn
@@1:
	mov	[MGCMode], cm256
	mov	[F_Point], SMALL offset (F_Point256)
	mov	[P_VL], SMALL offset (P_VL_256or)
	mov	[P_HL], SMALL offset (P_HL_256ors)
	mov	[P_Bar], SMALL offset (P_Bar_256ors)
	mov	[P_Point], SMALL offset (P_Point_256or)
	mov	[P_GetP], SMALL offset (P_GetP_256)
	mov	[P_Line], SMALL offset (P_Line_256or)
	mov	[P_LineD], SMALL offset (P_Line_256or)
	ret

ENDP


PROC	DoNDMode near

	mov	ax, [MetaState]
	and	ax, ms_Record
	jz	@@1
	metafile	0, @@1
	retn
@@1:
	mov	[MGCMode], cm0
	mov	[P_VL], SMALL offset (P_VL_nD)
	mov	[P_HL], SMALL offset (P_HL_nD)
	mov	[P_Bar], SMALL offset (P_Bar_nD)
	mov	[P_Point], SMALL offset (P_Point_nD)
	mov	[P_GetP], SMALL offset (P_GetP_nD)
	mov	[P_Line], SMALL offset (P_Line_nD)
	mov	[P_LineD], SMALL offset (P_Line_nD)
	ret

ENDP


PROC	SelectGDriver far
PUBLIC	SelectGDriver

	ARG	WriteMode: Word, ColorMode: Word = ArgSize
	push	bp
	mov	bp, sp

	cmp	[ColorMode], cm16
	jne	@@10
	cmp	[WriteMode], NormalPut
	jne	@@1
	call	DoNormal16Mode
	jmp	@@e
@@1:
	cmp	[WriteMode], XorPut
	jne	@@2
	call	DoXor16Mode
	jmp	@@e
@@2:
	cmp	[WriteMode], OrPut
	jne	@@3
	call	DoOr16Mode
	jmp	@@e
@@3:
	cmp	[WriteMode], AndPut
	jne	@@e
	call	DoAnd16Mode
@@4:
	jmp	@@e
@@10:
	cmp 	[ColorMode], cm256
	jne	@@11
	cmp	[WriteMode], NormalPut
	jne	@@5
	call	DoNormal256Mode
	jmp	@@e
@@5:
	cmp	[WriteMode], XorPut
	jne	@@6
	call	DoXor256Mode
	jmp	@@e
@@6:
	cmp	[WriteMode], AndPut
	jne	@@7
	call	DoAnd256Mode
	jmp	@@e
@@7:

	cmp	[WriteMode], OrPut
	jne	@@e
	call	DoOr256Mode
	jmp	@@e
@@11:
	cmp	[ColorMode], cm0
	jne	@@e
	call	DoNDMode
@@e:
	pop	bp
	ret     ArgSize

ENDP

PROC	InitMetaGr far
PUBLIC	InitMetaGr

	mov	eax, [MetaStack]
	or	eax, eax
	jnz     @@1
	push	65520
	call	far ptr MemAllocSeg
	mov	[(word MetaStack+2)], dx
	mov	[(word MetaStack)], ax
@@1:
	mov	[ValidStack], 1
	or	ax, dx
	jnz	@@2
	mov	[ValidStack], 0
	mov	ax, me_Stack
	call	DefaultErrorProc
@@2:
	ret

ENDP

PROC	DoneMetaGr far
PUBLIC	DoneMetaGr

	mov	ax, [(word MetaStack)]
	mov	bx, [(word MetaStack+2)]
	mov	cx, ax
	or	cx, bx
	jz	@@1
	mov	cx, 65520
	push	bx ax cx
	call	CallFreeMem
	mov	[MetaStack], 0
	mov	[ValidStack ], 0
@@1:
	ret

ENDP

PROC	WaitHRetrace far
PUBLIC	WaitHRetrace

	mov	dx, 03dah
@@1:
	in	al, dx
	test	al, 1
	jnz	@@1
@@2:
	in	al, dx
	test	al, 1
	jz	@@2

	ret

ENDP

PROC	WaitDispEnable far
PUBLIC	WaitDispEnable

	mov	dx, 03dah
@@1:
	in	al, dx
	test	al, 1
	jnz	@@1

	ret

ENDP

PROC	WaitDispDisable far
PUBLIC	WaitDispDisable

	mov	dx, 03dah
@@1:
	in	al, dx
	test	al, 1
	jz	@@1

	ret

ENDP

PROC    DispState far
PUBLIC  DispState

        mov      dx, 03dah
        in       al, dx
        and      ax, 1

        ret
ENDP

PROC	WaitVRetrace far
PUBLIC	WaitVRetrace

	mov	dx, 03dah
@@1:
	in	al, dx
	test	al, 8
	jnz	@@1
@@2:
	in	al, dx
	test	al, 8
	jz	@@2

	ret

ENDP

PROC	VRetrace far
PUBLIC	VRetrace

	mov	dx, 03dah
        in	al, dx
        shr	ax, 3
        and	ax, 1

        ret

ENDP

PROC	WaitHLine far
PUBLIC	WaitHLine

	ARG	HLine : Word = RetSize

        push	bp
        mov	bp, sp

        mov	cx, [HLine]
        mov	dx, 03dah

@@1:
	in	al, dx
        and	ax, 8
        jz	@@1

@@2:
	in	al, dx
        and	al, 1
        jz	@@2
@@3:
	in	al, dx
        and	al, 1
        jnz	@@3

        dec	cx
        jnz	@@2

        pop	bp

        ret	RetSize

ENDP

PROC	AssignVideoSeg far
PUBLIC	AssignVideoSeg

	mov	ax, [ActivePSeg]
	mov	fs, ax

	ret

ENDP

ENDS

END