
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Stefan Milius                }
{                                                       }
{*******************************************************}

(* To run this program you'll have to build EXAM.GVL by:

   GVLC exam.gvl english.gvs englishx.gvs exam.gvs

   Hint: If you want another than the English language just translate all
   the texts in the GVS files into this language and then rebuild EXAM.GVL!
   (Germans only have to translate exam.gvs)


This application shows:

   - usage of the unique GV clock
   - usage of desktop eyes
   - local menus
   - gadgets

*)

Uses Objects, Drivers, KeyNames, GVViews, GVMenus, GVApp,
     GVTexts, GVGadget, GVEyes, GVMsgBox, GVClock;

const

{ Commands }

  cmClock = 100; cmEyes = 101; cmAltEyes = 102;

{ HelpCtx }

  hcWindow = 100;

type

  TDemoApp = object(TApplication)
               constructor Init;
               procedure HandleEvent(var Event: TEvent); virtual;
               procedure Idle; virtual;
               procedure InitStatusLine; virtual;
               function LanguageResource: String; virtual;
             private
               Heap: PHeapView;
               Clock: PClockView;
             end;

(******************************** TDemoApp object ***************************)

constructor TDemoApp.Init;
var R: TRect;
Begin
  inherited Init;
  R.Assign (Main^.Size.X-162, -1, Main^.Size.X-80, 21);
  Heap:=New (PHeapView, Init (R));
  If Heap<>nil then PGView(Main^.Insert(Heap))^.GrowMode := gfGrowHiX + gfGrowLoX;
  R.Assign (Main^.Size.X-81, -1, Main^.Size.X+1, 21);
  Clock:=New (PClockView, Init (R));
  If Clock<>nil then PGView(Main^.Insert(Clock))^.GrowMode := gfGrowHiX + gfGrowLoX;
End;

procedure TDemoApp.HandleEvent(var Event: TEvent);

  procedure NewEyes(DesktopEyes: Boolean);
  const Inf: Boolean = true;
  var
    R: TRect;
    i: Integer;
  begin
    R.Assign(0, 0, GMinWinSize.X + Random(200), GMinWinSize.Y + Random(200));
    R.Move(Random(200), Random(200));
    If not DesktopEyes then
      InsertWindow(New(PEyeWindow, Init(R)))
    Else Begin
      If Inf then Begin
        MessageBox(GetStr(744), nil, mfInformation+mfOkButton);
        Inf := false;
      End;
      Desktop^.Insert(New(PDesktopEyes, Init(R)))
    End;
  end;

  procedure NewClock;
  var
    R: TRect;
    Window: PWindow;
  begin
    R.Assign(0, 0, GMinWinSize.X + Random(200), GMinWinSize.Y + Random(200));
    R.Move(Random(200), Random(200));

    Window := New(PStandardClockWindow, Init(R, clmAnalog, nil));
    Window^.HelpCtx := hcWindow;
    InsertWindow(Window)
  end;

Begin
  inherited HandleEvent(Event);
  If Event.What = evCommand then
    Case Event.Command Of
      cmClock: NewClock;
      cmEyes: NewEyes(false);
      cmAltEyes: NewEyes(true);
    End
End;

procedure TDemoApp.Idle;
Begin
  inherited Idle;
  If Heap <> nil then Heap^.UpDate;
  If Clock <> nil then Clock^.UpDate;
End;

procedure TDemoApp.InitStatusLine;
var R: TRect;
Begin
  Main^.GetExtent(R);
  R.A.Y := R.B.Y - 21;
  StatusLine := New(PStatusLine, Init(R,
    NewStatusDef(0, 0,
      NewStatusKeyKN(GetStr(600), kbAltX, cmQuit,
      NewStatusKeyKN(GetStr(616), kbF3, cmClock,
      NewStatusKeyKN(GetStr(617), kbF4, cmEyes,
      NewStatusKeyKN(GetStr(618), kbAltF4, cmAltEyes,
      NewStatusKey('', kbAltF3, cmClose,
      NewStatusKey('', kbCtrlF5, cmResize,
      NewStatusKey('', kbF5, cmZoom, nil))))))),
    NewStatusDef (2, 499,
      NewStatusKeyKN (GetStr(606),kbAltF3,cmClose,
      NewStatusKeyKN (GetStr(607),kbCtrlF5,cmResize,
      NewStatusKeyKN (GetStr(608),kbAltF10, 0,
      NewStatusKey('', kbAltX, cmQuit,
      NewStatusKey('', kbF3, cmClock,
      NewStatusKey('', kbF4, cmEyes,
      NewStatusKey('', kbAltF4, cmAltEyes, nil))))))),
    StdDraggingStatusDef(
    nil)))));
End;

function TDemoApp.LanguageResource: String;
Begin
  LanguageResource := 'EXAM.GVL';
End;

var App: TDemoApp;

Begin
  Language := lfEnglish;
  App.Init;
  App.Run;
  App.Done;
End.
