unit GvCmd;

{ Graphics Vision standard command codes,
  for use with Resource Workshop,
  Copr. 1996 Matthias K"oppe
}

interface

const
{ Standard command codes }

  cmValid   = 0;
  cmQuit    = 1;
  cmError   = 2;
  cmMenu    = 3;
  cmClose   = 4;
  cmZoom    = 5;
  cmResize  = 6;
  cmNext    = 7;
  cmPrev    = 8;
  cmHelp    = 9;

{ TDialog standard commands }

  cmOK      = 10;
  cmCancel  = 11;
  cmYes     = 12;
  cmNo      = 13;
  cmDefault = 14;

{ Application command codes }

  cmCut     = 20;
  cmCopy    = 21;
  cmPaste   = 22;
  cmUndo    = 23;
  cmClear   = 24;
  cmTile    = 25;
  cmCascade = 26;
  cmAltTile = 27;

{ GVApp commands }

  cmNew       = 30;
  cmOpen      = 31;
  cmSave      = 32;
  cmSaveAs    = 33;
  cmSaveAll   = 34;
  cmChangeDir = 35;
  cmDosShell  = 36;
  cmCloseAll  = 37;

{ GVEdit commands }

  cmFind        = 82;
  cmReplace     = 83;
  cmSearchAgain = 84;
  cmGotoLine    = 85;

{ cmXXXX -> hcXXXX relocation }

  hc = 1000;

implementation

end.
