unit Misc;

{ unit Misc
  Copr. 1993,1998 Matthias Koeppe

  $Id: misc.pas 1.5 1999/02/09 11:27:59 mkoeppe Exp $
 
  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Library General Public
  License as published by the Free Software Foundation; either
  version 2 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Library General Public License for more details.

  You should have received a copy of the GNU Library General Public
  License along with this library; if not, write to the Free
  Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
}

{$ifndef FPK}
{$A+,B-,F-,G+,O-,R-,S-,X+}
{$endif}

interface

{$ifdef FPK}
uses Objects, Dos, GvFPK;
{$else}
{$ifdef Windows}
uses Objects, WinDos, Dos, WinTypes, WinProcs;
{$else}
uses Objects, Dos;

{ Standard error stream, automatically opened on start-up
}
var
  StdErr: Text;

{ ReadValue liest den Wert des Bezeichners Id im Abschnitt Section einer
  geffneten INI-Datei F, die im Format von Microsoft Windows
  vorliegt.
}
function ReadValue(var F: TStream; Section, Id: string): string;
{$endif Windows}
{$endif FPK}

{ GetWinDir versucht, das Verzeichnis von Microsoft Windows zu
  finden.
}
function GetWinDir: DirStr;

{ GetWinFontDir versucht, das Font-Verzeichnis zu finden
}
function GetWinFontDir: DirStr;

{ GetBGIDir versucht, das BGI-Verzeichnis zu finden.
}
function GetBGIDir: DirStr;

{ FirstFile sucht im Verzeichnis Dir die erste Datei, die in der Dateiliste
  Files aufgefhrt ist.
}
function FirstFile(Files: string; Dir: DirStr): PathStr;

{ Drive type detection
}
const
  dtInvalid = 0;
  dtFloppy = 1;
  dtHardDisk = 2;
  dtRamDrive = 3;
  dtNetDrive = 4;
  dtSubstDrive = 5;
  dtCDROM = 6;

function GetDriveType(Drive: Char): Byte;

{ Canonicalize filename or path
}
{$ifndef VER60}
function Canonicalize(var FName: PathStr): string;
function Relativate(FName: PathStr): string;
{$endif}

{$ifndef FPK}
{$ifndef Windows}
{ Undokumentierte Routinen.
}
function SeekForLine(var F: TStream; s, h: string): string;
function ReadLine(var F: TStream): string;
function Matches(shorter, longer:string):Boolean;
{$endif}
{$endif}

implementation

{$ifdef FPK}
uses Strings;
{$else}
{$ifndef VER60}
uses Strings
{$ifdef DPMI}
	    , WinAPI
{$endif}            ;
{$endif}
{$endif}

{$ifndef FPK}
{$ifndef Windows}
{ INI- Routinen
}
function SeekForLine;
var
  Line: string;
  halted: Boolean;
Begin
  Repeat
    Line := ReadLine(F);
    halted := (F.Status <> 0) or Matches(h, Line);
  Until halted or Matches(s, Line);
  If halted
    then Begin F.Reset; SeekForLine := '' End
    else SeekForLine := Line;
End;

function ReadLine;
var
  s: string;
  x: char;
Begin
  s[0] := #0;
  Repeat
    F.Read(x, 1);
    If x <> #13
    then Begin s[Length(s) + 1] := x; Inc(s[0]) End
  Until (F.Status <> 0) or (x = #13);
  F.Read(x, 1);
  ReadLine := s;
End;

function Matches; assembler;
Asm
	PUSH	DS
	LDS	SI, shorter
	LES	DI, longer
	MOV	CL, [SI]
	XOR	CH, CH
	MOV	AL, [ES:DI]
	CMP	CL, AL
	JA	@@3
	INC	SI
	INC	DI
@@2:	LODSB
	MOV	AH, [ES:DI]
	INC	DI
	CMP	AL, AH
	JZ	@@1
	CMP	AL, "A"
	JB	@@3
	CMP	AL, "z"
	JA	@@3
	AND	AX, 1F1FH
	CMP	AL, AH
	JNZ	@@3
@@1:	LOOP	@@2
	MOV	AX, 1
	JMP	@@4
@@3:	XOR	AX, AX
@@4:	POP	DS
End;

function ReadValue;
var
  s: string;
  P: Byte;
Begin
  ReadValue := '';
  If Section <> ''
    then Begin
      F.Seek(0);
      If Section[1] <> '['
	then Section := '['+Section;
      If SeekForLine(F, Section, ^Z) = '' then Exit
    End;
  s := SeekForLine(F, Id, '[');
  If s = '' then Exit;
  P := Pos('=', s);
  If P = 0 then Exit;
  ReadValue := Copy(s, P + 1, Length(s) - P)
End;
{$endif Windows}
{$endif FPK}

{ Weiteres
}
function GetWinDir: DirStr;
var
  s: PathStr;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
Begin
  s:=FSearch('WIN.INI', GetEnv('PATH') + ';C:\WINDOWS;C:\WINNT');
  FSplit(s, Dir, Name, Ext);
  GetWinDir := Dir;
End;

function GetWinFontDir: DirStr;
var
  SR: SearchRec;
  s: DirStr;
begin
  s := GetWinDir;
  FindFirst(s + 'FONTS', AnyFile, SR);
  If (DosError = 0) and (SR.Attr and Directory <> 0)
  then GetWinFontDir := s + 'FONTS\'	{ as in Win95 }
  else GetWinFontDir := s + 'SYSTEM\'	{ as in Win 3.x }
end;

function GetBGIDir: DirStr;
var
  DirList: string;
  Path: string;
  Dir: DirStr;
  Name: NameStr;
  Ext: ExtStr;
Begin
  DirList := GetEnv('PATH') + ';C:\TP\BGI;C:\TURBO\BGI;C:\BP\BGI;';
  Path := FSearch('..\BGI\EGAVGA.BGI', DirList);
  Path := FExpand(Path);
  FSplit(Path, Dir, Name, Ext);
  GetBgiDir := Dir;
End;

function FirstFile(Files: string; Dir: DirStr): PathStr;
var
  DirInfo: SearchRec;
  s: PathStr;
  i: Byte;
Begin
  Repeat
    i := Pos(';', Files);
    If i = 0
      then s := Files
      else Begin
	s := Copy(Files, 1, i-1);
	Delete(Files, 1, i)
      End;
    FindFirst(Dir + s, AnyFile, DirInfo);
  Until (i = 0) or (DosError = 0);
  If DosError <> 0
    then FirstFile := ''
    else FirstFile := Dir + DirInfo.Name
End;

{ DriveType detection
}

{$ifndef FPK}
{$ifndef Windows}
function DriveValid(Drive: Char): Boolean; near; assembler;
asm
	MOV	AH,19H          { Save the current drive in BL }
	INT	21H
	MOV	BL,AL
	MOV	DL,Drive	{ Select the given drive }
	SUB	DL,'A'
	MOV	AH,0EH
	INT	21H
	MOV	AH,19H		{ Retrieve what DOS thinks is current }
	INT	21H
	MOV	CX,0		{ Assume false }
	CMP	AL,DL		{ Is the current drive the given drive? }
	JNE	@@1
	MOV	CX,1		{ It is, so the drive is valid }
	MOV	DL,BL		{ Restore the old drive }
	MOV	AH,0EH
	INT	21H
@@1:	XCHG	AX,CX		{ Put the return value into AX }
end;

function IsCDRom(Drive: Char): Boolean; near; assembler;
asm
	mov	cl, Drive
	xor	ch, ch
	sub	cl, 'A'
{$ifdef DPMI}
	mov	ax, ds
	mov	es, ax
	mov	di, OFFSET RealModeRegs
	xor	ax, ax
	mov     [di][22h], ax	{es}
	mov	[di][24h], ax	{ds}
	mov	[di][0], ax	{di}
	mov	[di][4], ax     {si}
	mov	[di][2eh], ax	{sp}
	mov	[di][30h], ax	{ss}
	mov	[di][18h].word, cx
	mov	[di][1ch].word, 150Bh {ax}
	mov	ax, 0300h
	mov	bx, 002Fh
	mov	cx, 0
	int	31h
	mov	ax, [di][1ch].word
	mov	bx, [di][10h].word
{$else}
	mov	ax, 150BH
	int	2FH
{$endif}
	or	ax, ax
	jz	@@0
	mov	al, 0
	cmp	bx, 0ADADH
	jnz	@@0
	mov	al, 1
@@0:
end;

function IsFixed(Drive: Char): Boolean; near; assembler;
asm
	mov	ax, 4408H
	mov	bl, Drive
	sub	bl, 'A' - 1
	int	21H
	jnc	@@0
	mov	al, 1		{ On error assume it's fixed }
@@0:
end;

function IsRemote(Drive: Char): Boolean; near; assembler;
asm
	mov	ax, 4409H
	mov	bl, Drive
	sub	bl, 'A' - 1
	int	21H
	mov	al, 0		{ Assume it's not remote }
	jc	@@0
	shr	dx, 12		{ Get bit 12 }
	mov	al, dl
	and	al, 1
@@0:
end;

function IsSubst(Drive: Char): Boolean; near; assembler;
asm
	mov	ax, 4409H
	mov	bl, Drive
	sub	bl, 'A' - 1
	int	21H
	mov	al, 0		{ Assume it's not remote }
	jc	@@0
	shr	dx, 15		{ Get bit 15 }
	mov	al, dl
	and	al, 1
@@0:
end;

function IsRam(Drive: Char): Boolean; near; assembler;
asm
	mov	ah, 32h
	mov	dl, Drive
	sub	dl, "A" - 1
	push	ds
	int	21h
	or	al, al
	jnz	@@1

	mov	al, [bx+8]
	cmp	al, 1
	jz	@@0
@@1:
	mov	al, 0
@@0:
	pop	ds
end;
{$endif Windows}
{$endif FPK}

function GetDriveType(Drive: Char): Byte;
begin
  {$ifdef FPK}
  GetDriveType := dtHardDisk;
  {$else}
  {$ifdef Windows}
  case WinProcs.GetDriveType(Ord(Drive) - Ord('A')) of
    1:
      GetDriveType := dtInvalid;
    Drive_Removable:
      GetDriveType := dtFloppy;
    Drive_Remote:
      GetDriveType := dtNetDrive;
    else
      GetDriveType := dtHardDisk;
  end;
  {$else !Windows}
  GetDriveType := dtInvalid;
  if DriveValid(Drive) then
    if IsSubst(Drive) then GetDriveType := dtSubstDrive else
    if IsCDROM(Drive) then GetDriveType := dtCDROM else
    if IsRemote(Drive) then GetDriveType := dtNetDrive else
    if IsFixed(Drive) then
      if IsRAM(Drive)
      then GetDriveType := dtRAMDrive
      else GetDriveType := dtHardDisk else
    GetDriveType := dtFloppy
  {$endif !Windows}
  {$endif}
end;

{$ifndef VER60}
function Canonicalize(var FName: PathStr): string;
{$ifndef FPK}
var
  buffer: LongInt;
  Name: PChar;
{$endif} 
begin
{$ifdef FPK}
  Canonicalize := FName;
{$else}
  FName[Length(FName) + 1] := #0;
{$ifdef DPMI}
  buffer := GlobalDOSAlloc(128);
  Name := Ptr(buffer, 0);
{$else}
  GetMem(Name, 128);
{$endif}
  StrPCopy(Name, FName);
{$ifdef DPMI}
  asm
	mov	ax, ds
	mov	es, ax
	mov	di, OFFSET RealModeRegs
	mov	ax, buffer.word.2
	mov     [di][22h], ax	{es}
	mov	[di][24h], ax	{ds}
	xor	ax, ax
	mov	[di][0], ax	{di}
	mov	[di][4], ax     {si}
	mov	[di][2eh], ax	{sp}
	mov	[di][30h], ax	{ss}
	mov	[di][1ch].word, 6000h {ax}
	mov	ax, 0300h
	mov	bx, 0021h
	mov	cx, 0
	int	31h
  end;
{$else}
  asm
	push	ds
	lds	si, Name
	les	di, Name
	mov	ah, 60h
	int	21h
	pop	ds
  end;
{$endif}
  Canonicalize := StrPas(Name);
{$endif}
end;

function Relativate(FName: PathStr): string;
var
  CurDir: PathStr;
begin
  FName := Canonicalize(FName);
  GetDir(0, CurDir); CurDir := Canonicalize(CurDir);
  If CurDir[Length(CurDir)] = '\' then Dec(CurDir[0]);
  { look up in current drive }
  If Copy(FName, 1, Length(CurDir)) = CurDir
  then Relativate := Copy(FName, Length(CurDir) + 2, Length(FName) - Length(CurDir) - 1)
  else begin
    if FName[2] = ':'
    then begin
      { look up in specified drive }
      GetDir(Byte(FName[1]) - Byte('@'), CurDir); CurDir := Canonicalize(CurDir);
      If CurDir[Length(CurDir)] = '\' then Dec(CurDir[0]);
      If Copy(FName, 1, Length(CurDir)) = CurDir
      then Relativate := Copy(FName, 1, 2) + Copy(FName, Length(CurDir) + 1, Length(FName) - Length(CurDir))
      else begin
	CurDir := Copy(FName, 1, 2) + '\';
	CurDir := Canonicalize(CurDir);
	If CurDir[Length(CurDir)] = '\' then Dec(CurDir[0]);
	Relativate := Copy(FName, 1, 2) + Copy(FName, Length(CurDir) + 1, Length(FName) - Length(CurDir))
      end
    end
    else
      Relativate := FName
  end
end;
{$endif}

{$ifndef FPK}
{$ifndef Windows}
begin
  Assign(StdErr, '');
  Rewrite(StdErr);
  with TextRec(StdErr) do
    Handle := 2;
{$endif Windows}
{$endif FPK}
end.
