{
   *********************************************************************
   Version: 1998.06.09
   Copyright (C) 1997, 1998 Gertjan Schouten

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
   *********************************************************************
}
unit colors;

interface

const
   Red     = $FF0000;
   Green   = $00FF00;
   Blue    = $0000FF;
   Cyan    = Green xor Blue;
   Yellow  = Red xor Green;
   Magenta = Red xor Blue;
   Black   = Cyan xor Yellow xor Magenta;
   White   = Red xor Green xor Blue;
   Gray    = $7F7F7F;
   DefaultPalette: array[0..255] of Longint = (
   $000000, $000070, $007000, $007070, $700000, $700070, $704800, $C4C4C4,
   $343434, $0000FC, $24FC24, $00FCFC, $FC1414, $B000FC, $FCFC24, $FCFCFC,
   $000000, $000000, $000000, $000000, $000000, $000000, $000000, $000000,
   $000000, $000000, $000000, $000000, $000000, $000000, $000000, $000000,
   $000000, $000000, $000000, $000000, $000000, $000000, $000000, $000000,
   $000000, $330000, $660000, $990000, $CC0000, $FF0000, $003300, $333300,
   $663300, $993300, $CC3300, $FF3300, $006600, $336600, $666600, $996600,
   $CC6600, $FF6600, $009900, $339900, $669900, $999900, $CC9900, $FF9900,
   $00CC00, $33CC00, $66CC00, $99CC00, $CCCC00, $FFCC00, $00FF00, $33FF00,
   $66FF00, $99FF00, $CCFF00, $FFFF00, $000033, $330033, $660033, $990033,
   $CC0033, $FF0033, $003333, $333333, $663333, $993333, $CC3333, $FF3333,
   $006633, $336633, $666633, $996633, $CC6633, $FF6633, $009933, $339933,
   $669933, $999933, $CC9933, $FF9933, $00CC33, $33CC33, $66CC33, $99CC33,
   $CCCC33, $FFCC33, $00FF33, $33FF33, $66FF33, $99FF33, $CCFF33, $FFFF33,
   $000066, $330066, $660066, $990066, $CC0066, $FF0066, $003366, $333366,
   $663366, $993366, $CC3366, $FF3366, $006666, $336666, $666666, $996666,
   $CC6666, $FF6666, $009966, $339966, $669966, $999966, $CC9966, $FF9966,
   $00CC66, $33CC66, $66CC66, $99CC66, $CCCC66, $FFCC66, $00FF66, $33FF66,
   $66FF66, $99FF66, $CCFF66, $FFFF66, $000099, $330099, $660099, $990099,
   $CC0099, $FF0099, $003399, $333399, $663399, $993399, $CC3399, $FF3399,
   $006699, $336699, $666699, $996699, $CC6699, $FF6699, $009999, $339999,
   $669999, $999999, $CC9999, $FF9999, $00CC99, $33CC99, $66CC99, $99CC99,
   $CCCC99, $FFCC99, $00FF99, $33FF99, $66FF99, $99FF99, $CCFF99, $FFFF99,
   $0000CC, $3300CC, $6600CC, $9900CC, $CC00CC, $FF00CC, $0033CC, $3333CC,
   $6633CC, $9933CC, $CC33CC, $FF33CC, $0066CC, $3366CC, $6666CC, $9966CC,
   $CC66CC, $FF66CC, $0099CC, $3399CC, $6699CC, $9999CC, $CC99CC, $FF99CC,
   $00CCCC, $33CCCC, $66CCCC, $99CCCC, $CCCCCC, $FFCCCC, $00FFCC, $33FFCC,
   $66FFCC, $99FFCC, $CCFFCC, $FFFFCC, $0000FF, $3300FF, $6600FF, $9900FF,
   $CC00FF, $FF00FF, $0033FF, $3333FF, $6633FF, $9933FF, $CC33FF, $FF33FF,
   $0066FF, $3366FF, $6666FF, $9966FF, $CC66FF, $FF66FF, $0099FF, $3399FF,
   $6699FF, $9999FF, $CC99FF, $FF99FF, $00CCFF, $33CCFF, $66CCFF, $99CCFF,
   $CCCCFF, $FFCCFF, $00FFFF, $33FFFF, $66FFFF, $99FFFF, $CCFFFF, $FFFFFF);

var
   Palette: array[0..255] of Longint;

function RGB(RedValue, GreenValue, BlueValue: word):longint;

function EncodeColor8(rgb:longint):longint;
function EncodeColor15(rgb:longint):longint;
function EncodeColor24(rgb:longint):longint;

function DecodeColor8(color:longint):longint;

function BrightenColor8(color:longint;light:longint):longint;
function BrightenColor15(color:longint;light:longint):longint;
function BrightenColor24(color:longint;light:longint):longint;

procedure setDefaultPalette(ofs: integer);
procedure setRGBPalette(index: word; color: longint);
procedure setRGBPalette(index, RedValue, GreenValue, BlueValue:word);
procedure setRGBPalette(value: pointer);

implementation

var
   VID_Palette: pointer;                               // pointer to array of 256 longints
   VID_IlluminateTable: array[0..255, 0..255] of byte; // [color, light]
   VID_ExposeTable: array[0..255, 0..255] of byte;     // [color, light]
   VID_IntensifyTable: array[0..255,0..255] of byte;   // [color, light]

   VID_Color12to8: Pointer; // indexcolor := VID_Color12to8[r shl 8 + g shl 4 + b];
   VID_ITable8: Pointer;
   VID_ITable15: Pointer;
   VID_ITable24: Pointer;

type
   LongintArray = array[0..0] of longint;
   ByteArray = array[0..0] of byte;

function  EncodeColor24(rgb: longint):longint; Assembler;
asm
   movl  rgb,%eax
end ;

function  EncodeColor15(rgb: longint):longint; Assembler;
asm
   movl   rgb,%eax
   shrb   $3,%ah
   shrl   $3,%eax
   shlw   $6,%ax
   shrl   $6,%eax
end ;

Function  EncodeColor8(rgb: longint): longint; Assembler;
asm
   movl    rgb, %edx            // 00000000 RRRRrrrr GGGGgggg BBBBbbbb
   shll    $4, %edx             // 0000RRRR rrrrGGGG ggggBBBB bbbb0000
   shlw    $4, %dx              // 0000RRRR rrrrGGGG BBBBbbbb 00000000
   shrl    $12, %edx            // 00000000 00000000 RRRRrrrr GGGGBBBB
   shrb    $4, %dh              // 00000000 00000000 0000RRRR GGGGBBBB
   andl    $4095, %edx          //
   addl    _VID_COLOR12TO8, %edx
   movb    (%edx), %al
end ;

Function  RGB(RedValue, GreenValue, BlueValue : word):longint; Assembler;
asm
   movw   RedValue,%ax    // ------------------------RRRRRRRR
   shll   $16,%eax        // --------RRRRRRRR----------------
   movw   GreenValue,%ax  // --------RRRRRRRR--------RRRRRRRR
   shlw   $8,%ax          // --------RRRRRRRRGGGGGGGG--------
   movb   BlueValue,%al   // --------RRRRRRRRGGGGGGGGBBBBBBBB
end ;

procedure InitTables(ofs: integer);
var
   x, y, i: integer;
   c, l: longint;
   r, g, b: integer;
   a: byte;
begin
for r := 0 to 15 do for g := 0 to 15 do for b := 0 to 15 do begin
   ByteArray(vid_color12to8^)[(r shl 8) or (g shl 4) or b] :=
      ofs + (36 * trunc(b / 2.66666666)) + // Blue Lookup
            (6 * trunc(g / 2.66666666)) + // Green Lookup
            (trunc(r / 2.66666666)); // Red Lookup
   end ;
for y := 0 to 255 do begin
   c := Palette[y];
   for x := 0 to 255 do begin
      a := EncodeColor8(BrightenColor24(c, Palette[x]));
      ByteArray(VID_ITable8^)[x + y * 256] := a;
      end ;
   end ;
end ;

procedure SetDefaultPalette(ofs: integer);
var r, b, g, i: integer;
begin
if (ofs > 40) then ofs := 40;
for b := 0 to 5 do
   for g := 0 to 5 do
      for r := 0 to 5 do begin
         i := ofs + (36 * b) + (6 * g) + r;
         SetRGBpalette(i, rgb((r * 51), (g * 51), (b * 51)));
         end ;
InitTables(ofs);
end ;

procedure setRGBPalette(index: word; color: longint);Assembler;
asm
   xorl  %eax,%eax
   movw  index,%ax
   movw  $0x3c8,%dx
   outb  %al,%dx
   movl  _VID_PALETTE,%ebx
   shlw  $2,%ax
   addl  %eax,%ebx      
   movl  color,%eax
   movl  %eax,(%ebx)        //  00000000 RRRRRRRR GGGGGGGG BBBBBBBB
   andl  $0xFCFCFC,%eax     //  00000000 RRRRRR00 GGGGGG00 BBBBBB00
   shrl  $2,%eax            //  00000000 00RRRRRR 00GGGGGG 00BBBBBB
   movw  $0x3c9,%dx
   rorl  $16,%eax           //  00GGGGGG 00BBBBBB 00000000 00RRRRRR
   outb  %al,%dx
   roll  $8,%eax            //  00GGGGGG 00RRRRRR 00000000 00BBBBBB
   outb  %al,%dx
   roll  $8,%eax            //  00000000 00RRRRRR 00GGGGGG 00BBBBBB
   outb  %al,%dx
end ;

procedure setRGBPalette(index, RedValue, GreenValue, BlueValue:word);Assembler;
asm
   xorl  %eax,%eax
   movw  index,%ax
   movw  $0x3c8,%dx
   outb  %al,%dx
   movl  _VID_PALETTE,%ebx
   shlw  $2,%ax
   addl  %eax,%ebx
   movw  $0x3c9,%dx
   movb  RedValue,%al
   outb  %al,%dx
   shlb  $2,%al
   movb  %al,2(%ebx)
   movb  GreenValue,%al
   movb  %al,%ah
   outb  %al,%dx
   movb  BlueValue,%al
   outb  %al,%dx
   andw  $0xCFCF,%ax
   shlw  $2,%ax
   movw  %ax,(%ebx)
end ;

procedure setRGBPalette(value: pointer);
var i:longint;
begin
for i := 0 to 255 do
   setRGBPalette(i, LongintArray(value^)[i]);
end ;

Function DecodeColor8(color:longint):longint;Assembler;
asm
   movl    color,%ebx
   shll    $2,%ebx
   andl    $1023,%ebx
   addl    _VID_PALETTE,%ebx
   movl    (%ebx),%eax
end ;

function BrightenColor8(color:longint;light:longint):longint; Assembler;
asm
   pushl   light
   call    _COLORS$$_ENCODECOLOR8$LONGINT
   movl    _VID_ITABLE8,%edx
   movb    %al,%dl
   movb    color,%dh
   movb    (%edx),%al
end ;

function BrightenColor15(color:longint;light:longint):longint; Assembler;
// b := VID_ITable15[rgb and 31, (light shr 3) and 31];
// g := VID_ITable15[(rgb shr 5) and 31, (light shr 8) and 31];
// r := VID_ITable15[(rgb shr 10) and 31, (light shr 16) and 31];
asm
 	movl    _VID_ITABLE24,%edx

   movl    color,%ecx          // 00000000 00000000 0RRRRRGG GGGBBBBB
   andl    $0x7FFF,%ecx
   shll    $6,%ecx             // 00000000 000RRRRR GGGGGBBB BB000000
   shrw    $3,%cx              // 00000000 000RRRRR 000GGGGG BBBBB000
   shrb    $3,%cl              // 00000000 000RRRRR 000GGGGG 000BBBBB
   shll    $3,%ecx             // 00000000 RRRRR000 GGGGG000 BBBBB000

   movl    light,%ebx          // 00000000 00000000 0rrrrrgg gggbbbbb
                               // --- Blue ---
   movb    %cl,%dh
   movb    %bl,%dl
   movb    (%edx),%al          // 00000000 BBBBBBBB
                               // --- Green ---
   movb    %ch,%dh
   movb    %bh,%dl
	movb    (%edx),%ah          // GGGGGGGG BBBBBBBB
                               // --- Red ---
   shrl    $16,%ecx
   shrl    $16,%ebx
   movb    %cl,%dh
   movb    %bl,%dl
   movb    (%edx),%ch          // RRRRRRRR 00000000
   andw    $0xF800,%cx         // RRRRR000 00000000

   shrb    $3,%ah              // 000GGGGG BBBBBBBB
   shrw    $3,%ax              // 000000GG GGGBBBBB
   shrw    $1,%cx              // 0RRRRR00 00000000
   orw     %cx,%ax             // 0RRRRRGG GGGBBBBB
end ;

function BrightenColor24(color:longint;light:longint):longint; Assembler;
asm
   movl    _VID_ITABLE24,%edx
   movl    color,%eax        // BBBBBBBB GGGGGGGG RRRRRRRR ________
   movl    light,%ebx        // bbbbbbbb gggggggg rrrrrrrr ________
   movb    %al,%dh
   movb    %bl,%dl
   movb    (%edx),%al        // bbbbbbbb GGGGGGGG RRRRRRRR ________
   rorl    $8,%eax           // GGGGGGGG RRRRRRRR ________ bbbbbbbb
   shrl    $8,%ebx           // gggggggg rrrrrrrr ________ ________
   movb    %al,%dh
   movb    %bl,%dl
   movb    (%edx),%al        // gggggggg RRRRRRRR ________ bbbbbbbb
   movb    %ah,%dh
   movb    %bh,%dl
   movb    (%edx),%ah        // gggggggg rrrrrrrr ________ bbbbbbbb
   roll    $8,%eax           // bbbbbbbb gggggggg rrrrrrrr ________
end ;

procedure GetmemA(var p: pointer; Size, Align: Longint);
begin
Getmem(p, Size + Align);
if p <> nil then
   p := pointer(longint(p) and (1 - Align) + Align);
end ;

var
   i, x, y: integer;

begin
GetMem(VID_Color12to8, 4096);
GetMemA(VID_ITable24, 65536, 65536);
for y := 0 to 255 do for x := 0 to 255 do begin
   i := (y * x) div 256;
   if (i > 255) then i := 255
   else if (i < 0) then i := 0;
   ByteArray(VID_ITable24^)[y * 256 + x] := byte(i);
   end ;
GetMemA(VID_ITable8, 65536, 65536);
VID_Palette := @Palette;
move(DefaultPalette, Palette, 256 * SizeOf(Longint));
InitTables(40);
end .
