
{*******************************************************}
{                                                       }
{       Graphics Vision Example program                 }
{                                                       }
{       Copyright (c) 1996 Matthias K"oppe              }
{                                                       }
{*******************************************************}

{ $Id: exam0201.pas 1.4 1999/02/12 20:49:26 mkoeppe Exp $ }

(* This example shows:
   - how to open a Windows resource
   - how to load a menubar from a Windows resource
   - how to add accelerator keys to a loaded menubar

   We get our Windows resource from the exam.dll file.
   This `DLL' includes a resource which has been built from
   the gvsh.rc script.
*)

uses
  { Turbo Vision units }
  Objects, Drivers,
  { Graphics Vision units }
  GVViews, GVMenus, GVApp, GvMsgBox,
  { WinRes: Access to Windows resources }
  WinRes,
  { KeyNames: Provides language-specific key names (for AddAccelerators) }
  KeyNames,
  { Following is the symbol unit, which has been created with
    Resource Workshop. It includes identifiers for commands,
    help contexts and strings. }
  GvShCmd;

{ The resource we access
}
const
  ResourcePath = 'exam.dll';
var
  Res: PStream;

type
{ The application
}
  TDemoApp = object(TApplication)
    constructor Init;
    destructor Done; virtual;
    procedure InitMenuBar; virtual;
  end;

(***************************** TDemoApp object ******************************)

constructor TDemoApp.Init;
begin
  { Open the Windows resource.
  }
  Res := OpenResource(ResourcePath);
  If Res^.Status <> 0
  then begin
    PrintStr('Resource error.'^M^J);
    Halt(1)
  end;
  { Do the normal application start-up
  }
  inherited Init;
end;

destructor TDemoApp.Done;
begin
  inherited Done;
  { Close the Windows resource
  }
  Dispose(Res, Done);
end;

procedure TDemoApp.InitMenubar;
var
  R: TRect;
  Menu: PMenu;
  Acc: PAccelerators;
Begin
  { Load the menu structure from the resource.
    'Menu' is the identifying string for our menu resource.
    We assigned this string to the resource in the Resource Workshop.
  }
  Menu := LoadMenu(Res^, 'Menu', mo_GraphicsVision);
  { Load the accelerator table from the resource.
    'GV' is the identifying string.
  }
  Acc := LoadAccelerators(Res^, 'GV');
  { Add accelerator keys to the menu structure.
    The accelerator table is a look-up table, associating a virtual key
    with a command ID. AddAccelerators parses the Menu and adds both
    key code and key name to each item whose command is listed in the table.
  }
  AddAccelerators(Menu, Acc);
  { Get rid of the table.
  }
  FreeAccelerators(Acc);
  { Create the menubar.
  }
  Main^.GetExtent(R);
  R.B.Y := 21;
  MenuBar := New(PMenuBar, Init(R, Menu));
End;

var
  App: TDemoApp;

Begin
  App.Init;
  MessageBox('This app does nothing but has a nice menubar.',
    nil, mfInformation + mfOKButton);
  App.Run;
  App.Done
End.
