program DemoMyMousePackage;

{ Demonstriert die Mglichkeiten des MyMouse-Softwarepaketes.

  Hinweis: Obwohl dieses PROGRAMM eine Demonstration ist, ist das Software-
	   Paket vollstndig und uneingeschrnkt einsetzbar. Dieses Programm
  soll die Leistungsmerkmale und Mglichkeiten des Paketes vorstellen, da
  dies gegenber der Beschreibung die bessere Mglichkeit ist. }

{$A+,B-,F-,G+,O-,R-,S-,X+}

uses
  Crt, Dos, Gr, Graph, Bgi, Objects, Drivers, Memory,
  MyMouse, Misc, MyFonts, VGAMem

{$IFDEF exe}
, BgiFont
{$ENDIF}
;

(***************************************************************************)

procedure InitGr;
var
  d, m: Integer;
Begin
{$IFDEF Exe}
  RegisterBgiFont(@SmallFontProc);
  RegisterBgiFont(@SansSerifFontProc);
  RegisterBgiFont(@TriplexFontProc);
  RegisterBgiFont(@GothicFontProc);
{$ENDIF}
  SetGrMode(grVgaHiStd);
  If not InitGraphics then Begin
    WriteLn('Die Graphik kann nicht initialisiert werden. Bitte stellen Sie');
    WriteLn('sicher, da Ihre Hardware den Standard-VGA-Modus untersttzt.');
    WriteLn('ndern Sie eventuell den Pfad zu Ihrem Graphiktreiber');
    WriteLn('(EGAVGA.BGI).');
    Halt(1)
  End;
End;

procedure Out(X, Y: Integer; TextString: string);
Begin
  Graph.OutTextXY(X, Y, TextString)
End;

var
  Event: TEvent;
  R: Word;

procedure W;
Begin
  ShowMouse;
  Repeat
    GetMouseEvent(Event);
  until keypressed or (Event.What=evMouseDown);
  If keypressed then Readkey;
  HideMouse;
End;

(****************************** M Y M O U S E ******************************)

const
  mcInput = 50;
  mcHuge  = 51;

var
  SaveGetCursor: TGetMCProc;

procedure DoGetCursor(n: Integer); far; assembler;
Asm
	MOV	AX, n
	CMP	AX, mcInput
	MOV	SI, OFFSET @D50
	JZ	@@3
	CMP	AX, mcHuge
	MOV	SI, OFFSET @D51
	JNZ	@@1
@@3:	MOV	CursorNum, AX
	MOV	WORD PTR CursorPtr, SI
	MOV	WORD PTR CursorPtr+2, CS
	JMP	@@2
@D50:	DW	17, 2			{ Windows-Cursor "Text" }
	DW	3, 8
	DW	0000000000000000B	{ wird XOR draufgelegt }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1110111000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	0001000000000000B
	DW	1110111000000000B
@D51:	DW	64, 8			{ 64x64-Demo-Cursor }
	DW	32, 31

	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
	DW	0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0

	DW	1111111111111111B
	DW	1000000000000000B
	DW	1010000010000000B
	DW	1010000010000000B
	DW	1011000110000000B
	DW	1011000110011100B
	DW	1010101010000010B
	DW	1010101010011110B
	DW	1010010010100010B
	DW	1010010010100010B
	DW	1010000010011110B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1010000010001000B
	DW	1010000000000000B
	DW	1010000000000000B
	DW	1010010001110010B
	DW	1010100010001011B
	DW	1011000010001010B
	DW	1010100010001010B
	DW	1010010010001010B
	DW	1010001001110010B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000100B
	DW	1000000000000100B
	DW	1000000000000100B
	DW	1001100011100101B
	DW	1010010100010110B
	DW	1001000111110100B
	DW	1000100100000100B
	DW	1010010100010100B
	DW	1001100011100100B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1011111111111111B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000000B
	DW	1000000000000001B
	DW	1000000000000010B
	DW	1000000000000100B
	DW	1000000000001000B
	DW	1000000000010000B
	DW	1000000000100000B
	DW	1000000001000000B
	DW	1000000010000000B
	DW	1000000100000000B
	DW	1000001000000000B
	DW	1000010000000000B
	DW	1000100000000000B
	DW	1001000000000000B
	DW	1010000000000000B
	DW	1100000000000000B
	DW	1111111111111111B

	DW	1111111111111111B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1000100110011110B
	DW	1000101001000010B
	DW	1000100100000100B
	DW	1000100010001000B
	DW	1001101001010000B
	DW	0110100110011110B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1100101100011100B
	DW	0010110010100010B
	DW	0010100010111110B
	DW	0010100010100000B
	DW	0010100010100010B
	DW	0010100010011100B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1001100000000000B
	DW	0101000000000000B
	DW	0101000000000000B
	DW	0101000000000000B
	DW	0101000000000000B
	DW	0101000000011111B
	DW	0000000000001111B
	DW	0000000000000111B
	DW	1111100000001011B
	DW	0000000000010001B
	DW	0000000000100000B
	DW	0000000001000000B
	DW	0000000010000000B
	DW	0000000100000000B
	DW	0000001000000000B
	DW	0000010000000000B
	DW	0000100000000000B
	DW	0001000000000000B
	DW	0010000000000000B
	DW	0100000000000000B
	DW	1000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000001001B
	DW	0000000000001001B
	DW	0000000000001010B
	DW	0000000000001010B
	DW	0000000000000100B
	DW	0000000000000100B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1111111111111111B

	DW	1111111111111111B
	DW	0000000000000000B
	DW	0000001000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0111001001111001B
	DW	1000101010001010B
	DW	1111101010001011B
	DW	1000001010001010B
	DW	1000101010001010B
	DW	0111001001111001B
	DW	0000000000001000B
	DW	0000000011110000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1011000000000001B
	DW	1100100000000010B
	DW	1000100000000100B
	DW	1000100000001000B
	DW	1000100000010000B
	DW	1000100000100000B
	DW	0000000001000000B
	DW	0000000010000000B
	DW	0000000100000000B
	DW	0000001000000000B
	DW	0100010000000000B
	DW	0110100000000000B
	DW	0111000000000000B
	DW	0111100000000000B
	DW	0111110000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000011110B
	DW	0000000000100010B
	DW	0000000000100010B
	DW	0000000000100010B
	DW	0000000000100010B
	DW	0000000000011110B
	DW	0000000000000010B
	DW	0000000000111100B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0010011100110011B
	DW	0010100010100100B
	DW	1010111110100100B
	DW	1010100000100100B
	DW	0100100010100100B
	DW	0100011100100011B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	1111111111111111B

	DW	1111111111111111B
	DW	0000000000000011B
	DW	0000000000000101B
	DW	0000000000001001B
	DW	0000000000010001B
	DW	1100110000100001B
	DW	0010100001000001B
	DW	1110100010000001B
	DW	0000100100000001B
	DW	0010101000000001B
	DW	1100100000000001B
	DW	0000000000000001B
	DW	0001000000000001B
	DW	0010000000000001B
	DW	0100000000000001B
	DW	1000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000110001B
	DW	0000000001001001B
	DW	0000000001001001B
	DW	1100111001001001B
	DW	1001000101011001B
	DW	1001000101000101B
	DW	1001000101000101B
	DW	1001000101000101B
	DW	1000111001011001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0100000000000001B
	DW	0100000000000001B
	DW	0100000000000001B
	DW	1100111001011001B
	DW	0101000101100101B
	DW	0101111101000101B
	DW	0101000001000101B
	DW	0101000101000101B
	DW	1100111001000101B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	0000000000000001B
	DW	1111111111111111B
@@1:    PUSH	AX
	CALL	SaveGetCursor
@@2:
End;

{***** Anpassung an den Hintergrund *****}

var
  SaveCC: procedure;

procedure DoCC; far;
const
  R1: TRect = (A: (x: 160; y: 120); B: (x: 260; y: 220));
  R2: TRect = (A: (x: 290; y: 120); B: (x: 470; y: 140));
  R3: TRect = (A: (x: 141; y:  80); B: (x: 499; y: 100));
Begin
  If R1.Contains(MouseWhere) then NewNum := mcLargeCross else
  if R2.Contains(MouseWhere) then NewNum := mcInput else
  if R3.Contains(MouseWhere) then NewNum := mcCross else
  NewNum := mcStd
End;

procedure FillUp;
Begin
  Repeat
    SetColor(Random(16));
    HideMouse;
    Line(Random(100)+10, Random(100)+100, Random(100)+10, Random(100)+100);
    ShowMouse;
    GetMouseEvent(Event);
  Until (Event.What=evMouseDown) or keypressed;
  SetColor(15);
  If keypressed then ReadKey
End;

procedure BeginMyMouse;
Begin
  SetFillStyle(SolidFill, Blue);
  Bar(0, 0, 639, 185);
  Graph.SetTextJustify(CenterText, TopText);
  SetTextStyle(TriplexFont, 0, 6);
  Out(320, 0, 'Das MyMouse-Paket');
  SetTextStyle(TriplexFont, 0, 4);
  Out(320, 80, 'Eine Demonstration');
  Out(320, 140, 'Teil I: MyMouse, Version 1.5');
  SetTextStyle(SmallFont, 0, 6);
  Out(320, 200, 'Diesen Mauszeiger kennen Sie sicherlich.'); W;
  Out(320, 230, 'Oft erscheint es als sinnvoll, eine andere Zeigerform');
  Out(320, 250, 'zu verwenden. Das stellt kein Problem dar - es mssen');
  Out(320, 270, 'nur ein paar Interrupts aufgerufen werden.');
  Out(320, 300, 'Einerseits ist das eine etwas aufwendige Mglichkeit.');
  Out(320, 320, 'Vor allem aber stt man sehr schnell an die Grenzen');
  Out(320, 340, 'herkmmlicher Maustreiber: Sie untersttzen nur Zeiger');
  Out(320, 360, 'bis zu einer Gre von 16 x 16 Punkten - und das reicht');
  Out(320, 380, 'fr ansprechende Zeigerformen nicht aus.'); W;
  SetTextStyle(TriplexFont, 0, 4);
  SetColor(12);
  Out(320, 410, 'Doch jetzt gibt es MyMouse...'); W;
End;

procedure DemoMyMouse;
var
  i: Byte;
Begin
  Bar(0, 0, 639, 60);
  SetColor(15);
  Out(320, 10, 'MyMouse, Version 1.5: Zeigerformen');
  SetTextStyle(SmallFont, 0, 6);
  Out(320, 70, 'Sie sehen hier den Standard-Mauszeiger von MyMouse.');
  Out(320, 90, 'Diese komfortable Gre ist man von Microsoft');
  Out(320, 110, 'Windows gewhnt.'); W;
  Out(320, 140, 'In MyMouse sind noch weitere Mauszeigerformen');
  Out(320, 160, 'eingebaut. Zum Beispiel die bekannte Sanduhr.');
  SetMCursor(mcHourGlass); W;
  Out(320, 190, 'Neben den eingebauten Mauszeigerformen knnen');
  Out(320, 210, 'in MyMouse auf besonders einfache Weise eigene');
  Out(320, 230, 'Zeigerformen eingesetzt werden. Zum Beispiel dieser');
  Out(320, 250, 'Cursor zum Markieren von Text.');
  SetMCursor(mcInput); W;
  Out(320, 280, 'Mit MyMouse knnen Mauszeiger nahezu beliebig gro');
  Out(320, 300, 'werden. Man sollte es aber auch nicht bertreiben...');
  SetMCursor(mcHuge); W;
  Out(320, 330, 'Weiterhin kann die Zeigerfarbe beliebig verndert werden.');
  SetMCursor(mcStd); ShowMouse;
  For i := 1 to 15 do Begin
    SetPointerColor(i);
    Delay(200);
  End; W;
  SetColor(12); SetTextStyle(TriplexFont, 0, 4);
  Out(320, 380, 'Doch damit nicht genug:');
  SetColor(15); SetTextStyle(SmallFont, 0, 6);
  Out(320, 440, 'MyMouse, Version 1.5, untersttzt auch die automatische');
  Out(320, 460, 'Anpassung des Mauszeigers an graphische Bedienelemente...'); W;
  ClearDevice;
  Bar(0, 0, 639, 60);
  SetColor(15); SetTextStyle(TriplexFont, 0, 4);
  Out(320, 10, 'MyMouse: Automatische Zeigeranpassung');
  SetTextStyle(SmallFont, 0, 6);
  SetFillStyle(SolidFill, Blue); Bar(135, 75, 504, 244);
  SetFillStyle(SolidFill, White); Bar(140, 79, 499, 239);
  SetFillStyle(SolidFill, Blue); Bar(141, 80, 498, 99);
  SetFillStyle(SolidFill, DarkGray); Bar(160, 120, 259, 219);
  SetColor(Black); Rectangle(290, 120, 469, 140);
  SaveCC:=ChangeCursor; ChangeCursor:=DoCC;
  SetColor(White);
  Out(320, 260, 'Fahren Sie bitte mit der Maus ber die Bereiche...'); W;
  Out(320, 290, 'Diese Anpassung wird von MyMouse automatisch vorgenommen');
  Out(320, 310, 'und belastet den Programmierer in keiner Weise. Zur');
  Out(320, 330, 'Verfgung stehen mu lediglich eine kleine Prozedur,');
  Out(320, 350, 'die im Hintergrund durch MyMouse aufgerufen wird.'); W;
  ChangeCursor:=SaveCC; SetMCursor(mcStd);
  SetColor(12); SetTextStyle(TriplexFont, 0, 4);
  Out(320, 380, 'Auerdem');
  SetColor(15); SetTextStyle(SmallFont, 0, 6);
  Out(320, 440, 'bietet Ihnen MyMouse, Version 1.5, leistungsfhige');
  Out(320, 460, 'Routinen zur Kontrolle von Bildschirmbereichen und Seiten.'); W;
  ClearDevice;
  SetFillStyle(SolidFill, Blue); Bar(0, 0, 639, 60);
  SetColor(15); SetTextStyle(TriplexFont, 0, 4);
  Out(320, 10, 'MyMouse: Bildschirmbereiche');
  SetTextStyle(SmallFont, 0, 6);
  Out(370, 70, 'In MyMouse knnen Sie die Maus einsperren...');
  Rectangle(10, 100, 109, 199); SetMouseArea(10, 100, 110, 200); W;
  SetMouseArea(0, 0, 640, 480); SetMousePos(320, 200);
  Out(370, 100, 'Vor jeder Schreiboperation mu man normalerweise');
  Out(370, 120, 'mit HideMouse die Maus verstecken, damit keine');
  Out(370, 140, 'unerwnschten Seiteneffekte auftreten.');
  Out(370, 160, 'Bei aufwendigen Schreiboperationen entsteht');
  Out(370, 180, 'dadurch das gefrchtete Flackern...');
  ShowMouse; FillUp; HideMouse;
  Out(320, 210, 'MyMouse, Version 1.5, hat dafr eine elegante Lsung,');
  Out(320, 230, 'die Critical Area - die den Bildschirmbereich angibt,');
  Out(320, 250, 'der tatschlich modifiziert wird. Damit sieht es doch');
  Out(320, 270, 'viel besser aus...');
  SetCriticalArea(10, 100, 110, 200);
  ShowMouse; FillUp; HideMouse;
  SetCriticalArea(0, 0, 640, 480);
  SetColor(12); SetTextStyle(TriplexFont, 0, 4);
  Out(320, 300, 'Weitere Leistungsmerkmale');
  SetColor(15); SetTextStyle(SmallFont, 0, 6);
  Out(320, 350, 'Drivers-kompatible Ereignisverwaltung');
  Out(320, 370, 'Bereitstellung von Zeitgeber-Ereignissen');
  Out(320, 390, 'Untersttzung von SuperVGA-Karten');
  Out(320, 410, 'Untersttzung des 256-Farben-Modus');
  Out(320, 430, 'Zusammenarbeit mit allen Maustypen');
  Out(320, 450, 'Kompatibilitt mit dem BGI'); W;
End;

(****************************** M Y F O N T S ******************************)

const
  ftBios8       =  0;
  ftBios14      =  1;
  ftBios16      =  2;
  ftWinSys      =  3;
  ftSSerif      =  4;
  ftSSerifBold  =  5;
  ftSSerif24    =  6;
  ftBgi         =  7;
  ftBgiBold     =  8;
  ftCPI852      =  9;
  ftWinScal     = 10;
  ftWinScalBold = 11;

procedure InitFonts;
var
  WinDir, WinSysDir: DirStr;
  Font: PFontRec;

 function SysFont: PathStr;
 var
   F: PStream;
   s: PathStr;
 Begin
   F:=New(PBufStream, Init(WinDir+'SYSTEM.INI', stOpenRead, 1024));
   s:=ReadValue(F^, 'BOOT', 'FONTS.FON');
   Dispose(F, Done);
   SysFont:=FirstFile(s+';VGASYS.FON;?GASYS.FON', WinSysDir);
 End;

 procedure Define(Font: PFontRec);
 Begin
   If Font = nil
     then DefFont(FullAliasOf(ftBios16))
     else DefFont(Font)
 End;

Begin
  MaxBufMem := 131072 div 16;	{ greren Puffer fr viele Schriften }
  InitMemory; InitMyFonts;
  WinDir := GetWinDir;
  WinSysDir := WinDir+'SYSTEM\';

  DefFont(LoadBIOSFont( 8, 0, 0, 0));
  DefFont(LoadBIOSFont(14, 0, 0, 0));
  DefFont(LoadBIOSFont(16, 0, 0, 0));

  Define(LoadWinFont(SysFont, 1, 0, 0, 0, 0, 0, 0));
  Define(LoadWinFont(
    FirstFile('SSERIFE.FON;HELVE.FON;SSERIF?.FON;HELV?.FON', WinSysDir),
    0, 12, 0, 0, 0, 0, 0));
  DefFont(AliasOf(ftSSerif, 1, 0, 0, ftBold));
  Define(LoadWinFont(
    FirstFile('SSERIFE.FON;HELVE.FON;SSERIF?.FON;HELV?.FON', WinSysDir),
    0, 24, 0, 0, 0, 0, 0));
  Define(LoadBgiFileFont(
{$IFDEF exe}
    FixedAddr(@TriplexFontProc),
{$ELSE}
    PathToDriver+'\TRIP.CHR',
{$ENDIF}
    0, 1, 1, 1, 1, 0, 0, 0, ftNormal + ftNoDescent));
  Define(AliasOf(ftBgi, 2, 0, 0, ftBold));
  Define(LoadCpiFont('C:\DOS\EGA.CPI', 852, 16, 0, 0, 0));
  Define(LoadWinFont(
    FirstFile('SCRIPT.FON;ROMAN.FON', WinSysDir),
    1, 35, 0, 0, 0, 0, ftNormal));
  Define(AliasOf(ftWinScal, 0, 0, 0, ftBold));
End;

procedure BeginMyFonts;
Begin
  ClearDevice;
  Bar(0, 0, 639, 185); SetColor(White);
  SetTextStyle(TriplexFont, 0, 6);
  Out(320, 0, 'Das MyMouse-Paket');
  SetTextStyle(TriplexFont, 0, 4);
  Out(320, 80, 'Eine Demonstration');
  Out(320, 140, 'Teil II: MyFonts, Version 1.5');
  SetTextStyle(TriplexFont, 0, 4);
  Out(320, 200, 'Einerseits gibt Ihnen die Unit Graph');
  SetTextStyle(GothicFont, 0, 4);
  Out(320, 240, 'schne frei skalierbare Schriftarten.');
  SetTextStyle(SansSerifFont, 0, 1);
  Out(320, 280, 'Verkleinert man sie auf normale Textgren, sind sie aber hlich.');
  SetTextStyle(SmallFont, 0, 6);
  Out(320, 310, 'Der SmallFont sieht auch primitiv aus,');
  SetTextStyle(DefaultFont, 0, 1);
  Out(320, 340, 'der 8x8-DefaultFont ist kaum lesbar.'); W;
  SetTextStyle(SmallFont, 0, 6);
  Out(320, 370, 'Selbst die eingebauten Schriften aus dem Textmodus');
  Out(320, 390, 'sehen da ja besser aus. Doch wie nutzt man sie im');
  Out(320, 410, 'Graphikmodus? Und die Microsoft-Windows-Fonts');
  Out(320, 430, 'sehen noch besser aus; doch wie soll man an die nur');
  Out(320, 450, 'herankommen...'); W;
End;

procedure DemoMyFonts;
var
  cx, cy: Integer;

 procedure MOut(s: string);
 Begin
   OutTextXY(cx, cy, s);
   Inc(cy, TextHeight('') + 5);
 End;

 procedure DoLine;
 Begin
   Line(0, cy+2, 639, cy+2);
   Inc(cy, 11);
 End;

Begin
  ClearDevice;
  SetFillStyle(SolidFill, Blue); Bar(0, 0, 639, 50);
  Graph.SetTextJustify(CenterText, TopText);
  SetColor(15); SetTextStyle(TriplexFont, 0, 4);
  Out(320, 5, 'MyFonts: Schriftarten');
  SetTextJustify(CenterText, TopText);
  SetTextParams(ftBIOS8, 0, 15, false);
  cx := 320; cy := 47;
  DoLine;
  MOut('MyFonts, Version 1.5, nutzt die eingebauten');
  SetTextParams(ftBIOS14, 0, 15, false);
  MOut('BIOS-Schriftarten in den verschiedenen');
  SetTextParams(ftBIOS16, 0, 15, false);
  MOut('Gren: 8x8 Pixel, 8x14 Pixel, 8x16 Pixel.');
  DoLine; W;
  SetTextParams(ftCPI852, 0, 15, false);
  MOut('Weiterhin kann MyFonts die lnderspezifischen Schriftarten');
  If PFontRec(FontCollection^.At(ftCpi852))^.CodePage = 437
  then MOut('verwenden. Leider sind diese in Ihrem System nicht vorhanden.')
  else MOut('verwenden: ѥ   mh MM ؞.');
  DoLine; W;
  SetTextParams(ftWinSys, 0, 15, false);
  MOut('MyFonts, Version 1.5, kann auch eventuell');
  SetTextParams(ftSSerif, 0, 15, false);
  MOut('vorhandene Microsoft-Windows-Bitmap-');
  SetTextParams(ftSSerifBold, 0, 15, false);
  MOut('Schriftarten nutzen und auf Wunsch fettgedruckt');
  SetTextParams(ftSSerif24, 0, 15, false);
  If PFontRec(FontCollection^.At(ftWinSys))^.FontMode = ftCpi
  then MOut('darstellen! Leider sind diese in Ihrem System nicht vorhanden.')
  else Begin
    Dec(cy, 2);
    MOut('darstellen!');
    Dec(cy, 4)
  End;
  DoLine; W;
  SetTextParams(ftWinScal, 0, 15, false);
  MOut('MyFonts kann skalierbare Windows-Schriften');
  SetTextParams(ftWinScalBold, 1, 15, false); Dec(cy, 2);
  MOut('verwenden und auch fett darstellen.'); Dec(cy, 2);
  DoLine; W;
  SetTextParams(ftBgi, 0, 15, false);
  MOut('MyFonts wertet BGI-Schriften direkt'); Inc(cy, 7);
  SetTextParams(ftBgiBold, 0, 15, false);
  MOut('aus und kann sie fett darstellen.'); Inc(cy, 7);
  DoLine; W;
  SetTextParams(ftWinSys, 1, 12, false);
  SetTextJustify(RightText, BottomText);
  OutTextXY(639, 479, 'MyFonts untersttzt zudem spezielle Effekte...'); W;

  ClearDevice;
  SetFillStyle(SolidFill, Blue); Bar(0, 0, 639, 60);
  SetColor(15); SetTextStyle(TriplexFont, 0, 4);
  Graph.SetTextJustify(CenterText, TopText);
  Out(320, 10, 'MyFonts: Variationen in der Ausgabe');
  SetTextParams(ftWinSys, 4, 15, false);
  SetTextJustify(CenterText, TopText);
  OutTextXY(320, 80, 'Durch Vernderung der Zeichenabstnde');
  OutTextXY(320, 100, 'kann der Text gesperrt gesetzt werden.');
  SetTextParams(ftWinSys, -1, 15, false);
  OutTextXY(320, 130, 'Auf die gleiche Weise kann der Text verdichtet werden.');
  SetTextParams(ftWinSys, 1, $0C0F, true);
  OutTextXY(320, 200, 'MyFonts untersttzt ~Markierungszeichen~,');
  OutTextXY(320, 220, 'die ~farblich~ hervorzuhebende Textteile umschlieen.'); W;
  SetTextParams(ftWinSys, 1, 15, false);
  SetTextJustify(LeftText, TopText);    OutTextXY(  0, 260, 'Linksbndig ausgerichtet');
  SetTextJustify(CenterText, TopText);  OutTextXY(320, 260, 'Zentriert');
  SetTextJustify(RightText, TopText);   OutTextXY(639, 260, 'Rechtsbndig ausgerichtet');
  SetColor(4); Line(0, 300, 639, 300);
  SetTextJustify(LeftText, BottomText); OutTextXY(  0, 300, 'Nach oben');
  SetTextJustify(LeftText, BaseLine);   OutTextXY(128, 300, 'Grundlinie');
  SetTextJustify(LeftText, CenterText); OutTextXY(256, 300, 'Zentriert');
  SetTextJustify(LeftText, LeadLine);   OutTextXY(384, 300, 'Fhrende Linie');
  SetTextJustify(RightText, TopText);   OutTextXY(639, 300, 'Nach unten'); W;
  SetTextJustify(CenterText, TopText);
  OutTextXY(320, 340, 'MyFonts wird genauso gehandhabt wie die Unit Graph:');
  OutTextXY(320, 360, 'MyFonts kennt die Prozeduren OutTextXY, SetTextJustify');
  OutTextXY(320, 380, 'und die Funktionen TextWidth und TextHeight.');
  OutTextXY(320, 410, 'Nur SetTextStyle wird durch SetTextParams ersetzt, um');
  OutTextXY(320, 430, 'die erweiterten Mglichkeiten einstellen zu knnen.'); W;
  SetTextJustify(RightText, BottomText); SetTextParams(ftWinSys, 1, 12, false);
  OutTextXY(639, 479, 'MyFonts untersttzt auch Clipping an frei whlbaren Rndern...'); W;
  ClearDevice;
  SetFillStyle(SolidFill, Blue); Bar(0, 0, 639, 60);
  SetColor(15); SetTextStyle(TriplexFont, 0, 4);
  Graph.SetTextJustify(CenterText, TopText);
  Out(320, 10, 'MyFonts: Clipping und Verwaltung');
  SetFillStyle(SolidFill, DarkGray); Bar(20, 80, 239, 219);
  SetTextJustify(LeftText, TopText); SetTextParams(ftWinSys, 0, $0C0F, true);
  OutTextXY(260, 80, 'Dieses Rechteck ist das sogenannte ~ClipRect~,');
  OutTextXY(260, 100, 'der Bereich, in dem Textausgaben stattfinden');
  OutTextXY(260, 120, 'drfen.');
  OutTextXY(260, 150, 'Probieren Sie es aus: Klicken Sie mit der Maus');
  OutTextXY(260, 170, 'auf den Bildschirm bzw. ziehen Sie die Maus.');
  OutTextXY(260, 200, 'Beenden mit Tastendruck.');
  SetClipRect(20, 80, 240, 220);
  SetMCursor(mcCross); ShowMouse;
  Repeat
    GetMouseEvent(Event);
    If (Event.What=evMouseDown) or (Event.What=evMouseAuto) then Begin
      HideMouse;
      SetTextParams(ftWinSys, 0, Random(16), false);
      OutTextXY(Event.Where.x, Event.Where.y, 'Beispieltext fr Clipping');
      ShowMouse
    End
  Until keypressed;
  HideMouse; SetMCursor(mcStd); Readkey;
  SetClipRect(0, 0, 640, 480);
  SetTextJustify(CenterText, TopText);
  SetTextParams(ftWinSys, 0, $0C0F, true);
  OutTextXY(320, 230, 'Das Clipping geschieht in MyFonts automatisch. Unabhngig vom ~ClipRect~');
  OutTextXY(320, 250, 'kann mittels des ~DrawOrigin~ der Ursprung der Koordinaten bestimmt');
  OutTextXY(320, 270, 'werden. Die Unterscheidung dieser Mglichkeiten weist bei den meisten');
  OutTextXY(320, 290, 'Anwendungen erhebliche Vorteile gegenber dem ViewPort von Graph auf.'); W;
  SetColor(15); Line(0, 320, 639, 320);
  OutTextXY(320, 330, '~Richtungsweisend~ ist die Verwaltung der Schriftarten: Sie werden zu');
  OutTextXY(320, 350, 'Beginn des Programms vereinbart und dann ber Bezeichner angesprochen.');
  OutTextXY(320, 370, 'Dadurch ist leicht der ~dynamische Austausch~ von Schriftarten mglich.');
  OutTextXY(320, 400, 'Durch ein ~intelligentes Speichermanagement~ wird maximale Geschwindigkeit');
  OutTextXY(320, 420, 'erzielt, ohne da viel Speicher verloren ginge. ');
  OutTextXY(320, 450, 'Auerdem bietet MyFonts fr alle Schriften Windows-kompatible ~Textmae~ an.'); W;
End;

(****************************** V G A M E M ********************************)

procedure DoRestScr;
Begin
  ShowMouse;
  Repeat
    GetMouseEvent(Event);
    If (Event.What=evMouseDown) or (Event.What=evMouseAuto) then Begin
      HideMouse;
      RestoreScreen16(200, 50, 400, 150, Event.Where.x, Event.Where.y, R);
      ShowMouse
    End
  until keypressed; Readkey;
  HideMouse
End;

procedure DoCopyScr;
Begin
  ShowMouse;
  Repeat
    GetMouseEvent(Event);
    If (Event.What=evMouseDown) or (Event.What=evMouseAuto) then Begin
      HideMouse;
      CopyScreen16(420, 5, 630, 200, Event.Where.x, Event.Where.y);
      ShowMouse
    End
  until keypressed; Readkey;
  HideMouse
End;

procedure DrawIcon(x1, y1, n: Integer; Mode: Word); assembler;
{ Low-Byte von Mode gibt beeinflute Speicherebenen an. Ist das High-Byte
  0, so erfolgt and-Verknpfung, ansonsten or-Verknpfung.
  Dadurch lassen sich Farbeffekte erzielen. }
Asm
	MOV	SI, OFFSET @D1
	MOV	AX, n
	OR	AL, AL
	JZ 	@@1
@@2:	MOV	CX, [CS:SI]
	SHL	CX, 1
	JZ	@@3
	ADD	SI, CX
	ADD	SI, 2
	DEC	AL
	JNZ	@@2
@@1:    PUSH	x1
	PUSH	y1
	PUSH	Mode
	PUSH	CS
	PUSH	SI
	CMP	BYTE PTR Mode+1, 0
	JNZ	@@4
	CALL	PutIconAnd16
	JMP	@@3
@@4:	CALL	PutIconOr16
	JMP	@@3
@D1:	DW	13			{ 0 CheckBox off }
	DW	1111111111111000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1111111111111000B
	DW	13			{ 1 CheckBox on }
	DW	1111111111111000B
	DW	1100000000011000B
	DW	1010000000101000B
	DW	1001000001001000B
	DW	1000100010001000B
	DW	1000010100001000B
	DW	1000001000001000B
	DW	1000010100001000B
	DW	1000100010001000B
	DW	1001000001001000B
	DW	1010000000101000B
	DW	1100000000011000B
	DW	1111111111111000B
	DW	13			{ 2 RadioButton off }
	DW	0000011100000000B
	DW	0001100011000000B
	DW	0010000000100000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	1000000000001000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0010000000100000B
	DW	0001100011000000B
	DW	0000011100000000B
	DW	13			{ 3 RadioButton on }
	DW	0000011100000000B
	DW	0001100011000000B
	DW	0010000000100000B
	DW	0100011100010000B
	DW	0100111110010000B
	DW	1001111111001000B
	DW	1001111111001000B
	DW	1001111111001000B
	DW	0100111110010000B
	DW	0100011100010000B
	DW	0010000000100000B
	DW	0001100011000000B
	DW	0000011100000000B
	DW	11			{ 4 Zoom }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000001000000B
	DW	0000000011100000B
	DW	0000000111110000B
	DW	0000001111111000B
	DW	15			{ 5 UnZoom }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000001000000B
	DW	0000000011100000B
	DW	0000000111110000B
	DW	0000001111111000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000001111111000B
	DW	0000000111110000B
	DW	0000000011100000B
	DW	0000000001000000B
	DW	12			{ 6 Symbol }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000001111111000B
	DW	0000000111110000B
	DW	0000000011100000B
	DW	0000000001000000B
	DW	12			{ 7 Scroll Arrow Right }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000011000000B
	DW	0000011111100000B
	DW	0000011111110000B
	DW	0000011111100000B
	DW	0000000011000000B
	DW	0000000010000000B
	DW	12			{ 8 Scroll Arrow Left }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000110000000B
	DW	0000001111110000B
	DW	0000011111110000B
	DW	0000001111110000B
	DW	0000000110000000B
	DW	0000000010000000B
	DW	12			{ 9 Scroll Arrow Up }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000111000000B
	DW	0000001111100000B
	DW	0000011111110000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	12			{ 10 Scroll Arrow Down }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000011111110000B
	DW	0000001111100000B
	DW	0000000111000000B
	DW	0000000010000000B
	DW	13			{ 11 Scroll Arrow Right Shadow }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000011000000B
	DW	0000011111100000B
	DW	0000011111110000B
	DW	0000011111111000B
	DW	0000001111110000B
	DW	0000000011100000B
	DW	0000000001000000B
	DW	13			{ 12 Scroll Arrow Left Shadow }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000111000000B
	DW	0000001111110000B
	DW	0000011111111000B
	DW	0000001111111000B
	DW	0000000111111000B
	DW	0000000011000000B
	DW	0000000001000000B
	DW	13			{ 13 Scroll Arrow Up Shadow }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000010000000B
	DW	0000000111000000B
	DW	0000001111100000B
	DW	0000011111110000B
	DW	0000011111011000B
	DW	0000000111100000B
	DW	0000000111100000B
	DW	0000000011100000B
	DW	13			{ 14 Scroll Arrow Down Shadow }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000111000000B
	DW	0000000111100000B
	DW	0000000111100000B
	DW	0000011111110000B
	DW	0000001111111000B
	DW	0000000111110000B
	DW	0000000011100000B
	DW	0000000001000000B
	DW	14			{ 15 Open List Button }
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000000000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000000111000000B
	DW	0000011111110000B
	DW	0000001111100000B
	DW	0000000111000000B
	DW	0000000010000000B
	DW	0000000000000000B
	DW	0000011111110000B
	DW	9			{ 16 Submenu Arrow }
	DW	1000000000000000B
	DW	1100000000000000B
	DW	1110000000000000B
	DW	1111000000000000B
	DW	1111100000000000B
	DW	1111000000000000B
	DW	1110000000000000B
	DW	1100000000000000B
	DW	1000000000000000B
	DW	13			{ 17 held CheckBox off }
	DW	1111111111111000B
	DW	1111111111111000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1111111111111000B
	DW	1111111111111000B
	DW	13			{ 18 held CheckBox on }
	DW	1111111111111000B
	DW	1111111111111000B
	DW	1110000000111000B
	DW	1101000001011000B
	DW	1100100010011000B
	DW	1100010100011000B
	DW	1100001000011000B
	DW	1100010100011000B
	DW	1100100010011000B
	DW	1101000001011000B
	DW	1110000000111000B
	DW	1111111111111000B
	DW	1111111111111000B
	DW	13			{ 19 held RadioButton off }
	DW	0000011100000000B
	DW	0001111111000000B
	DW	0011100011100000B
	DW	0111000001110000B
	DW	0110000000110000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	1100000000011000B
	DW	0110000000110000B
	DW	0111000001110000B
	DW	0011100011100000B
	DW	0001111111000000B
	DW	0000011100000000B
	DW	13			{ 20 held RadioButton on }
	DW	0000011100000000B
	DW	0001111111000000B
	DW	0011100011100000B
	DW	0111011101110000B
	DW	0110111110110000B
	DW	1101111111011000B
	DW	1101111111011000B
	DW	1101111111011000B
	DW	0110111110110000B
	DW	0111011101110000B
	DW	0011100011100000B
	DW	0001111111000000B
	DW	0000011100000000B
	DW	12			{ 21 small CheckBox off }
	DW	0000000000000000B	{ hhenkompatibel mit anderen!! }
	DW	0111111111110000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0100000000010000B
	DW	0111111111110000B
	DW	12			{ 22 small CheckBox on }
	DW	0000000000000000B	{ hhenkompatibel mit anderen!! }
	DW	0111111111110000B
	DW	0110000000110000B
	DW	0101000001010000B
	DW	0100100010010000B
	DW	0100010100010000B
	DW	0100001000010000B
	DW	0100010100010000B
	DW	0100100010010000B
	DW	0101000001010000B
	DW	0110000000110000B
	DW	0111111111110000B
	DW	0			{ Ende }
@@3:
End;

procedure DrawColIcon(x1, y1, n: Integer; Color: Byte);
{ Zeichnet ein Icon mit einer bestimmten Farbe unabhngig vom Hintergrund. }
Begin
  DrawIcon(x1, y1, n, $0F);
  DrawIcon(x1, y1, n, $100+Color);
End;

procedure DrawIcons;
var
  x, y, dx, dy, n:Integer;
Begin
  UserParams(1); ClipNotifyProc(gcnHaltUpd);
  Repeat
    x:=Random(GetMaxX+1); y:=Random(GetMaxY+1); n:=Random(23);
    case n of
      4..6: Begin dx:=20; dy:=20 End;
      7..14: Begin dx:=17; dy:=17 End;
      15: Begin dx:=17; dy:=20 End;
      else Begin dx:=0; dy:=0 End
    End;
    If dx <> 0 then Begin
      SetCriticalArea(x, y, x+dx, y+dy);
      SetFillStyle(SolidFill, 7); Bar(x, y, x+dx-1, y+dy-1);
      SetColor(0); Rectangle(x, y, x+dx-1, y+dy-1);
      SetColor(8); Line(x+2, y+dy-3, x+dx-2, y+dy-3);
      Line(x+1, y+dy-2, x+dx-2, y+dy-2);
      Line(x+dx-3, y+2, x+dx-3, y+dy-4); Line(x+dx-2, y+1, x+dx-2, y+dy-4);
      SetColor(15); Line(x+1, y+1, x+dx-3, y+1); Line(x+1, y+2, x+1, y+dy-3)
    End else Begin
      SetCriticalArea(x-1, y-1, x+13, y+13);
      SetFillStyle(SolidFill, White);
      Bar(x-1, y-1, x+13, y+13)
    End;
    If (n<4) or (n>=16) then DrawColIcon(x, y, n, Random(16)) else
      if (n<11) or (n>14) then DrawIcon(x, y, n, $0F) else begin
	DrawIcon(x, y, n, $10F); DrawIcon(x, y, n-4, $07) end;
    GetMouseEvent(Event);
  Until keypressed or (Event.What=evMouseDown);
  If keypressed then Readkey
End;

procedure DemoVgaMem;
Begin
  ClearDevice; SetFillStyle(SolidFill, Blue);
  Bar(0, 0, 639, 185); SetColor(White);
  SetTextStyle(TriplexFont, 0, 6); Graph.SetTextJustify(CenterText, TopText);
  Out(320, 0, 'Das MyMouse-Paket');
  SetTextStyle(TriplexFont, 0, 4);
  Out(320, 80, 'Eine Demonstration');
  Out(320, 140, 'Teil III: VGAMem, Version 1.5');
  SetTextJustify(CenterText, TopText);
  SetTextParams(ftWinSys, 0, $0C0F, true);
  OutTextXY(320, 200, 'Die Unit VGAMem, Version 1.5, ist die Antwort auf die ineffizienten');
  OutTextXY(320, 220, 'und fehlerhaften Graph-Routinen PutImage/GetImage, die Vergeudung von');
  OutTextXY(320, 240, 'Restspeicher auf der VGA-Karte und das Fehlen hardwarenaher VGA-');
  OutTextXY(320, 260, 'Kopier- und Manipulierroutinen.'); W;
  OutTextXY(320, 290, 'Die Unit VGAMem nutzt die Mglichkeiten der VGA-Karte voll aus und');
  OutTextXY(320, 310, 'erzielt dadurch ~maximale Geschwindigkeit~ bei der Ausfhrung der');
  OutTextXY(320, 330, 'Routinen, die brigens durchweg in Assembler geschrieben sind.');
  OutTextXY(320, 360, 'Obwohl VGAMem direkt die VGA-Register und den Speicher manipuliert,');
  OutTextXY(320, 380, 'sind die Routinen vollstndig kompatibel zum Borland Graphics');
  OutTextXY(320, 400, 'Interface - und zu MyMouse und MyFonts natrlich auch!'); W;
  SetTextJustify(RightText, BottomText);
  OutTextXY(639, 479, '~Die Restspeicherverwaltung von VGAMem...~'); W;
  ClearDevice;
  SetFillStyle(SolidFill, Blue); Bar(0, 0, 639, 60);
  SetColor(15); SetTextStyle(TriplexFont, 0, 4);
  Graph.SetTextJustify(CenterText, TopText);
  Out(320, 10, 'VGAMem: Restspeicherverwaltung');
  SetTextJustify(CenterText, TopText);
  SetTextParams(ftWinSys, 0, $0C0F, true);
  OutTextXY(320,  80, 'Auf der VGA-Karte liegen normalerweise groe Teile des Speichers');
  OutTextXY(320, 100, 'brach. Im Standard-Modus (640x480 Punkte) sind es z. B. ~106 KB~,');
  OutTextXY(320, 120, 'also eine ungemein wertvolle Ressource.');
  OutTextXY(320, 150, 'Mit VGAMem, Version 1.5, kann dieser Restspeicher effizient genutzt');
  OutTextXY(320, 170, 'werden: Es werden eine leistungsfhige ~dynamische Speicherverwaltung~');
  OutTextXY(320, 190, 'und ~schnelle Kopierroutinen~ zwischen Bild- und Restspeicher zur');
  OutTextXY(320, 210, 'Verfgung gestellt.'); W;
  InitVGAMan;
  SetColor(10); Rectangle(200, 50, 399, 149);
  R:=GetVGAMem(GetSize16(200, 50, 400, 150));
  SaveScreen16(200, 50, 400, 150, R);
  OutTextXY(320, 240, 'Dieser Bildausschnitt wurde soeben in den Restspeicher kopiert.'); W;
  OutTextXY(320, 260, 'Klicken Sie jetzt mit der Maus bzw. ziehen Sie sie. Der Ausschnitt');
  OutTextXY(320, 280, 'wird aus dem Restspeicher wiederhergestellt. Beenden mit Tastendruck.');
  SetMCursor(mcCross); DoRestScr;
  ClearDevice; Bar(0, 0, 639, 60); SetColor(White);
  Out(320, 10, 'VGAMem: Kopieraktionen');
  Rectangle(50, 80, 399, 299);
  SetTextJustify(LeftText, TopText);
  OutTextXY(440,  80, 'Auch VGAMem untersttzt');
  OutTextXY(440, 100, 'das ~ClipRect~. Der');
  OutTextXY(440, 120, 'wiederhergestellte Bild-');
  OutTextXY(440, 140, 'ausschnitt wird an den');
  OutTextXY(440, 160, 'Rndern dieses Rechtecks');
  OutTextXY(440, 180, 'abgeschnitten.');
  SetClipRect(50, 80, 400, 300); DoRestScr;
  SetClipRect(0, 0, 640, 480); SetTextJustify(CenterText, TopText);
  SetFillStyle(SolidFill, 0); Bar(50, 80, 399, 299);
  SetColor(15); Rectangle(50, 80, 399, 299);
  SetMCursor(mcStd);
  OutTextXY(320, 340, 'Neben der Nutzung des Restspeichers bietet VGAMem');
  OutTextXY(320, 360, 'auch direkte Bildschirmkopieraktionen. Beliebige');
  OutTextXY(320, 380, 'Bildausschnitte knnen kopiert werden - dabei wird');
  OutTextXY(320, 400, 'das ~ClipRect~ beachtet.'); W;
  SetColor(10); Rectangle(420, 5, 629, 199);
  OutTextXY(320, 430, 'Kopiert wird dieser Bereich... Beenden mit Tastendruck.');
  SetClipRect(50, 80, 400, 300); SetMCursor(mcCross); DoCopyScr;
  SetMCursor(mcStd); SetClipRect(0, 0, 640, 480);
  ClearDevice; SetFillStyle(SolidFill, 1); Bar(0, 0, 639, 60); SetColor(White);
  Out(320, 10, 'VGAMem: Icon-Ausgabe');
  SetFillStyle(SolidFill, 15); Bar(50, 80, 589, 299);
  OutTextXY(320, 320, 'VGAMem stellt Prozeduren zur Darstellung kleiner graphischer');
  OutTextXY(320, 340, 'Symbole, sog. ~Icons~ bereit. Dieses Beispiel zeigt Icons von');
  OutTextXY(320, 360, 'graphischen Benutzeroberflchen. Bei der Darstellung wird');
  OutTextXY(320, 380, 'das ~ClipRect~ beachtet.');
  SetClipRect(50, 80, 590, 300); DrawIcons;
  SetClipRect(0, 0, 640, 480);
  SetCriticalArea(0, 0, 640, 480);
  SetColor(15); Line(20, 405, 620, 405);
  OutTextXY(320, 415, 'Auerdem ersetzt VGAMem die Image-Routinen der Unit Graph. Dadurch');
  OutTextXY(320, 435, 'werden Images korrekt an den Rndern des ClipRect abgeschnitten.'); W;
  DoneVGAMan;
End;

(***************************************************************************)

Begin
  If not MouseInstalled then Begin
    WriteLn('Die MyMouse-Demonstration arbeitet nur mit installiertem Maustreiber. ');
    Halt(1)
  End;
  InitGr;
  InitEvents; HideMouse;
  BeginMyMouse;
  MaxWidth := 8; MaxLength := 64;
  ClearDevice; InitMyMouse; HideMouse;
  SaveGetCursor:=GetMCursor; GetMCursor:=DoGetCursor;
  DemoMyMouse;
  BeginMyFonts;
  InitFonts;
  DemoMyFonts;
  DemoVgaMem;
  DoneMyFonts; DoneMemory; DoneMyMouse; DoneEvents;
  CloseGraphics;
  PrintStr('Dies war die Demonstration zum MyMouse-Paket. Wir danken Ihnen'^m^j);
  PrintStr('fr Ihre Aufmerksamkeit und wnschen Ihnen viel Erfolg beim'^m^j);
  PrintStr('Einsatz der Software. Bitte lesen Sie auch die Begleittexte.'^m^j^m^j);
End.

