// -*- C++ -*-
#include "data-input.h"
#include <time.h>

inline int rnd(int max1)
{
  return (int) (((double) max1) * rand() / (RAND_MAX+1.0));
}

// neighbourhoods

class ChangeTwoNH {
  // Tauschnachbarschaft
public:
  ChangeTwoNH() {}
  void operator()(Tour &tour)
  {
    int i = rnd(tour.size());
    int j = rnd(tour.size());
    int t = tour[i];
    tour[i] = tour[j];
    tour[j] = t;
  }
};

class Lin2OptNH {
  // LIN-2-OPT-Schritt
public:
  Lin2OptNH() {}
  void operator()(Tour &tour)
  {
    // Finde zul"assige A--B, C--D f"ur
    // Neuverdrahtung A--C, B--D
    int a = rnd(tour.size());
    int b = (a + 1) % tour.size();
    int c, d;
    do {
      c = rnd(tour.size());
      d = (c + 1) % tour.size();
    } while (c==a || c==b || d==a || d==b);
    int i;
    for (i = b; i!=c && i!=d; i = (i+1)%tour.size());
    if (i==d) d=c, c=i;
    // Schreibe neue Tour
    Tour old = tour;
    int j = 0;
    int k;
    for (k = b; k!=c; j++, k=(k+1)%tour.size())
      tour[j] = old[k];
    tour[j++] = old[c];
    for (k = a; k!=d; j++, k=(k+tour.size()-1)%tour.size())
      tour[j] = old[k];
    tour[j++] = old[d];
  }    
};

// Accept mechanisms

class LessOrEqual {
public:
  LessOrEqual() {}
  int operator() (int A, int B)
  {
    return A <= B;
  }
};

class SimulatedAnnealing {
  int StartTemperature;
  double Decrease;
  int Time;
public:
  SimulatedAnnealing(int temp, double decrease):
    StartTemperature(temp),
    Decrease(decrease),
    Time(0) {}
  int operator()(int A, int B) {
    Time++;
    if (A <= B) return 1;
    // Calculate probability
    double Prob = exp(((double) (B - A)) / Temperature());
//     cout << "Accept increase of " << A-B << " at " << Temperature() <<
//       " with prob " << Prob;
    double Res = ((double) rand()) / (((double)RAND_MAX)+1);
//     cout << " and result " << Res;
    int acc = (Prob >= Res);
//     if (acc) cout << ", accepted.\n"; else cout << '\n';
    //    cout << Prob << " ";
    return acc;
  }
  int Temperature() const {
    return (int) (exp(- Time / Decrease) * StartTemperature);
  }
  void IncreaseTime(int Step) { Time+=Step; }
};

template <class Neighbourhood, class Accept>
void GeneralIteration(Neighbourhood &neighbourhood, Accept &accept,
		      Tour &tour, int MaxIter)
{
  int i;
  Tour mintour(tour);
  int tourlength = length(tour);
  int minlength = tourlength;
  for (i = 0; i<MaxIter; i++) {
    Tour next = tour;
    neighbourhood(next);
    int nextlength = length(next);
    if (accept(nextlength, tourlength)) {
      tourlength = nextlength;
      tour = next;
      if (tourlength < minlength) {
	minlength = tourlength;
	cout << "a" << minlength << " " << flush;
	mintour = tour;
      }
    }
  }
  if (minlength < tourlength)
    tour = mintour;
}


