#include "config.h"
#include <fstream>
#include "F2.h"
#include "F4.h"
#include "FP.h"
#ifdef HAVE_GMP
#  include "Q.h"
#endif
#include "BorderSpaceFactory.h"
#include "Polynomial.h"

BorderSpaceFactory::BorderSpaceFactory()
	: IdealFactory()
{
}

BorderSpaceInterface*
BorderSpaceFactory::buildBorderSpace(const char* filename, int alpha_deg)
{
	std::ifstream in(filename);
	std::string line;
	std::string s;

	/* check if file opened sucessfully */	
	if (!in) {
		std::cout << "ERROR: Unable to open file " << filename << "\n";
		exit(1);
	}

	/* Strip comments. */
	while (in.peek() == COMMENT) { getline(in, line); }

	/* Find the characteristic of the field. */
	int fieldChar = 0;
	getline(in, line);
	if (sscanf(line.c_str(), "FIELD=F%d", &fieldChar) == 0) {
		std::cout << "ERROR! Field information for ideal not found.\n"; 
		exit(1);
	}

    BorderSpaceInterface* border = 0;

	switch (fieldChar) {
	case 0:
#ifdef HAVE_GMP
        border = new BorderSpace<Q>(*buildIdeal<Q>(in), alpha_deg);
#else
        std::cerr << "ERROR: Field characteristic 0 no supported.\n";
        std::cerr << "ERROR: because no GMP was found.\n";
        exit(1);
        border = 0;
#endif
		break;
	case 2:
        border = new BorderSpace<F2>(*buildIdeal<F2>(in), alpha_deg);
		break;
	case 4:
        border = new BorderSpace<F4>(*buildIdeal<F4>(in), alpha_deg);
		break;
	default:
		FP::initialise(fieldChar);
        border = new BorderSpace<FP>(*buildIdeal<FP>(in), alpha_deg);
	}

	in.close();

    return border;
}
