#include <ctime>
#include <cmath>
#include <string>
#include <fstream>
#include <iostream>
#include <sstream>
#include <getopt.h>

#include "BorderSpaceFactory.h"
#include "MyTime.h"

using namespace std;

/* forward declaration */
bool process_cmd_line(int argc, char* argv[], std::string& filename, int& degree);
void print_usage();

int main(int argc, char *argv[])
{
    /* time functions */
    double start;
    double elapsed;
    /* begin time measurement */
    start = tic();

    std::string filename;
    int alpha_deg(-1);

    if (!process_cmd_line(argc, argv, filename, alpha_deg)) {
        print_usage();
        return 1;
    }

    /* create an ideal from a file */
    BorderSpaceFactory factory;
    BorderSpaceInterface* bs = factory.buildBorderSpace(filename.c_str(), alpha_deg);
    int num_sols = bs->isVarietyEmpty();
    if (num_sols > 0) {
        cout << "System of equations is feasible.\n";
        cout << "The number of solutions with multiplicities is " << num_sols << "\n";
    }
    else if (num_sols == 0) {
        cout << "System of equations is NOT feasible.\n";
    } else {
        cout << "System of equations MAY BE feasible...";
        cout << " try a higher degree.\n";
    }
    delete bs;

    elapsed = toc(start);
    cout << "TIME: " << elapsed << "\n"; 

    return 0;
}

void print_usage() {
    cout << "Usage:\n";
    cout << "\t ./border [-d MAX_DEGREE] <filename>\n";
    cout << "\t ./border [--degree MAX_DEGREE] <filename>\n";
    exit(0);
}

bool
process_cmd_line(int argc, char* argv[], std::string& filename, int& alpha_deg)
{
    char c;
    int option_index(0);
    /* add more options here */
    struct option long_options[] = {
        {"degree", required_argument, 0, 'd'}
    };

    while ((c =
        getopt_long(argc, argv, "d:", long_options, &option_index)) != -1) {
        switch (c) {
            case 'd': {
                if (!optarg) { print_usage(); }
                else { alpha_deg = atoi(optarg); }
                break;
            }
        }
    }
    if (optind != argc-1) { return false; }
    filename = argv[optind];
    return true;
}
