#include <time.h>
#include <math.h>
#include <string.h>
#include <fstream>
#include <iostream>
#include <iomanip>
#include <sstream>
#include <getopt.h>
#include <queue>
using namespace std;

#include "shared/GraphBuilder.h"
#include "shared/Graph.h"
#include "coloring/ColoringIdealBuilder.h"
#include "nulla/Nullstellensatz.h"

int alpha_deg = 3;
int k_color = 3;

bool
odd_cycle(const Graph& g, std::vector<int>& fixed)
{
    static std::vector<int> adj_list;
    std::queue<int> q;
    std::vector<int> cycle(fixed.size(),0);
    while (1) {
        for (size_t j = 0; j < fixed.size(); ++j) {
            if (fixed[j] == 2 && cycle[j] == 0) { cycle[j] = 1; q.push(j); break; }
        }
        if (q.empty()) { break; }
        while (!q.empty()) {
            int j = q.front(); q.pop();
            adj_list = (g.getAdjList())[j];
            for (size_t k = 0; k < adj_list.size(); ++k) {
                int l = adj_list[k];
                if (fixed[l] == 2) {
                    if (cycle[l] == 0) {
                        cycle[l] = 3-cycle[j];
                        q.push(l);
                    }
                    else if (cycle[l] != 3-cycle[j]) {
                        //std::cout << "Odd cycle.\n";
                        return true;
                    }
                }
            }
        }
    }
    return false;
}

// Return true if variety is empty.
bool test_graph_branching1(const Graph& g, int i, std::vector<int>& fixed)
{
    static std::vector<int> adj_list;
    if (odd_cycle(g, fixed)) { return true; }

#if 0
    // Choose the next index to fix.
    ++i;
    while (fixed[i] != 0 && i < (int) fixed.size()) { ++i; }
    if (i == (int) fixed.size()) { return false; }
#else
    // Find index of greatest unfixed degree.
    int i0=0;
    int ufdeg = -1;
    while (fixed[i0] != 0 && i0 < (int) fixed.size()) { ++i0; }
    while (i0 < (int) fixed.size()) {
        int ufdeg0 = 0;
        adj_list = (g.getAdjList())[i0];
        for (size_t k = 0; k < adj_list.size(); ++k) {
            if (fixed[adj_list[k]]==0) { ++ufdeg0; }
        }
        //std::cout << i0 << " " << ufdeg0 << "\n";
        if (ufdeg0 > ufdeg) { i = i0; ufdeg = ufdeg0; }
        ++i0;
        while (fixed[i0] != 0 && i0 < (int) fixed.size()) { ++i0; }
    }
    if (ufdeg == -1) { return false; } // Did not find next index.
#endif

    std::vector<int> tmp_fixed = fixed;

    fixed[i]=1;
    adj_list = (g.getAdjList())[i];
    for (size_t k = 0; k < adj_list.size(); ++k) { fixed[adj_list[k]] = 2; }

    if (!test_graph_branching1(g, i, fixed)) { return false; }

    fixed = tmp_fixed;
    fixed[i]=2;

    if (!test_graph_branching1(g, i, fixed)) { return false; }

    fixed[i]=0;

    return true;
}

#if 1
// Return true if variety is empty.
bool test_graph_branching(const Graph& g, int i, std::vector<int>& fixed)
{
    static std::vector<int> adj_list;

    if (odd_cycle(g, fixed)) { return true; }

	ColoringIdealBuilder ib;
	Ideal<F2> *I = ib.buildColoringIdeal<F2>(g, k_color, fixed); 
    //I->print();
	Nullstellensatz<F2> N1(*I, alpha_deg, alpha_deg);
    N1.set_output_level(0);
    if (N1.isVarietyEmpty()) {
        delete I;
        return true;
    }
    delete I;

#if 0
    // Choose the next index to fix.
    ++i;
    while (fixed[i] != 0 && i < (int) fixed.size()) { ++i; }
    if (i == (int) fixed.size()) { return false; }
#else
    // Find index of greatest unfixed degree.
    int i0=0;
    int ufdeg = -1;
    while (fixed[i0] != 0 && i0 < (int) fixed.size()) { ++i0; }
    while (i0 < (int) fixed.size()) {
        int ufdeg0 = 0;
        adj_list = (g.getAdjList())[i0];
        for (size_t k = 0; k < adj_list.size(); ++k) {
            if (fixed[adj_list[k]]==0) { ++ufdeg0; }
        }
        //std::cout << i0 << " " << ufdeg0 << "\n";
        if (ufdeg0 > ufdeg) { i = i0; ufdeg = ufdeg0; }
        ++i0;
        while (fixed[i0] != 0 && i0 < (int) fixed.size()) { ++i0; }
    }
    if (ufdeg == -1) { return false; } // Did not find next index.
#endif

    std::vector<int> tmp_fixed = fixed;

    fixed[i]=1;
    adj_list = (g.getAdjList())[i];
    for (size_t k = 0; k < adj_list.size(); ++k) { fixed[adj_list[k]] = 2; }

    if (!test_graph_branching(g, i, fixed)) { return false; }

    fixed = tmp_fixed;
    fixed[i]=2;

    if (!test_graph_branching(g, i, fixed)) { return false; }

    fixed[i]=0;

    return true;
}
#endif

bool branching3color(const Graph& g)
{
    double start = tic();
    //std::cout << "Nullstellensatz degree = " << alpha_deg << "\n";
    //std::cout << "Solving problem by branching...\n";

    std::vector<int> fixed(g.getNumVertices(), 0);
    fixed[0] = 1;
    std::vector<int> adj_list = (g.getAdjList())[0];
    for (size_t k = 0; k < adj_list.size(); ++k) {
        int j = adj_list[k];
        if (fixed[j] == 0) { fixed[j] = 2; }
    }

    return !test_graph_branching(g, 0, fixed);
    //return !test_graph_branching1(g, 0, fixed);
}
