#ifndef IDEAL_BUILDER_H
#define IDEAL_BUILDER_H

#include "Ideal.h"
#include "Graph.h"

using namespace std;

/* wrapper class for GMP's polynomial number for exact arithmetic */
class ColoringIdealBuilder {
	private:

	public:
		/* default constructor */
		ColoringIdealBuilder() {};
		/* destructor */
		~ColoringIdealBuilder();

		/* construct a k coloring ideal */
        template <class K>
		Ideal<K>* buildColoringIdeal(const Graph& g, const int&);
        template <class K>
        Ideal<K>* buildColoringIdeal(const Graph& g, const int&, const vector<int>&);
};

template <class K>
Ideal<K> *
ColoringIdealBuilder::buildColoringIdeal(const Graph& g, const int& k_color)
{
	const vector<Graph::Edge> edges = g.getEdges();
    int num_vars = g.getNumVertices()-1;
	Ideal<K>* I = new Ideal<K>(num_vars);
    // We set the last vertex to be 1.
	Term<K> term(num_vars);
    term.coeff = 1;

	/* walk all edges */
	int j_exp = 0;
	for (size_t e = 0; e < edges.size(); e++) {
		/* construct x_i^k-1 + x_i^k-1x_j + ... x_j^k-1 */
		Polynomial<K> ep(num_vars);
        term.mon.set_constant();
		for (int k = k_color - 1; k >= 0; k--) {
			j_exp = k_color - 1 - k;
			if (edges[e].i != num_vars) { term.mon[edges[e].i] = k; }
			if (edges[e].j != num_vars) { term.mon[edges[e].j] = j_exp; }
			ep.addeq(term);
		}
		/* finished constructed x_i^k-1 + x_i^k-1x_j + ... x_j^k-1 */
		I->addPoly(ep);
	}
	
	/* return graph k-coloring ideal */
	return I;	
}

#if 0
template <class K>
Ideal<K> *
ColoringIdealBuilder::buildColoringIdeal(const Graph& g, const int& k_color)
{
	const vector<Graph::Edge> edges = g.getEdges();
	Ideal<K>* I = new Ideal<K>(g.getNumVertices());
	/* create a vector of size num_vertices, initialized to 0 */
	Term<K> term(g.getNumVertices());

	/* add a single vertex polynomial to the ideal, x_i^k + 1 */
	Polynomial<K> p(g.getNumVertices());
	term.mon[0] = k_color;
	p.addeq(term);
	/* reset monomial */
	term.mon[0] = 0;
    term.coeff = -1;
	p.addeq(term);
	I->addPoly(p);
    term.coeff = 1;

	/* walk all edges */
	int j_exp = 0;
	for (size_t e = 0; e < edges.size(); e++) {
		/* construct x_i^k-1 + x_i^k-1x_j + ... x_j^k-1 */
		Polynomial<K> ep(g.getNumVertices());
		for (int k = k_color - 1; k >= 0; k--) {
			j_exp = k_color - 1 - k;
			term.mon[edges[e].i] = k;
			term.mon[edges[e].j] = j_exp;
			ep.addeq(term);
		}
		/* finished constructed x_i^k-1 + x_i^k-1x_j + ... x_j^k-1 */
		I->addPoly(ep);

		/* reset monomial */
		term.mon[edges[e].i] = 0;
		term.mon[edges[e].j] = 0;
	}
	
	/* return graph k-coloring ideal */
	return I;	
}
#endif

template <class K>
Ideal<K> *
ColoringIdealBuilder::buildColoringIdeal(
                        const Graph& g, const int& k_color, const
                        std::vector<int>& fixed)
{
	const std::vector<Graph::Edge> edges = g.getEdges();

    std::vector<int> var_map(fixed.size(), 0);
    int num_vars = 0;
    for (size_t i = 0; i < fixed.size(); ++i) {
        if (fixed[i] != 1) { var_map[i] = num_vars; ++num_vars; }
    }

	Ideal<K>* I = new Ideal<K>(num_vars);
	/* create a vector of size num_vertices, initialized to 0 */
	Term<K> term(num_vars);

	/* walk all vertices*/
	for (size_t v = 0; v < fixed.size(); v++) {
        if (fixed[v] == 2) { 
    		/* construct x_i^k-1 + x_i^k-1 + ... + 1 */
    		Polynomial<K> ep(num_vars);
		    for (int k = k_color - 1; k >= 0; k--) {
			    term.mon[var_map[v]] = k;
			    ep.addeq(term);
		    }
		    /* finished constructed x_i^k-1 + x_i^k-1 + ... + 1 */
		    I->addPoly(ep);
		    /* reset monomial */
		    term.mon[var_map[v]] = 0;
        }
	}

	/* walk all edges */
	for (size_t e = 0; e < edges.size(); e++) {
        if (fixed[edges[e].i] != 1 && fixed[edges[e].j] != 1) {
            int i = var_map[edges[e].i];
            int j = var_map[edges[e].j];
		    /* construct x_i^k-1 + x_i^k-1x_j + ... + x_j^k-1 */
		    Polynomial<K> ep(g.getNumVertices());
		    for (int k = k_color-1; k >= 0; k--) {
			    term.mon[i] = k;
			    term.mon[j] = k_color-1-k;
			    ep.addeq(term);
		    }
		    /* finished constructed x_i^k-1 + x_i^k-1x_j + ... x_j^k-1 */
		    I->addPoly(ep);

		    /* reset monomial */
		    term.mon[i] = 0;
		    term.mon[j] = 0;
        }
	}

	/* return graph k-coloring ideal */
	return I;	
}


#endif
