#include <iostream>
#include <ctime>
using namespace std;

#include "shared/Graph.h"
#include "zchaff/SAT.h"

int sat3color(const Graph& g)
{
    SAT_Manager mng = SAT_InitManager();
    SAT_SetNumVariables(mng, g.getNumVertices()*3);
    int clause[3];
    for (int i = 0; i < g.getNumVertices(); ++i) {
        clause[0] = 2*(3*i+1); clause[1] = 2*(3*i+2); clause[2] = 2*(3*i+3);
        SAT_AddClause(mng, clause, 3);
    }
    for (int e = 0; e < g.getNumEdges(); ++e) {
        int ei = g.getEdge(e).i;
        int ej = g.getEdge(e).j;
        clause[0] = 2*(3*ei+1)+1; clause[1] = 2*(3*ej+1)+1;
        SAT_AddClause(mng, clause, 2);
        clause[0] = 2*(3*ei+2)+1; clause[1] = 2*(3*ej+2)+1;
        SAT_AddClause(mng, clause, 2);
        clause[0] = 2*(3*ei+3)+1; clause[1] = 2*(3*ej+3)+1;
        SAT_AddClause(mng, clause, 2);
    }
    int rvalue = SAT_Solve(mng);
    SAT_ReleaseManager(mng);
    return rvalue;
}
